/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.util.ArrayList;
import java.util.List;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseUsageModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseUsageSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverridePhaseUsageSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePhaseUsageModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverridePhaseUsageModelDao obj1 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        this.performTestInTransaction(new WithCatalogOverridePhaseUsageSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseUsageSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverridePhaseUsageModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)rehydrated.getUsageNumber(), (Object)obj1.getUsageNumber());
                Assert.assertEquals((Object)rehydrated.getUsageDefRecordId(), (Object)obj1.getUsageDefRecordId());
                Assert.assertEquals((Object)rehydrated.getTargetPhaseDefRecordId(), (Object)obj1.getTargetPhaseDefRecordId());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetPhaseDefinition() throws Exception {
        final CatalogOverridePhaseUsageModelDao obj1 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverridePhaseUsageModelDao obj2 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)2), Long.valueOf(5L), Long.valueOf(3L));
        final CatalogOverridePhaseUsageModelDao obj3 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(3L));
        final CatalogOverridePhaseUsageModelDao nobj1 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverridePhaseUsageSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseUsageSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                sqlDao.create(obj3, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                sqlDao.create(nobj1, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                keys.add("2,5");
                keys.add("4,7");
                List targetPhases = sqlDao.getTargetPhaseDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                Assert.assertEquals((int)targetPhases.size(), (int)1);
                Assert.assertEquals(targetPhases.get(0), (Object)new Long(3L));
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetPhaseDefWithSameUsageOverrideAndDifferentRecurringPriceOverride() throws Exception {
        final CatalogOverridePhaseUsageModelDao obj1 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverridePhaseUsageModelDao obj2 = new CatalogOverridePhaseUsageModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverridePhaseUsageSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseUsageSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                List targetPhases = sqlDao.getTargetPhaseDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverridePhaseUsageSqlDao.this.internalCallContext);
                Assert.assertEquals((int)targetPhases.size(), (int)2);
                Assert.assertEquals(targetPhases.get(0), (Object)new Long(3L));
                Assert.assertEquals(targetPhases.get(1), (Object)new Long(4L));
                return null;
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverridePhaseUsageSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseUsageSqlDao sqlDao = (CatalogOverridePhaseUsageSqlDao)handle.attach(CatalogOverridePhaseUsageSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverridePhaseUsageSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverridePhaseUsageSqlDao var1);
    }
}

