/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import com.google.common.io.Resources;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.DefaultTierPriceOverride;
import org.killbill.billing.catalog.DefaultTieredBlockPriceOverride;
import org.killbill.billing.catalog.DefaultUsagePriceOverride;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionModelDao;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCatalogOverrideDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testOverrideLastPhase() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarBasic.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("standard-monthly");
        PlanPhasePriceOverride[] resolvedOverrides = new PlanPhasePriceOverride[plan.getAllPhases().length];
        resolvedOverrides[0] = null;
        resolvedOverrides[1] = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, null, new BigDecimal("128.76"), null);
        CatalogOverridePlanDefinitionModelDao newPlan = this.catalogOverrideDao.getOrCreateOverridePlanDefinition((Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), resolvedOverrides, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((String)newPlan.getParentPlanName(), (String)"standard-monthly");
        Assert.assertTrue((boolean)newPlan.getIsActive());
    }

    @Test(groups={"slow"})
    public void testOverrideTwoOutOfThreePhases() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("discount-standard-monthly");
        PlanPhasePriceOverride[] resolvedOverrides = new PlanPhasePriceOverride[plan.getAllPhases().length];
        resolvedOverrides[0] = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[0].getName(), Currency.USD, BigDecimal.TEN, null, null);
        resolvedOverrides[1] = null;
        resolvedOverrides[2] = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, null, new BigDecimal("348.64"), null);
        CatalogOverridePlanDefinitionModelDao newPlan = this.catalogOverrideDao.getOrCreateOverridePlanDefinition((Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), resolvedOverrides, (InternalCallContext)this.internalCallContext);
        Assert.assertEquals((String)newPlan.getParentPlanName(), (String)"discount-standard-monthly");
        Assert.assertTrue((boolean)newPlan.getIsActive());
        List phases = this.catalogOverrideDao.getOverriddenPlanPhases(newPlan.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)phases.size(), (int)2);
    }

    @Test(groups={"slow"})
    public void testGetOverriddenPlanPhases() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("discount-standard-monthly");
        PlanPhasePriceOverride[] resolvedOverrides = new PlanPhasePriceOverride[plan.getAllPhases().length];
        resolvedOverrides[0] = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[0].getName(), Currency.USD, BigDecimal.TEN, BigDecimal.ONE, null);
        resolvedOverrides[1] = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[1].getName(), Currency.USD, BigDecimal.ONE, BigDecimal.TEN, null);
        resolvedOverrides[2] = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, BigDecimal.ZERO, new BigDecimal("348.64"), null);
        CatalogOverridePlanDefinitionModelDao newPlan = this.catalogOverrideDao.getOrCreateOverridePlanDefinition((Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), resolvedOverrides, (InternalCallContext)this.internalCallContext);
        List phases = this.catalogOverrideDao.getOverriddenPlanPhases(newPlan.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)phases.size(), (int)3);
        for (int i = 0; i < 3; ++i) {
            CatalogOverridePhaseDefinitionModelDao curPhase = (CatalogOverridePhaseDefinitionModelDao)phases.get(i);
            Assert.assertEquals((String)curPhase.getCurrency(), (String)resolvedOverrides[i].getCurrency().name());
            Assert.assertEquals((int)curPhase.getFixedPrice().compareTo(resolvedOverrides[i].getFixedPrice()), (int)0);
            Assert.assertEquals((int)curPhase.getRecurringPrice().compareTo(resolvedOverrides[i].getRecurringPrice()), (int)0);
            Assert.assertEquals((String)curPhase.getParentPhaseName(), (String)resolvedOverrides[i].getPhaseName());
        }
    }

    @Test(groups={"slow"})
    public void testGetOverriddenPlanPhasesWithUsageOverrides() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("gas-monthly");
        PlanPhasePriceOverride[] resolvedOverrides = new PlanPhasePriceOverride[plan.getAllPhases().length];
        ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides = new ArrayList<DefaultTieredBlockPriceOverride>();
        DefaultTieredBlockPriceOverride tieredBlockPriceOverride = new DefaultTieredBlockPriceOverride("gallons", new Double("1"), new BigDecimal(4), Currency.USD, new Double("100"));
        tieredBlockPriceOverrides.add(tieredBlockPriceOverride);
        ArrayList<DefaultTierPriceOverride> tierPriceOverrides = new ArrayList<DefaultTierPriceOverride>();
        DefaultTierPriceOverride tierPriceOverride = new DefaultTierPriceOverride(tieredBlockPriceOverrides);
        tierPriceOverrides.add(tierPriceOverride);
        ArrayList<DefaultUsagePriceOverride> usagePriceOverrides = new ArrayList<DefaultUsagePriceOverride>();
        DefaultUsagePriceOverride usagePriceOverride = new DefaultUsagePriceOverride("gas-monthly-in-arrear", UsageType.CONSUMABLE, tierPriceOverrides);
        usagePriceOverrides.add(usagePriceOverride);
        resolvedOverrides[0] = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, BigDecimal.ZERO, new BigDecimal("348.64"), usagePriceOverrides);
        CatalogOverridePlanDefinitionModelDao newPlan = this.catalogOverrideDao.getOrCreateOverridePlanDefinition((Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), resolvedOverrides, (InternalCallContext)this.internalCallContext);
        List phases = this.catalogOverrideDao.getOverriddenPlanPhases(newPlan.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)phases.size(), (int)1);
        CatalogOverridePhaseDefinitionModelDao curPhase = (CatalogOverridePhaseDefinitionModelDao)phases.get(0);
        Assert.assertEquals((String)curPhase.getCurrency(), (String)resolvedOverrides[0].getCurrency().name());
        Assert.assertEquals((int)curPhase.getFixedPrice().compareTo(resolvedOverrides[0].getFixedPrice()), (int)0);
        Assert.assertEquals((int)curPhase.getRecurringPrice().compareTo(resolvedOverrides[0].getRecurringPrice()), (int)0);
        Assert.assertEquals((String)curPhase.getParentPhaseName(), (String)resolvedOverrides[0].getPhaseName());
        List usages = this.catalogOverrideDao.getOverriddenPhaseUsages(curPhase.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)usages.size(), (int)1);
        CatalogOverrideUsageDefinitionModelDao curUsage = (CatalogOverrideUsageDefinitionModelDao)usages.get(0);
        Assert.assertEquals((String)curUsage.getParentUsageName(), (String)usagePriceOverride.getName());
        Assert.assertEquals((String)curUsage.getType(), (String)usagePriceOverride.getUsageType().toString());
        List tiers = this.catalogOverrideDao.getOverriddenUsageTiers(curUsage.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tiers.size(), (int)1);
        CatalogOverrideTierDefinitionModelDao curTier = (CatalogOverrideTierDefinitionModelDao)tiers.get(0);
        List tierBlocks = this.catalogOverrideDao.getOverriddenTierBlocks(curTier.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tierBlocks.size(), (int)1);
        CatalogOverrideBlockDefinitionModelDao curTieredBlock = (CatalogOverrideBlockDefinitionModelDao)tierBlocks.get(0);
        Assert.assertEquals((String)curTieredBlock.getParentUnitName(), (String)tieredBlockPriceOverride.getUnitName());
        Assert.assertEquals((int)curTieredBlock.getPrice().compareTo(tieredBlockPriceOverride.getPrice()), (int)0);
        Assert.assertEquals((Object)curTieredBlock.getSize(), (Object)tieredBlockPriceOverride.getSize());
        Assert.assertEquals((Object)curTieredBlock.getMax(), (Object)tieredBlockPriceOverride.getMax());
    }

    @Test(groups={"slow"})
    public void testGetOverrideOneOutOfTwoTieredBlocks() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"UsageExperimental.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("chocolate-monthly");
        PlanPhasePriceOverride[] resolvedOverrides = new PlanPhasePriceOverride[plan.getAllPhases().length];
        ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides = new ArrayList<DefaultTieredBlockPriceOverride>();
        DefaultTieredBlockPriceOverride tieredBlockPriceOverride = new DefaultTieredBlockPriceOverride("chocolate-videos", new Double("1"), new BigDecimal(0.75), Currency.USD, new Double("10000"));
        tieredBlockPriceOverrides.add(tieredBlockPriceOverride);
        ArrayList<DefaultTierPriceOverride> tierPriceOverrides = new ArrayList<DefaultTierPriceOverride>();
        DefaultTierPriceOverride tierPriceOverride = new DefaultTierPriceOverride(tieredBlockPriceOverrides);
        tierPriceOverrides.add(null);
        tierPriceOverrides.add(tierPriceOverride);
        ArrayList<DefaultUsagePriceOverride> usagePriceOverrides = new ArrayList<DefaultUsagePriceOverride>();
        DefaultUsagePriceOverride usagePriceOverride = new DefaultUsagePriceOverride("chocolate-monthly-videos", UsageType.CONSUMABLE, tierPriceOverrides);
        usagePriceOverrides.add(usagePriceOverride);
        resolvedOverrides[0] = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, null, null, usagePriceOverrides);
        CatalogOverridePlanDefinitionModelDao newPlan = this.catalogOverrideDao.getOrCreateOverridePlanDefinition((Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), resolvedOverrides, (InternalCallContext)this.internalCallContext);
        List phases = this.catalogOverrideDao.getOverriddenPlanPhases(newPlan.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)phases.size(), (int)1);
        CatalogOverridePhaseDefinitionModelDao curPhase = (CatalogOverridePhaseDefinitionModelDao)phases.get(0);
        Assert.assertEquals((String)curPhase.getCurrency(), (String)resolvedOverrides[0].getCurrency().name());
        Assert.assertNull((Object)curPhase.getFixedPrice());
        Assert.assertNull((Object)curPhase.getRecurringPrice());
        Assert.assertEquals((String)curPhase.getParentPhaseName(), (String)resolvedOverrides[0].getPhaseName());
        List usages = this.catalogOverrideDao.getOverriddenPhaseUsages(curPhase.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)usages.size(), (int)1);
        CatalogOverrideUsageDefinitionModelDao curUsage = (CatalogOverrideUsageDefinitionModelDao)usages.get(0);
        Assert.assertEquals((String)curUsage.getParentUsageName(), (String)usagePriceOverride.getName());
        Assert.assertEquals((String)curUsage.getType(), (String)usagePriceOverride.getUsageType().toString());
        List tiers = this.catalogOverrideDao.getOverriddenUsageTiers(curUsage.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tiers.size(), (int)1);
        CatalogOverrideTierDefinitionModelDao curTier = (CatalogOverrideTierDefinitionModelDao)tiers.get(0);
        List tierBlocks = this.catalogOverrideDao.getOverriddenTierBlocks(curTier.getRecordId(), (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((int)tierBlocks.size(), (int)1);
        CatalogOverrideBlockDefinitionModelDao curTieredBlock = (CatalogOverrideBlockDefinitionModelDao)tierBlocks.get(0);
        Assert.assertEquals((String)curTieredBlock.getParentUnitName(), (String)tieredBlockPriceOverride.getUnitName());
        Assert.assertEquals((int)curTieredBlock.getPrice().compareTo(tieredBlockPriceOverride.getPrice()), (int)0);
        Assert.assertEquals((Object)curTieredBlock.getSize(), (Object)tieredBlockPriceOverride.getSize());
        Assert.assertEquals((Object)curTieredBlock.getMax(), (Object)tieredBlockPriceOverride.getMax());
    }
}

