/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.math.BigDecimal;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverrideBlockDefinitionSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideBlockDefinitionModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverrideBlockDefinitionModelDao obj1 = new CatalogOverrideBlockDefinitionModelDao("p1", "USD", BigDecimal.ONE, 1.0, 1.0, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverrideBlockDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideBlockDefinitionSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideBlockDefinitionSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverrideBlockDefinitionModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverrideBlockDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((String)rehydrated.getParentUnitName(), (String)obj1.getParentUnitName());
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj1.getCurrency());
                Assert.assertEquals((int)rehydrated.getPrice().compareTo(obj1.getPrice()), (int)0);
                Assert.assertEquals((Object)rehydrated.getSize(), (Object)obj1.getSize());
                Assert.assertEquals((Object)rehydrated.getMax(), (Object)obj1.getMax());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetByAttributes() throws Exception {
        final CatalogOverrideBlockDefinitionModelDao objWithNoNullPrice = new CatalogOverrideBlockDefinitionModelDao("p2", "USD", BigDecimal.ONE, new Double("1").doubleValue(), new Double("5").doubleValue(), this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverrideBlockDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideBlockDefinitionSqlDao sqlDao) {
                sqlDao.create(objWithNoNullPrice, (InternalCallContext)TestCatalogOverrideBlockDefinitionSqlDao.this.internalCallContext);
                this.checkRehydrated(objWithNoNullPrice, sqlDao);
                return null;
            }

            private void checkRehydrated(CatalogOverrideBlockDefinitionModelDao obj, CatalogOverrideBlockDefinitionSqlDao sqlDao) {
                CatalogOverrideBlockDefinitionModelDao rehydrated = sqlDao.getByAttributes(obj.getParentUnitName(), obj.getCurrency(), obj.getPrice(), obj.getMax(), obj.getSize(), (InternalTenantContext)TestCatalogOverrideBlockDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((String)rehydrated.getParentUnitName(), (String)obj.getParentUnitName());
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj.getCurrency());
                Assert.assertEquals((int)rehydrated.getPrice().compareTo(obj.getPrice()), (int)0);
                Assert.assertEquals((Object)rehydrated.getSize(), (Object)obj.getSize());
                Assert.assertEquals((Object)rehydrated.getMax(), (Object)obj.getMax());
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverrideBlockDefinitionSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideBlockDefinitionSqlDao sqlDao = (CatalogOverrideBlockDefinitionSqlDao)handle.attach(CatalogOverrideBlockDefinitionSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverrideBlockDefinitionSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverrideBlockDefinitionSqlDao var1);
    }
}

