/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.rules.DefaultPlanRules;
import org.redisson.codec.SerializationCodec;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVersionedCatalog
extends CatalogTestSuiteNoDB {
    final DateTime dt1 = new DateTime((Object)"2010-01-01T00:00:00+00:00");
    final DateTime dt2 = new DateTime((Object)"2011-02-02T00:01:00+00:00");
    final DateTime dt2a = new DateTime((Object)"2011-02-03T00:01:00+00:00");
    final DateTime dEffectiveDateForExistingSubscriptions = new DateTime((Object)"2011-02-14T00:01:00+00:00");
    final DateTime dt3 = new DateTime((Object)"2011-03-03T00:01:00+00:00");
    private DefaultVersionedCatalog vc;

    @Override
    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        this.vc = this.loader.loadDefaultCatalog("versionedCatalog");
    }

    @Test(groups={"fast"}, description="See https://github.com/killbill/killbill/issues/1110")
    public void testFindPlanAcrossVersions() throws Exception {
        DateTime subscriptionChangePlanDate = new DateTime((Object)"2011-02-02T00:01:00+00:00");
        Plan plan = this.vc.findPlan("shotgun-quarterly", this.dt2, subscriptionChangePlanDate);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
        plan = this.vc.findPlan("shotgun-quarterly", this.dt2a, subscriptionChangePlanDate);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
    }

    @Test(groups={"fast"})
    public void testFindPlanAcrossVersionsUsingEffectiveDateForExistingSubscriptions() throws Exception {
        Plan plan = this.vc.findPlan("pistol-monthly", this.dt1, this.dt1);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        plan = this.vc.findPlan("pistol-monthly", this.dt2, this.dt2);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.findPlan("pistol-monthly", this.dEffectiveDateForExistingSubscriptions, this.dEffectiveDateForExistingSubscriptions);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.findPlan("pistol-monthly", this.dt3, this.dt3);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("49.95"));
        DateTime subscriptionChangePlanDate = new DateTime((Object)"2011-01-01T00:01:00+00:00");
        plan = this.vc.findPlan("pistol-monthly", this.dt2, subscriptionChangePlanDate);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        plan = this.vc.findPlan("pistol-monthly", this.dEffectiveDateForExistingSubscriptions, subscriptionChangePlanDate);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.findPlan("pistol-monthly", this.dt3, subscriptionChangePlanDate);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
    }

    @Test(groups={"fast"})
    public void testFindPlanWithDatesAndPlanSpecifier() throws Exception {
        PlanSpecifier pistolMonthly = new PlanSpecifier("Pistol", BillingPeriod.MONTHLY, "DEFAULT");
        Plan plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dt1, this.dt1);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dt2, this.dt2);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dEffectiveDateForExistingSubscriptions, this.dEffectiveDateForExistingSubscriptions);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dt3, this.dt3);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("49.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dt2, this.dt1);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dEffectiveDateForExistingSubscriptions, this.dt1);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        plan = this.vc.createOrFindPlan(pistolMonthly, null, this.dt3, this.dt1);
        Assert.assertEquals((Object)plan.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
    }

    @Test(groups={"fast"})
    public void testErrorOnDateTooEarly() throws CatalogApiException {
        this.vc.findPlan("shotgun-monthly", this.dt1);
        try {
            this.vc.findPlan("shotgun-quarterly", this.dt1);
            Assert.fail((String)"Date is too early an exception should have been thrown");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PLAN.getCode());
        }
    }

    @Test(groups={"fast"})
    public void testWithDeletedPlan() throws CatalogApiException {
        this.vc.findPlan("shotgun-quarterly", this.dt2);
        try {
            this.vc.findPlan("shotgun-quarterly", this.dt3);
            Assert.fail((String)"Plan has been removed");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PLAN.getCode());
        }
        this.vc.findPlan("shotgun-quarterly", this.dt3, this.dt1);
    }

    @Test(groups={"fast"})
    public void testDefaultPlanRulesExternalizable() throws IOException {
        SerializationCodec codec = new SerializationCodec();
        ByteBuf byteBuf = codec.getValueEncoder().encode((Object)((StandaloneCatalog)this.vc.getVersions().get(0)).getPlanRules());
        DefaultPlanRules planRules = (DefaultPlanRules)codec.getValueDecoder().decode(byteBuf, null);
        Assert.assertEquals((Object)planRules, (Object)((StandaloneCatalog)this.vc.getVersions().get(0)).getPlanRules());
    }

    @Test(groups={"fast"})
    public void testProductExternalizable() throws IOException {
        SerializationCodec codec = new SerializationCodec();
        for (Product product : ((StandaloneCatalog)this.vc.getVersions().get(0)).getCatalogEntityCollectionProduct().getEntries()) {
            ByteBuf byteBuf = codec.getValueEncoder().encode((Object)product);
            Product product2 = (Product)codec.getValueDecoder().decode(byteBuf, null);
            Assert.assertEquals((Object)product2, (Object)product);
        }
    }

    @Test(groups={"fast"})
    public void testCatalogEntityCollectionProductExternalizable() throws IOException {
        SerializationCodec codec = new SerializationCodec();
        ByteBuf byteBuf = codec.getValueEncoder().encode((Object)((StandaloneCatalog)this.vc.getVersions().get(0)).getCatalogEntityCollectionProduct());
        CatalogEntityCollection products = (CatalogEntityCollection)codec.getValueDecoder().decode(byteBuf, null);
        Assert.assertEquals((Collection)products, (Collection)((StandaloneCatalog)this.vc.getVersions().get(0)).getCatalogEntityCollectionProduct());
    }

    @Test(groups={"fast"})
    public void testStandaloneCatalogExternalizable() throws IOException {
        SerializationCodec codec = new SerializationCodec();
        ByteBuf byteBuf = codec.getValueEncoder().encode(this.vc.getVersions().get(0));
        StandaloneCatalog standaloneCatalog = (StandaloneCatalog)codec.getValueDecoder().decode(byteBuf, null);
        Assert.assertEquals((Object)standaloneCatalog, this.vc.getVersions().get(0));
    }
}

