/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.override.DefaultPriceOverride;
import org.killbill.xmlloader.XMLLoader;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStandaloneCatalogWithPriceOverride
extends CatalogTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"}, description="https://github.com/killbill/killbill/issues/842")
    public void testCreateAmbiguousPlan() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        StandaloneCatalogWithPriceOverride standaloneCatalogWithPriceOverride = new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, this.internalCallContext.getTenantRecordId(), this.internalCallContextFactory);
        PlanSpecifier spec = new PlanSpecifier("standard-monthly-67890");
        PlanPhasePriceOverridesWithCallContext overrides = (PlanPhasePriceOverridesWithCallContext)Mockito.mock(PlanPhasePriceOverridesWithCallContext.class);
        Mockito.when((Object)overrides.getCallContext()).thenReturn((Object)this.callContext);
        DefaultPlanPhasePriceOverride override = new DefaultPlanPhasePriceOverride("standard-monthly-evergreen", Currency.USD, null, BigDecimal.ONE, (List)ImmutableList.of());
        Mockito.when((Object)overrides.getOverrides()).thenReturn((Object)ImmutableList.of((Object)override));
        Plan plan = standaloneCatalogWithPriceOverride.createOrFindCurrentPlan(spec, overrides);
        Assert.assertTrue((boolean)plan.getName().startsWith("standard-monthly-67890-"));
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(plan.getName());
        Assert.assertTrue((boolean)m.matches());
        Assert.assertNotNull((Object)catalog.findCurrentPlan("standard-monthly"));
        Assert.assertNotNull((Object)standaloneCatalogWithPriceOverride.findCurrentPlan("standard-monthly"));
        try {
            catalog.findCurrentPlan(plan.getName());
            Assert.fail();
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PLAN.getCode());
        }
        Assert.assertNotNull((Object)standaloneCatalogWithPriceOverride.findCurrentPlan("standard-monthly-1"));
        Assert.assertNotNull((Object)catalog.findCurrentPlan("standard-monthly-12345"));
        Assert.assertNotNull((Object)standaloneCatalogWithPriceOverride.findCurrentPlan("standard-monthly-12345"));
    }

    @Test(groups={"slow"})
    public void testCreatePlanNoProduct() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        StandaloneCatalogWithPriceOverride standaloneCatalogWithPriceOverride = new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, this.internalCallContext.getTenantRecordId(), this.internalCallContextFactory);
        try {
            PlanSpecifier specWithNullProduct = new PlanSpecifier(null, BillingPeriod.ANNUAL, "DEFAULT");
            standaloneCatalogWithPriceOverride.createOrFindCurrentPlan(specWithNullProduct, null);
            Assert.fail();
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NULL_PRODUCT_NAME.getCode());
        }
    }

    @Test(groups={"slow"})
    public void testCreatePlanInvalidProduct() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        StandaloneCatalogWithPriceOverride standaloneCatalogWithPriceOverride = new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, this.internalCallContext.getTenantRecordId(), this.internalCallContextFactory);
        try {
            PlanSpecifier specWithNullProduct = new PlanSpecifier("INVALID", BillingPeriod.ANNUAL, "DEFAULT");
            standaloneCatalogWithPriceOverride.createOrFindCurrentPlan(specWithNullProduct, null);
            Assert.fail();
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PRODUCT.getCode());
        }
    }
}

