/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.xmlloader.ValidationErrors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPlan
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testDateValidation() {
        MockCatalog c = new MockCatalog();
        c.setSupportedCurrencies(new Currency[]{Currency.GBP, Currency.EUR, Currency.USD, Currency.BRL, Currency.MXN});
        MockPlan p1 = MockPlan.createBicycleTrialEvergreen1USD();
        p1.setPlansAllowedInBundle(-1);
        p1.setEffectiveDateForExistingSubscriptions(new Date(new Date().getTime() - 86400000L));
        ValidationErrors errors = p1.validate(c, new ValidationErrors());
        Assert.assertEquals((int)errors.size(), (int)3);
        errors.log(log);
    }

    @Test(groups={"fast"})
    public void testDataCalc() {
        MockPlan p0 = MockPlan.createBicycleTrialEvergreen1USD();
        MockPlan p1 = MockPlan.createBicycleTrialEvergreen1USD(100);
        MockPlan p2 = MockPlan.createBicycleNoTrialEvergreen1USD();
        DateTime requestedDate = new DateTime();
        Assert.assertEquals((int)p0.dateOfFirstRecurringNonZeroCharge(requestedDate, null).compareTo((ReadableInstant)requestedDate.plusDays(30)), (int)0);
        Assert.assertEquals((int)p1.dateOfFirstRecurringNonZeroCharge(requestedDate, null).compareTo((ReadableInstant)requestedDate.plusDays(100)), (int)0);
        Assert.assertEquals((int)p2.dateOfFirstRecurringNonZeroCharge(requestedDate, null).compareTo((ReadableInstant)requestedDate.plusDays(0)), (int)0);
    }
}

