/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.IllegalPlanChange;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.rules.CaseBillingAlignment;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.api.rules.CaseChangePlanAlignment;
import org.killbill.billing.catalog.api.rules.CaseChangePlanPolicy;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;
import org.killbill.billing.catalog.api.rules.CasePriceList;
import org.killbill.billing.catalog.api.rules.PlanRules;
import org.killbill.billing.catalog.rules.DefaultCase;
import org.killbill.billing.catalog.rules.DefaultCaseBillingAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseCancelPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseChange;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseCreateAlignment;
import org.killbill.billing.catalog.rules.DefaultCasePhase;
import org.killbill.billing.catalog.rules.DefaultCasePriceList;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPlanRules
extends ValidatingConfig<StandaloneCatalog>
implements PlanRules {
    @XmlElementWrapper(name="changePolicy")
    @XmlElement(name="changePolicyCase", required=false)
    private DefaultCaseChangePlanPolicy[] changeCase;
    @XmlElementWrapper(name="changeAlignment")
    @XmlElement(name="changeAlignmentCase", required=false)
    private DefaultCaseChangePlanAlignment[] changeAlignmentCase;
    @XmlElementWrapper(name="cancelPolicy")
    @XmlElement(name="cancelPolicyCase", required=false)
    private DefaultCaseCancelPolicy[] cancelCase;
    @XmlElementWrapper(name="createAlignment")
    @XmlElement(name="createAlignmentCase", required=false)
    private DefaultCaseCreateAlignment[] createAlignmentCase;
    @XmlElementWrapper(name="billingAlignment")
    @XmlElement(name="billingAlignmentCase", required=false)
    private DefaultCaseBillingAlignment[] billingAlignmentCase;
    @XmlElementWrapper(name="priceList")
    @XmlElement(name="priceListCase", required=false)
    private DefaultCasePriceList[] priceListCase;

    public Iterable<CaseChangePlanPolicy> getCaseChangePlanPolicy() {
        return ImmutableList.copyOf((Object[])this.changeCase);
    }

    public Iterable<CaseChangePlanAlignment> getCaseChangePlanAlignment() {
        return ImmutableList.copyOf((Object[])this.changeAlignmentCase);
    }

    public Iterable<CaseCancelPolicy> getCaseCancelPolicy() {
        return ImmutableList.copyOf((Object[])this.cancelCase);
    }

    public Iterable<CaseCreateAlignment> getCaseCreateAlignment() {
        return ImmutableList.copyOf((Object[])this.createAlignmentCase);
    }

    public Iterable<CaseBillingAlignment> getCaseBillingAlignment() {
        return ImmutableList.copyOf((Object[])this.billingAlignmentCase);
    }

    public Iterable<CasePriceList> getCasePriceList() {
        return ImmutableList.copyOf((Object[])this.priceListCase);
    }

    public PlanAlignmentCreate getPlanCreateAlignment(PlanSpecifier specifier, StaticCatalog catalog) throws CatalogApiException {
        PlanAlignmentCreate result = (PlanAlignmentCreate)DefaultCase.getResult(this.createAlignmentCase, specifier, catalog);
        return result != null ? result : PlanAlignmentCreate.START_OF_BUNDLE;
    }

    public BillingActionPolicy getPlanCancelPolicy(PlanPhaseSpecifier planPhase, StaticCatalog catalog) throws CatalogApiException {
        BillingActionPolicy result = (BillingActionPolicy)DefaultCasePhase.getResult(this.cancelCase, planPhase, catalog);
        return result != null ? result : BillingActionPolicy.END_OF_TERM;
    }

    public BillingAlignment getBillingAlignment(PlanPhaseSpecifier planPhase, StaticCatalog catalog) throws CatalogApiException {
        BillingAlignment result = (BillingAlignment)DefaultCasePhase.getResult(this.billingAlignmentCase, planPhase, catalog);
        return result != null ? result : BillingAlignment.ACCOUNT;
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to, StaticCatalog catalog) throws CatalogApiException {
        DefaultPriceList toPriceList = to.getPriceListName() != null ? (DefaultPriceList)catalog.findCurrentPricelist(to.getPriceListName()) : this.findPriceList((PlanSpecifier)from, catalog);
        PlanSpecifier toWithPriceList = to.getPlanName() == null ? new PlanSpecifier(to.getProductName(), to.getBillingPeriod(), toPriceList.getName()) : to;
        BillingActionPolicy policy = this.getPlanChangePolicy(from, toWithPriceList, catalog);
        if (policy == BillingActionPolicy.ILLEGAL) {
            throw new IllegalPlanChange(from, toWithPriceList);
        }
        PlanAlignmentChange alignment = this.getPlanChangeAlignment(from, toWithPriceList, catalog);
        return new PlanChangeResult((PriceList)toPriceList, policy, alignment);
    }

    private PlanAlignmentChange getPlanChangeAlignment(PlanPhaseSpecifier from, PlanSpecifier to, StaticCatalog catalog) throws CatalogApiException {
        PlanAlignmentChange result = (PlanAlignmentChange)DefaultCaseChange.getResult(this.changeAlignmentCase, from, to, catalog);
        return result != null ? result : PlanAlignmentChange.START_OF_BUNDLE;
    }

    private BillingActionPolicy getPlanChangePolicy(PlanPhaseSpecifier from, PlanSpecifier to, StaticCatalog catalog) throws CatalogApiException {
        BillingActionPolicy result = (BillingActionPolicy)DefaultCaseChange.getResult(this.changeCase, from, to, catalog);
        return result != null ? result : BillingActionPolicy.END_OF_TERM;
    }

    private DefaultPriceList findPriceList(PlanSpecifier specifier, StaticCatalog catalog) throws CatalogApiException {
        DefaultPriceList result = (DefaultPriceList)((Object)DefaultCasePriceList.getResult(this.priceListCase, specifier, catalog));
        if (result == null) {
            String priceListName = specifier.getPlanName() != null ? catalog.findCurrentPlan(specifier.getPlanName()).getPriceListName() : specifier.getPriceListName();
            result = (DefaultPriceList)catalog.findCurrentPricelist(priceListName);
        }
        return result;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        HashSet<DefaultCaseChangePlanPolicy> caseChangePlanPoliciesSet = new HashSet<DefaultCaseChangePlanPolicy>();
        boolean foundDefaultCase = false;
        for (DefaultCaseChangePlanPolicy cur : this.changeCase) {
            if (caseChangePlanPoliciesSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for change plan %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                caseChangePlanPoliciesSet.add(cur);
            }
            if (cur.getPhaseType() == null && cur.getFromProduct() == null && cur.getFromProductCategory() == null && cur.getFromBillingPeriod() == null && cur.getFromPriceList() == null && cur.getToProduct() == null && cur.getToProductCategory() == null && cur.getToBillingPeriod() == null && cur.getToPriceList() == null) {
                foundDefaultCase = true;
            }
            cur.validate(catalog, errors);
        }
        if (!foundDefaultCase) {
            errors.add((Object)new ValidationError("Missing default rule case for plan change", catalog.getCatalogURI(), DefaultPlanRules.class, ""));
        }
        HashSet<DefaultCaseCancelPolicy> defaultCaseCancelPoliciesSet = new HashSet<DefaultCaseCancelPolicy>();
        foundDefaultCase = false;
        for (DefaultCaseCancelPolicy cur : this.cancelCase) {
            if (defaultCaseCancelPoliciesSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for plan cancellation %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                defaultCaseCancelPoliciesSet.add(cur);
            }
            if (cur.getPhaseType() == null && cur.getProduct() == null && cur.getProductCategory() == null && cur.getBillingPeriod() == null && cur.getPriceList() == null) {
                foundDefaultCase = true;
            }
            cur.validate(catalog, errors);
        }
        if (!foundDefaultCase) {
            errors.add((Object)new ValidationError("Missing default rule case for plan cancellation", catalog.getCatalogURI(), DefaultPlanRules.class, ""));
        }
        HashSet<DefaultCaseChangePlanAlignment> caseChangePlanAlignmentsSet = new HashSet<DefaultCaseChangePlanAlignment>();
        for (DefaultCaseChangePlanAlignment cur : this.changeAlignmentCase) {
            if (caseChangePlanAlignmentsSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for plan change alignment %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                caseChangePlanAlignmentsSet.add(cur);
            }
            cur.validate(catalog, errors);
        }
        HashSet<DefaultCaseCreateAlignment> caseCreateAlignmentsSet = new HashSet<DefaultCaseCreateAlignment>();
        for (DefaultCaseCreateAlignment cur : this.createAlignmentCase) {
            if (caseCreateAlignmentsSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for create plan alignment %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                caseCreateAlignmentsSet.add(cur);
            }
            cur.validate(catalog, errors);
        }
        HashSet<DefaultCaseBillingAlignment> caseBillingAlignmentsSet = new HashSet<DefaultCaseBillingAlignment>();
        for (DefaultCaseBillingAlignment cur : this.billingAlignmentCase) {
            if (caseBillingAlignmentsSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for billing alignment %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                caseBillingAlignmentsSet.add(cur);
            }
            cur.validate(catalog, errors);
        }
        HashSet<DefaultCasePriceList> casePriceListsSet = new HashSet<DefaultCasePriceList>();
        for (DefaultCasePriceList cur : this.priceListCase) {
            if (casePriceListsSet.contains((Object)cur)) {
                errors.add((Object)new ValidationError(String.format("Duplicate rule for price list transition %s", cur.toString()), catalog.getCatalogURI(), DefaultPlanRules.class, ""));
            } else {
                casePriceListsSet.add(cur);
            }
            cur.validate(catalog, errors);
        }
        return errors;
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue((Object)this);
        for (DefaultCaseChangePlanPolicy defaultCaseChangePlanPolicy : this.changeCase) {
            defaultCaseChangePlanPolicy.initialize(catalog, sourceURI);
        }
        for (DefaultCaseChange defaultCaseChange : this.changeAlignmentCase) {
            defaultCaseChange.initialize(catalog, sourceURI);
        }
        for (ValidatingConfig validatingConfig : this.cancelCase) {
            validatingConfig.initialize(catalog, sourceURI);
        }
        for (ValidatingConfig validatingConfig : this.createAlignmentCase) {
            validatingConfig.initialize(catalog, sourceURI);
        }
        for (ValidatingConfig validatingConfig : this.billingAlignmentCase) {
            validatingConfig.initialize(catalog, sourceURI);
        }
        for (ValidatingConfig validatingConfig : this.priceListCase) {
            validatingConfig.initialize(catalog, sourceURI);
        }
    }

    public DefaultPlanRules setChangeCase(DefaultCaseChangePlanPolicy[] changeCase) {
        this.changeCase = changeCase;
        return this;
    }

    public DefaultPlanRules setChangeAlignmentCase(DefaultCaseChangePlanAlignment[] changeAlignmentCase) {
        this.changeAlignmentCase = changeAlignmentCase;
        return this;
    }

    public DefaultPlanRules setCancelCase(DefaultCaseCancelPolicy[] cancelCase) {
        this.cancelCase = cancelCase;
        return this;
    }

    public DefaultPlanRules setCreateAlignmentCase(DefaultCaseCreateAlignment[] createAlignmentCase) {
        this.createAlignmentCase = createAlignmentCase;
        return this;
    }

    public DefaultPlanRules setBillingAlignmentCase(DefaultCaseBillingAlignment[] billingAlignmentCase) {
        this.billingAlignmentCase = billingAlignmentCase;
        return this;
    }

    public DefaultPlanRules setPriceListCase(DefaultCasePriceList[] priceListCase) {
        this.priceListCase = priceListCase;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlanRules)) {
            return false;
        }
        DefaultPlanRules that = (DefaultPlanRules)((Object)o);
        if (!Arrays.equals((Object[])this.billingAlignmentCase, (Object[])that.billingAlignmentCase)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.cancelCase, (Object[])that.cancelCase)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.changeAlignmentCase, (Object[])that.changeAlignmentCase)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.changeCase, (Object[])that.changeCase)) {
            return false;
        }
        if (!Arrays.equals((Object[])this.createAlignmentCase, (Object[])that.createAlignmentCase)) {
            return false;
        }
        return Arrays.equals((Object[])this.priceListCase, (Object[])that.priceListCase);
    }

    public int hashCode() {
        int result = this.changeCase != null ? Arrays.hashCode((Object[])this.changeCase) : 0;
        result = 31 * result + (this.changeAlignmentCase != null ? Arrays.hashCode((Object[])this.changeAlignmentCase) : 0);
        result = 31 * result + (this.cancelCase != null ? Arrays.hashCode((Object[])this.cancelCase) : 0);
        result = 31 * result + (this.createAlignmentCase != null ? Arrays.hashCode((Object[])this.createAlignmentCase) : 0);
        result = 31 * result + (this.billingAlignmentCase != null ? Arrays.hashCode((Object[])this.billingAlignmentCase) : 0);
        result = 31 * result + (this.priceListCase != null ? Arrays.hashCode((Object[])this.priceListCase) : 0);
        return result;
    }
}

