/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import java.net.URI;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultCase<T>
extends ValidatingConfig<StandaloneCatalog> {
    protected abstract T getResult();

    public abstract DefaultProduct getProduct();

    public abstract ProductCategory getProductCategory();

    public abstract BillingPeriod getBillingPeriod();

    public abstract DefaultPriceList getPriceList();

    public T getResult(PlanSpecifier planPhase, StaticCatalog c) throws CatalogApiException {
        if (this.satisfiesCase(planPhase, c)) {
            return this.getResult();
        }
        return null;
    }

    protected boolean satisfiesCase(PlanSpecifier planPhase, StaticCatalog c) throws CatalogApiException {
        PriceList priceList;
        ProductCategory productCategory;
        BillingPeriod billingPeriod;
        Product product;
        if (planPhase.getPlanName() != null) {
            Plan plan = c.findCurrentPlan(planPhase.getPlanName());
            product = plan.getProduct();
            billingPeriod = plan.getRecurringBillingPeriod();
            productCategory = plan.getProduct().getCategory();
            priceList = c.findCurrentPricelist(plan.getPriceListName());
        } else {
            product = c.findCurrentProduct(planPhase.getProductName());
            billingPeriod = planPhase.getBillingPeriod();
            productCategory = product.getCategory();
            priceList = this.getPriceList() != null ? c.findCurrentPricelist(planPhase.getPriceListName()) : null;
        }
        return !(this.getProduct() != null && !this.getProduct().equals(product) || this.getProductCategory() != null && !this.getProductCategory().equals((Object)productCategory) || this.getBillingPeriod() != null && !this.getBillingPeriod().equals((Object)billingPeriod) || this.getPriceList() != null && !this.getPriceList().equals(priceList));
    }

    public static <K> K getResult(DefaultCase<K>[] cases, PlanSpecifier planSpec, StaticCatalog catalog) throws CatalogApiException {
        if (cases != null) {
            for (DefaultCase<K> c : cases) {
                K result = c.getResult(planSpec, catalog);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue((Object)this);
    }

    protected abstract DefaultCase<T> setProduct(Product var1);

    protected abstract DefaultCase<T> setProductCategory(ProductCategory var1);

    protected abstract DefaultCase<T> setBillingPeriod(BillingPeriod var1);

    protected abstract DefaultCase<T> setPriceList(DefaultPriceList var1);
}

