/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.annotations.VisibleForTesting;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.util.cache.ExternalizableInput;
import org.killbill.billing.util.cache.ExternalizableOutput;
import org.killbill.billing.util.cache.MapperHolder;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPlan
extends ValidatingConfig<StandaloneCatalog>
implements Plan,
Externalizable {
    private static final long serialVersionUID = -4159932819592790086L;
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlAttribute(required=false)
    private String prettyName;
    @XmlElement(required=false)
    private Date effectiveDateForExistingSubscriptions;
    @XmlElement(required=true)
    @XmlIDREF
    private DefaultProduct product;
    @XmlElement(required=false)
    private BillingMode recurringBillingMode;
    @XmlElementWrapper(name="initialPhases", required=false)
    @XmlElement(name="phase", required=false)
    private DefaultPlanPhase[] initialPhases;
    @XmlElement(name="finalPhase", required=true)
    private DefaultPlanPhase finalPhase;
    @XmlElement(required=false)
    private Integer plansAllowedInBundle;
    private String priceListName;
    @VisibleForTesting
    StandaloneCatalog staticCatalog;

    public DefaultPlan() {
        this.initialPhases = new DefaultPlanPhase[0];
    }

    public DefaultPlan(StandaloneCatalog staticCatalog) {
        this.staticCatalog = staticCatalog;
        this.initialPhases = new DefaultPlanPhase[0];
    }

    public DefaultPlan(StandaloneCatalog staticCatalog, String planName, DefaultPlan in, PlanPhasePriceOverride[] overrides) {
        this.staticCatalog = staticCatalog;
        this.name = planName;
        this.effectiveDateForExistingSubscriptions = in.getEffectiveDateForExistingSubscriptions();
        this.product = (DefaultProduct)in.getProduct();
        this.initialPhases = new DefaultPlanPhase[in.getInitialPhases().length];
        for (int i = 0; i < overrides.length - 1; ++i) {
            DefaultPlanPhase newPhase;
            this.initialPhases[i] = newPhase = new DefaultPlanPhase(this, in.getInitialPhases()[i], overrides[i]);
        }
        this.finalPhase = new DefaultPlanPhase(this, in.getFinalPhase(), overrides[overrides.length - 1]);
        this.priceListName = in.getPriceListName();
        this.recurringBillingMode = in.getRecurringBillingMode();
    }

    public Date getEffectiveDateForExistingSubscriptions() {
        return this.effectiveDateForExistingSubscriptions;
    }

    public StaticCatalog getCatalog() {
        return this.staticCatalog;
    }

    public BillingMode getRecurringBillingMode() {
        return this.recurringBillingMode;
    }

    public DefaultPlanPhase[] getInitialPhases() {
        return this.initialPhases;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getPriceListName() {
        return this.priceListName;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public DefaultPlanPhase getFinalPhase() {
        return this.finalPhase;
    }

    public PlanPhase[] getAllPhases() {
        int length = this.initialPhases.length + 1;
        PlanPhase[] allPhases = new DefaultPlanPhase[length];
        int cnt = 0;
        if (length > 1) {
            for (DefaultPlanPhase cur : this.initialPhases) {
                allPhases[cnt++] = cur;
            }
        }
        allPhases[cnt++] = this.finalPhase;
        return allPhases;
    }

    public PlanPhase findPhase(String name) throws CatalogApiException {
        for (PlanPhase pp : this.getAllPhases()) {
            if (!pp.getName().equals(name)) continue;
            return pp;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PHASE, new Object[]{name});
    }

    public BillingPeriod getRecurringBillingPeriod() {
        return this.finalPhase.getRecurring() != null ? this.finalPhase.getRecurring().getBillingPeriod() : BillingPeriod.NO_BILLING_PERIOD;
    }

    public int getPlansAllowedInBundle() {
        return this.plansAllowedInBundle;
    }

    public Iterator<PlanPhase> getInitialPhaseIterator() {
        ArrayList list = new ArrayList();
        Collections.addAll(list, this.initialPhases);
        return list.iterator();
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        if (this.prettyName == null) {
            this.prettyName = this.name;
        }
        if (this.finalPhase != null) {
            this.finalPhase.setPlan(this);
            this.finalPhase.initialize(catalog, sourceURI);
        }
        for (DefaultPlanPhase p : this.initialPhases) {
            p.setPlan(this);
            p.initialize(catalog, sourceURI);
        }
        if (this.recurringBillingMode == null) {
            this.recurringBillingMode = catalog.getRecurringBillingMode();
        }
        this.priceListName = this.priceListName != null ? this.priceListName : this.findPriceListForPlan(catalog);
        this.staticCatalog = catalog;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.effectiveDateForExistingSubscriptions != null && catalog.getEffectiveDate().getTime() > this.effectiveDateForExistingSubscriptions.getTime()) {
            errors.add((Object)new ValidationError(String.format("Price effective date %s is before catalog effective date '%s'", this.effectiveDateForExistingSubscriptions, catalog.getEffectiveDate()), catalog.getCatalogURI(), DefaultPlan.class, ""));
        }
        if (this.recurringBillingMode == null) {
            errors.add((Object)new ValidationError(String.format("Invalid reccuring billingMode for plan '%s'", this.name), catalog.getCatalogURI(), DefaultPlan.class, ""));
        }
        if (this.product == null) {
            errors.add((Object)new ValidationError(String.format("Invalid product for plan '%s'", this.name), catalog.getCatalogURI(), DefaultPlan.class, ""));
        }
        for (DefaultPlanPhase cur : this.initialPhases) {
            cur.validate(catalog, errors);
            if (cur.getPhaseType() != PhaseType.EVERGREEN) continue;
            errors.add((Object)new ValidationError(String.format("Initial Phase %s of plan %s cannot be of type %s", cur.getName(), this.name, cur.getPhaseType()), catalog.getCatalogURI(), DefaultPlan.class, ""));
        }
        this.finalPhase.validate(catalog, errors);
        if (this.finalPhase.getPhaseType() == PhaseType.TRIAL || this.finalPhase.getPhaseType() == PhaseType.DISCOUNT) {
            errors.add((Object)new ValidationError(String.format("Final Phase %s of plan %s cannot be of type %s", this.finalPhase.getName(), this.name, this.finalPhase.getPhaseType()), catalog.getCatalogURI(), DefaultPlan.class, ""));
        }
        if (this.plansAllowedInBundle == null) {
            throw new IllegalStateException("plansAllowedInBundle should have been automatically been initialized with DEFAULT_NON_REQUIRED_INTEGER_FIELD_VALUE (-1)");
        }
        return errors;
    }

    public void setEffectiveDateForExistingSubscriptions(Date effectiveDateForExistingSubscriptions) {
        this.effectiveDateForExistingSubscriptions = effectiveDateForExistingSubscriptions;
    }

    public DefaultPlan setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultPlan setPrettyName(String prettyName) {
        this.prettyName = prettyName;
        return this;
    }

    public DefaultPlan setFinalPhase(DefaultPlanPhase finalPhase) {
        this.finalPhase = finalPhase;
        return this;
    }

    public DefaultPlan setProduct(Product product) {
        this.product = (DefaultProduct)product;
        return this;
    }

    public DefaultPlan setPriceListName(String priceListName) {
        this.priceListName = priceListName;
        return this;
    }

    public DefaultPlan setInitialPhases(DefaultPlanPhase[] phases) {
        this.initialPhases = phases;
        return this;
    }

    public DefaultPlan setPlansAllowedInBundle(Integer plansAllowedInBundle) {
        this.plansAllowedInBundle = plansAllowedInBundle;
        return this;
    }

    public DefaultPlan setRecurringBillingMode(BillingMode billingMode) {
        this.recurringBillingMode = billingMode;
        return this;
    }

    public DateTime dateOfFirstRecurringNonZeroCharge(DateTime subscriptionStartDate, PhaseType initialPhaseType) {
        DateTime result = subscriptionStartDate;
        boolean skipPhase = initialPhaseType != null;
        for (PlanPhase phase : this.getAllPhases()) {
            if (skipPhase) {
                if (phase.getPhaseType() != initialPhaseType) continue;
                skipPhase = false;
            }
            Recurring recurring = phase.getRecurring();
            if (phase.getDuration().getUnit() == TimeUnit.UNLIMITED || recurring != null && recurring.getRecurringPrice() != null && !recurring.getRecurringPrice().isZero()) break;
            try {
                result = phase.getDuration().addToDateTime(result);
            }
            catch (CatalogApiException catalogApiException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlan)) {
            return false;
        }
        DefaultPlan that = (DefaultPlan)o;
        if (this.effectiveDateForExistingSubscriptions != null ? !this.effectiveDateForExistingSubscriptions.equals(that.effectiveDateForExistingSubscriptions) : that.effectiveDateForExistingSubscriptions != null) {
            return false;
        }
        if (this.finalPhase != null ? !this.finalPhase.equals((Object)that.finalPhase) : that.finalPhase != null) {
            return false;
        }
        if (!Arrays.equals((Object[])this.initialPhases, (Object[])that.initialPhases)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.plansAllowedInBundle != null ? !this.plansAllowedInBundle.equals(that.plansAllowedInBundle) : that.plansAllowedInBundle != null) {
            return false;
        }
        return !(this.product != null ? !this.product.equals((Object)that.product) : that.product != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.effectiveDateForExistingSubscriptions != null ? this.effectiveDateForExistingSubscriptions.hashCode() : 0);
        result = 31 * result + (this.initialPhases != null ? Arrays.hashCode((Object[])this.initialPhases) : 0);
        result = 31 * result + (this.finalPhase != null ? this.finalPhase.hashCode() : 0);
        result = 31 * result + (this.plansAllowedInBundle != null ? this.plansAllowedInBundle.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultPlan [name=" + this.name + ", effectiveDateForExistingSubscriptions=" + this.effectiveDateForExistingSubscriptions + ", product=" + this.product.getName() + ", initialPhases=" + Arrays.toString((Object[])this.initialPhases) + ", finalPhase=" + this.finalPhase.getName() + ", plansAllowedInBundle=" + this.plansAllowedInBundle + "]";
    }

    private String findPriceListForPlan(StandaloneCatalog catalog) {
        for (PriceList cur : catalog.getPriceLists().getAllPriceLists()) {
            DefaultPriceList curDefaultPriceList = (DefaultPriceList)cur;
            if (curDefaultPriceList.findPlan(this.name) == null) continue;
            return curDefaultPriceList.getName();
        }
        throw new IllegalStateException("Cannot extract pricelist for plan " + this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        MapperHolder.mapper().readerForUpdating((Object)this).readValue((InputStream)new ExternalizableInput(in));
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        MapperHolder.mapper().writeValue((OutputStream)new ExternalizableOutput(oo), (Object)this);
    }
}

