/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.IllegalPlanChange;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanPolicy;
import org.killbill.billing.catalog.rules.DefaultCasePriceList;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestPlanRules
extends CatalogTestSuiteNoDB {
    private MockCatalog cat = null;

    @BeforeMethod(groups={"fast"})
    public void beforeMethod() {
        this.cat = new MockCatalog();
        DefaultPriceList priceList2 = this.cat.getPriceLists().getChildPriceLists()[0];
        DefaultCaseChangePlanPolicy casePolicy = new DefaultCaseChangePlanPolicy().setPolicy(BillingActionPolicy.END_OF_TERM);
        DefaultCaseChangePlanAlignment caseAlignment = new DefaultCaseChangePlanAlignment().setAlignment(PlanAlignmentChange.START_OF_SUBSCRIPTION);
        DefaultCasePriceList casePriceList = new DefaultCasePriceList().setToPriceList(priceList2);
        this.cat.getPlanRules().setChangeCase(new DefaultCaseChangePlanPolicy[]{casePolicy}).setChangeAlignmentCase(new DefaultCaseChangePlanAlignment[]{caseAlignment}).setPriceListCase(new DefaultCasePriceList[]{casePriceList});
    }

    @Test(groups={"fast"})
    public void testExistingPriceListIsKept() throws CatalogApiException {
        DefaultProduct product1 = this.cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = this.cat.findCurrentPriceList("DEFAULT");
        PlanPhaseSpecifier from = new PlanPhaseSpecifier(product1.getName(), BillingPeriod.MONTHLY, priceList1.getName(), PhaseType.EVERGREEN);
        PlanSpecifier to = new PlanSpecifier(product1.getName(), BillingPeriod.ANNUAL, priceList1.getName());
        PlanChangeResult result = null;
        try {
            result = this.cat.getPlanRules().planChange(from, to, (StaticCatalog)this.cat);
        }
        catch (IllegalPlanChange e) {
            Assert.fail((String)"We should not have triggered this error");
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
        Assert.assertEquals((Object)result.getPolicy(), (Object)BillingActionPolicy.END_OF_TERM);
        Assert.assertEquals((Object)result.getAlignment(), (Object)PlanAlignmentChange.START_OF_SUBSCRIPTION);
        Assert.assertEquals((Object)result.getNewPriceList(), (Object)priceList1);
    }

    @Test(groups={"fast"})
    public void testBaseCase() throws CatalogApiException {
        DefaultProduct product1 = this.cat.getCurrentProduct(0);
        DefaultProduct product2 = this.cat.getCurrentProduct(1);
        DefaultPriceList priceList1 = this.cat.findCurrentPriceList("DEFAULT");
        DefaultPriceList priceList2 = this.cat.getPriceLists().getChildPriceLists()[0];
        PlanPhaseSpecifier from = new PlanPhaseSpecifier(product1.getName(), BillingPeriod.MONTHLY, priceList1.getName(), PhaseType.EVERGREEN);
        PlanSpecifier to = new PlanSpecifier(product2.getName(), BillingPeriod.MONTHLY, null);
        PlanChangeResult result = null;
        try {
            result = this.cat.getPlanRules().planChange(from, to, (StaticCatalog)this.cat);
        }
        catch (IllegalPlanChange e) {
            Assert.fail((String)"We should not have triggered this error");
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
        Assert.assertEquals((Object)result.getPolicy(), (Object)BillingActionPolicy.END_OF_TERM);
        Assert.assertEquals((Object)result.getAlignment(), (Object)PlanAlignmentChange.START_OF_SUBSCRIPTION);
        Assert.assertEquals((Object)result.getNewPriceList(), (Object)priceList2);
    }
}

