/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.io;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestVersionedCatalogLoader
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testAppendToURI() throws IOException, URISyntaxException {
        URL u1 = new URL("http://www.ning.com/foo");
        Assert.assertEquals((String)this.loader.appendToURI(u1, "bar").toString(), (String)"http://www.ning.com/foo/bar");
        URL u2 = new URL("http://www.ning.com/foo/");
        Assert.assertEquals((String)this.loader.appendToURI(u2, "bar").toString(), (String)"http://www.ning.com/foo/bar");
    }

    @Test(groups={"fast"})
    public void testFindXmlFileReferences() throws MalformedURLException, URISyntaxException {
        String page = "dg.xml\nreplica.foo\nsnv1/\nviking.xml\n";
        List urls = this.loader.findXmlFileReferences("dg.xml\nreplica.foo\nsnv1/\nviking.xml\n", new URL("http://ning.com/"));
        Assert.assertEquals((int)urls.size(), (int)2);
        Assert.assertEquals((String)((URI)urls.get(0)).toString(), (String)"http://ning.com/dg.xml");
        Assert.assertEquals((String)((URI)urls.get(1)).toString(), (String)"http://ning.com/viking.xml");
    }

    @Test(groups={"fast"})
    public void testExtractHrefs() {
        String page = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html> <head>  <title>Index of /config/trunk/xno</title> </head> <body><h1>Index of /config/trunk/xno</h1><ul><li><a href=\"/config/trunk/\"> Parent Directory</a></li><li><a href=\"dg.xml\"> dg.xml</a></li><li><a href=\"replica.foo\"> replica/</a></li><li><a href=\"replica2/\"> replica2/</a></li><li><a href=\"replica_dyson/\"> replica_dyson/</a></li><li><a href=\"snv1/\"> snv1/</a></li><li><a href=\"viking.xml\"> viking.xml</a></li></ul><address>Apache/2.2.3 (CentOS) Server at <a href=\"mailto:kate@ning.com\">gepo.ningops.net</a> Port 80</address></body></html>";
        List hrefs = this.loader.extractHrefs("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html> <head>  <title>Index of /config/trunk/xno</title> </head> <body><h1>Index of /config/trunk/xno</h1><ul><li><a href=\"/config/trunk/\"> Parent Directory</a></li><li><a href=\"dg.xml\"> dg.xml</a></li><li><a href=\"replica.foo\"> replica/</a></li><li><a href=\"replica2/\"> replica2/</a></li><li><a href=\"replica_dyson/\"> replica_dyson/</a></li><li><a href=\"snv1/\"> snv1/</a></li><li><a href=\"viking.xml\"> viking.xml</a></li></ul><address>Apache/2.2.3 (CentOS) Server at <a href=\"mailto:kate@ning.com\">gepo.ningops.net</a> Port 80</address></body></html>");
        Assert.assertEquals((int)hrefs.size(), (int)8);
        Assert.assertEquals((String)((String)hrefs.get(0)), (String)"/config/trunk/");
        Assert.assertEquals((String)((String)hrefs.get(1)), (String)"dg.xml");
    }

    @Test(groups={"fast"})
    public void testFindXmlUrlReferences() throws MalformedURLException, URISyntaxException {
        String page = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html> <head>  <title>Index of /config/trunk/xno</title> </head> <body><h1>Index of /config/trunk/xno</h1><ul><li><a href=\"/config/trunk/\"> Parent Directory</a></li><li><a href=\"dg.xml\"> dg.xml</a></li><li><a href=\"replica.foo\"> replica/</a></li><li><a href=\"replica2/\"> replica2/</a></li><li><a href=\"replica_dyson/\"> replica_dyson/</a></li><li><a href=\"snv1/\"> snv1/</a></li><li><a href=\"viking.xml\"> viking.xml</a></li></ul><address>Apache/2.2.3 (CentOS) Server at <a href=\"mailto:kate@ning.com\">gepo.ningops.net</a> Port 80</address></body></html>";
        List uris = this.loader.findXmlUrlReferences("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"><html> <head>  <title>Index of /config/trunk/xno</title> </head> <body><h1>Index of /config/trunk/xno</h1><ul><li><a href=\"/config/trunk/\"> Parent Directory</a></li><li><a href=\"dg.xml\"> dg.xml</a></li><li><a href=\"replica.foo\"> replica/</a></li><li><a href=\"replica2/\"> replica2/</a></li><li><a href=\"replica_dyson/\"> replica_dyson/</a></li><li><a href=\"snv1/\"> snv1/</a></li><li><a href=\"viking.xml\"> viking.xml</a></li></ul><address>Apache/2.2.3 (CentOS) Server at <a href=\"mailto:kate@ning.com\">gepo.ningops.net</a> Port 80</address></body></html>", new URL("http://ning.com/"));
        Assert.assertEquals((int)uris.size(), (int)2);
        Assert.assertEquals((String)((URI)uris.get(0)).toString(), (String)"http://ning.com/dg.xml");
        Assert.assertEquals((String)((URI)uris.get(1)).toString(), (String)"http://ning.com/viking.xml");
    }

    @Test(groups={"fast"})
    public void testLoad() throws CatalogApiException {
        DefaultVersionedCatalog c = this.loader.loadDefaultCatalog(Resources.getResource((String)"versionedCatalog").toString());
        Assert.assertEquals((int)c.getVersions().size(), (int)4);
        DateTime dt = new DateTime((Object)"2011-01-01T00:00:00+00:00");
        Assert.assertEquals((Object)((StandaloneCatalog)c.getVersions().get(0)).getEffectiveDate(), (Object)dt.toDate());
        dt = new DateTime((Object)"2011-02-02T00:00:00+00:00");
        Assert.assertEquals((Object)((StandaloneCatalog)c.getVersions().get(1)).getEffectiveDate(), (Object)dt.toDate());
        dt = new DateTime((Object)"2011-02-03T00:00:00+00:00");
        Assert.assertEquals((Object)((StandaloneCatalog)c.getVersions().get(2)).getEffectiveDate(), (Object)dt.toDate());
        dt = new DateTime((Object)"2011-03-03T00:00:00+00:00");
        Assert.assertEquals((Object)((StandaloneCatalog)c.getVersions().get(3)).getEffectiveDate(), (Object)dt.toDate());
    }

    @Test(groups={"fast"})
    public void testLoadCatalogFromClasspathResourceFolder() throws CatalogApiException {
        DefaultVersionedCatalog c = this.loader.loadDefaultCatalog("SpyCarBasic.xml");
        Assert.assertEquals((int)c.getVersions().size(), (int)1);
        DateTime dt = new DateTime((Object)"2013-02-08T00:00:00+00:00");
        Assert.assertEquals((Object)c.getEffectiveDate(), (Object)dt.toDate());
        Assert.assertEquals((String)c.getCatalogName(), (String)"SpyCarBasic");
    }

    @Test(groups={"fast"}, expectedExceptions={CatalogApiException.class})
    public void testLoadCatalogFromClasspathResourceBadFolder() throws CatalogApiException {
        this.loader.loadDefaultCatalog("SpyCarCustom.xml");
    }

    @Test(groups={"fast"})
    public void testLoadCatalogFromInsideResourceFolder() throws CatalogApiException {
        DefaultVersionedCatalog c = this.loader.loadDefaultCatalog("com/acme/SpyCarCustom.xml");
        Assert.assertEquals((int)c.getVersions().size(), (int)1);
        DateTime dt = new DateTime((Object)"2015-10-04T00:00:00+00:00");
        Assert.assertEquals((Object)c.getEffectiveDate(), (Object)dt.toDate());
        Assert.assertEquals((String)c.getCatalogName(), (String)"SpyCarCustom");
    }

    @Test(groups={"fast"}, expectedExceptions={CatalogApiException.class})
    public void testLoadCatalogFromInsideResourceWithBadFolderName() throws CatalogApiException {
        this.loader.loadDefaultCatalog("com/acme2/SpyCarCustom.xml");
    }

    @Test(groups={"fast"})
    public void testLoadCatalogFromExternalFile() throws CatalogApiException, IOException, URISyntaxException {
        File originFile = new File(Resources.getResource((String)"SpyCarBasic.xml").toURI());
        File destinationFile = new File(Files.createTempDir().toString() + "/SpyCarBasicRelocated.xml");
        destinationFile.deleteOnExit();
        Files.copy((File)originFile, (File)destinationFile);
        DefaultVersionedCatalog c = this.loader.loadDefaultCatalog(destinationFile.toURI().toString());
        Assert.assertEquals((String)c.getCatalogName(), (String)"SpyCarBasic");
    }
}

