/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.math.BigDecimal;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCatalogOverridePhaseDefinitionSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePhaseDefinitionModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverridePhaseDefinitionModelDao obj1 = new CatalogOverridePhaseDefinitionModelDao("p1", "EUR", BigDecimal.ONE, BigDecimal.TEN, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverridePhaseDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseDefinitionSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverridePhaseDefinitionModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((String)rehydrated.getParentPhaseName(), (String)obj1.getParentPhaseName());
                Assert.assertEquals((int)rehydrated.getFixedPrice().compareTo(obj1.getFixedPrice()), (int)0);
                Assert.assertEquals((int)rehydrated.getRecurringPrice().compareTo(obj1.getRecurringPrice()), (int)0);
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj1.getCurrency());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testBasicWithNullPrices() throws Exception {
        final CatalogOverridePhaseDefinitionModelDao obj1 = new CatalogOverridePhaseDefinitionModelDao("p2", "USD", null, new BigDecimal("54.21"), this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverridePhaseDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseDefinitionSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverridePhaseDefinitionModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((String)rehydrated.getParentPhaseName(), (String)obj1.getParentPhaseName());
                Assert.assertNull((Object)rehydrated.getFixedPrice());
                Assert.assertEquals((int)rehydrated.getRecurringPrice().compareTo(obj1.getRecurringPrice()), (int)0);
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj1.getCurrency());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetByAttributes() throws Exception {
        final CatalogOverridePhaseDefinitionModelDao objWithNoNullPrices = new CatalogOverridePhaseDefinitionModelDao("p2", "USD", BigDecimal.ZERO, new BigDecimal("12.453"), this.clock.getUTCNow());
        final CatalogOverridePhaseDefinitionModelDao objWithNullFixedPrice = new CatalogOverridePhaseDefinitionModelDao("p3", "BTC", null, new BigDecimal("14.443"), this.clock.getUTCNow());
        final CatalogOverridePhaseDefinitionModelDao objWithNullRecurringPrice = new CatalogOverridePhaseDefinitionModelDao("p4", "EUR", new BigDecimal("11.243"), null, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverridePhaseDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePhaseDefinitionSqlDao sqlDao) {
                sqlDao.create(objWithNoNullPrices, (InternalCallContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                this.checkRehydrated(objWithNoNullPrices, sqlDao);
                sqlDao.create(objWithNullFixedPrice, (InternalCallContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                this.checkRehydrated(objWithNullFixedPrice, sqlDao);
                sqlDao.create(objWithNullRecurringPrice, (InternalCallContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext);
                this.checkRehydrated(objWithNullRecurringPrice, sqlDao);
                return null;
            }

            private void checkRehydrated(CatalogOverridePhaseDefinitionModelDao obj, CatalogOverridePhaseDefinitionSqlDao sqlDao) {
                CatalogOverridePhaseDefinitionModelDao rehydrated = (CatalogOverridePhaseDefinitionModelDao)sqlDao.getByAttributes(obj.getParentPhaseName(), obj.getCurrency(), obj.getFixedPrice(), obj.getRecurringPrice(), (InternalTenantContext)TestCatalogOverridePhaseDefinitionSqlDao.this.internalCallContext).get(0);
                Assert.assertEquals((String)rehydrated.getParentPhaseName(), (String)obj.getParentPhaseName());
                if (obj.getFixedPrice() != null) {
                    Assert.assertEquals((int)rehydrated.getFixedPrice().compareTo(obj.getFixedPrice()), (int)0);
                } else {
                    Assert.assertNull((Object)rehydrated.getFixedPrice());
                }
                if (obj.getRecurringPrice() != null) {
                    Assert.assertEquals((int)rehydrated.getRecurringPrice().compareTo(obj.getRecurringPrice()), (int)0);
                } else {
                    Assert.assertNull((Object)rehydrated.getRecurringPrice());
                }
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj.getCurrency());
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverridePhaseDefinitionSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)handle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface WithCatalogOverridePhaseDefinitionSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverridePhaseDefinitionSqlDao var1);
    }
}

