/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestVersionedCatalog
extends CatalogTestSuiteNoDB {
    final DateTime dt0 = new DateTime((Object)"2010-01-01T00:00:00+00:00");
    final DateTime dt1 = new DateTime((Object)"2011-01-01T00:01:00+00:00");
    final DateTime dt2 = new DateTime((Object)"2011-02-02T00:01:00+00:00");
    final DateTime dt2a = new DateTime((Object)"2011-02-03T00:01:00+00:00");
    final DateTime dt214 = new DateTime((Object)"2011-02-14T00:01:00+00:00");
    final DateTime dt3 = new DateTime((Object)"2011-03-03T00:01:00+00:00");
    private DefaultVersionedCatalog vc;

    @BeforeClass(groups={"fast"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        this.vc = this.loader.loadDefaultCatalog("versionedCatalog");
    }

    @Test(groups={"fast"})
    public void testFindPlanWithDates() throws Exception {
        Plan newSubPlan0 = this.vc.findPlan("pistol-monthly", this.dt0, this.dt0);
        Plan newSubPlan1 = this.vc.findPlan("pistol-monthly", this.dt1, this.dt1);
        Plan newSubPlan2 = this.vc.findPlan("pistol-monthly", this.dt2, this.dt2);
        Plan newSubPlan214 = this.vc.findPlan("pistol-monthly", this.dt214, this.dt214);
        Plan newSubPlan3 = this.vc.findPlan("pistol-monthly", this.dt3, this.dt3);
        Assert.assertEquals((Object)newSubPlan1.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        Assert.assertEquals((Object)newSubPlan2.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)newSubPlan214.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)newSubPlan3.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("49.95"));
        Plan exSubPlan2 = this.vc.findPlan("pistol-monthly", this.dt2, this.dt1);
        Plan exSubPlan214 = this.vc.findPlan("pistol-monthly", this.dt214, this.dt1);
        Plan exSubPlan3 = this.vc.findPlan("pistol-monthly", this.dt3, this.dt1);
        Plan exSubPlan4 = this.vc.findPlan("shotgun-quarterly", this.dt2, this.dt1);
        Plan exSubPlan5 = this.vc.findPlan("shotgun-quarterly", this.dt2a, this.dt1);
        Plan exSubPlan6 = this.vc.findPlan("shotgun-quarterly", this.dt214, this.dt1);
        Plan exSubPlan7 = this.vc.findPlan("shotgun-quarterly", this.dt214, this.dt214);
        Assert.assertEquals((Object)exSubPlan2.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        Assert.assertEquals((Object)exSubPlan214.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)exSubPlan3.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)exSubPlan4.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)exSubPlan5.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)exSubPlan6.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("259.95"));
        Assert.assertEquals((Object)exSubPlan7.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("259.95"));
    }

    @Test(groups={"fast"})
    public void testFindPlanWithDatesAndPlanSpecifier() throws Exception {
        PlanSpecifier pistolMonthly = new PlanSpecifier("Pistol", BillingPeriod.MONTHLY, "DEFAULT");
        PlanSpecifier shotgunQuarterly = new PlanSpecifier("Shotgun", BillingPeriod.QUARTERLY, "DEFAULT");
        Plan newSubPlan0 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt0, this.dt0);
        Plan newSubPlan1 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt1, this.dt1);
        Plan newSubPlan2 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt2, this.dt2);
        Plan newSubPlan214 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt214, this.dt214);
        Plan newSubPlan3 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt3, this.dt3);
        Assert.assertEquals((Object)newSubPlan1.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        Assert.assertEquals((Object)newSubPlan2.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)newSubPlan214.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)newSubPlan3.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("49.95"));
        Plan exSubPlan2 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt2, this.dt1);
        Plan exSubPlan214 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt214, this.dt1);
        Plan exSubPlan3 = this.vc.createOrFindPlan(pistolMonthly, null, this.dt3, this.dt1);
        Plan exSubPlan4 = this.vc.createOrFindPlan(shotgunQuarterly, null, this.dt2, this.dt1);
        Plan exSubPlan5 = this.vc.createOrFindPlan(shotgunQuarterly, null, this.dt2a, this.dt1);
        Plan exSubPlan6 = this.vc.createOrFindPlan(shotgunQuarterly, null, this.dt214, this.dt1);
        Plan exSubPlan7 = this.vc.createOrFindPlan(shotgunQuarterly, null, this.dt214, this.dt214);
        Assert.assertEquals((Object)exSubPlan2.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("29.95"));
        Assert.assertEquals((Object)exSubPlan214.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)exSubPlan3.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("39.95"));
        Assert.assertEquals((Object)exSubPlan4.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)exSubPlan5.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("249.95"));
        Assert.assertEquals((Object)exSubPlan6.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("259.95"));
        Assert.assertEquals((Object)exSubPlan7.getAllPhases()[1].getRecurring().getRecurringPrice().getPrice(Currency.USD), (Object)new BigDecimal("259.95"));
    }

    @Test(groups={"fast"})
    public void testErrorOnDateTooEarly() throws CatalogApiException {
        this.vc.findPlan("shotgun-monthly", this.dt0);
        try {
            this.vc.findPlan("shotgun-quarterly", this.dt0);
            Assert.fail((String)"Date is too early an exception should have been thrown");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PLAN.getCode());
        }
    }

    @Test(groups={"fast"})
    public void testWithDeletedPlan() throws CatalogApiException {
        this.vc.findPlan("shotgun-quarterly", this.dt2);
        try {
            this.vc.findPlan("shotgun-quarterly", this.dt3);
            Assert.fail((String)"Plan has been removed");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_NO_SUCH_PLAN.getCode());
        }
        this.vc.findPlan("shotgun-quarterly", this.dt3, this.dt1);
    }
}

