/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationException;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStandaloneCatalog
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testLoadCatalogWithValidationIssues() throws Exception {
        try {
            XMLLoader.getObjectFromString((String)Resources.getResource((String)"CatalogWithValidationErrors.xml").toExternalForm(), StandaloneCatalog.class);
            Assert.fail();
        }
        catch (ValidationException e) {
            Assert.assertEquals((int)e.getErrors().size(), (int)13);
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(0)).getDescription(), (String)"Invalid product for plan 'standard'");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(1)).getDescription(), (String)"Duration can only have 'UNLIMITED' unit if the number is omitted");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(2)).getDescription(), (String)"Finite Duration must have a well defined length");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(3)).getDescription(), (String)"Initial Phase standard-trial-evergreen of plan standard-trial cannot be of type EVERGREEN");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(4)).getDescription(), (String)"Final Phase standard-trial-trial of plan standard-trial cannot be of type TRIAL");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(5)).getDescription(), (String)"Duplicate rule for change plan DefaultCaseChangePlanPolicy {policy=IMMEDIATE, phaseType=null, fromProduct=DefaultProduct{name='Standard', category=BASE, included=org.killbill.billing.catalog.CatalogEntityCollection@0, available=org.killbill.billing.catalog.CatalogEntityCollection@0, limits=[], catalogName='CatalogWithValidationErrors'}, fromProductCategory=null, fromBillingPeriod=null, fromPriceList=null, toProduct=null, toProductCategory=null, toBillingPeriod=null, toPriceList=null}");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(6)).getDescription(), (String)"Missing default rule case for plan change");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(7)).getDescription(), (String)"Duplicate rule for plan cancellation DefaultCaseCancelPolicy{policy =IMMEDIATE, phaseType =null, product=DefaultProduct{name='Standard', category=BASE, included=org.killbill.billing.catalog.CatalogEntityCollection@0, available=org.killbill.billing.catalog.CatalogEntityCollection@0, limits=[], catalogName='CatalogWithValidationErrors'}, productCategory=null, billingPeriod=null, priceList=null}");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(8)).getDescription(), (String)"Missing default rule case for plan cancellation");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(9)).getDescription(), (String)"Duplicate rule for plan change alignment DefaultCaseChangePlanAlignment {alignment=START_OF_BUNDLE, phaseType=null, fromProduct=null, fromProductCategory=null, fromBillingPeriod=null, fromPriceList=null, toProduct=null, toProductCategory=null, toBillingPeriod=null, toPriceList=null}");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(10)).getDescription(), (String)"Duplicate rule for create plan alignment DefaultCaseCreateAlignment {alignment =START_OF_BUNDLE, product=null, productCategory=null, billingPeriod=null, priceList=null}");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(11)).getDescription(), (String)"Duplicate rule for billing alignment DefaultCaseBillingAlignment {alignment=ACCOUNT, phaseType=null, product=null, productCategory=null, billingPeriod=null, priceList=null}");
            Assert.assertEquals((String)((ValidationError)e.getErrors().get(12)).getDescription(), (String)"Duplicate rule for price list transition DefaultCasePriceList {fromProduct=null, fromProductCategory=null, fromBillingPeriod=null, fromPriceList=null, toPriceList=DefaultPriceList{name='DEFAULT}}");
        }
    }

    @Test(groups={"fast"})
    public void testFindPhase() throws CatalogApiException {
        DefaultPlanPhase phaseTrial1 = new MockPlanPhase().setPhaseType(PhaseType.TRIAL);
        DefaultPlanPhase phaseTrial2 = new MockPlanPhase().setPhaseType(PhaseType.TRIAL);
        DefaultPlanPhase phaseDiscount1 = new MockPlanPhase().setPhaseType(PhaseType.DISCOUNT);
        DefaultPlanPhase phaseDiscount2 = new MockPlanPhase().setPhaseType(PhaseType.DISCOUNT);
        DefaultPlan plan1 = new MockPlan().setName("TestPlan1").setFinalPhase(phaseDiscount1).setInitialPhases(new DefaultPlanPhase[]{phaseTrial1});
        DefaultPlan plan2 = new MockPlan().setName("TestPlan2").setFinalPhase(phaseDiscount2).setInitialPhases(new DefaultPlanPhase[]{phaseTrial2});
        phaseTrial1.setPlan((Plan)plan1);
        phaseTrial2.setPlan((Plan)plan2);
        phaseDiscount1.setPlan((Plan)plan1);
        phaseDiscount2.setPlan((Plan)plan2);
        StandaloneCatalog cat = new MockCatalog().setPlans((Iterable)ImmutableList.of((Object)plan1, (Object)plan2));
        Assert.assertEquals((Object)cat.findCurrentPhase("TestPlan1-discount"), (Object)phaseDiscount1);
        Assert.assertEquals((Object)cat.findCurrentPhase("TestPlan2-discount"), (Object)phaseDiscount2);
        Assert.assertEquals((Object)cat.findCurrentPhase("TestPlan1-trial"), (Object)phaseTrial1);
        Assert.assertEquals((Object)cat.findCurrentPhase("TestPlan2-trial"), (Object)phaseTrial2);
    }
}

