/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.Resources;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTierPriceOverride;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultTieredBlockPriceOverride;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.DefaultUsagePriceOverride;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.billing.catalog.override.DefaultPriceOverride;
import org.killbill.xmlloader.XMLLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultPriceOverride
extends CatalogTestSuiteWithEmbeddedDB {
    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        catalog.initialize(catalog, null);
        DefaultPlan plan = catalog.findCurrentPlan("discount-standard-monthly");
        ArrayList<DefaultPlanPhasePriceOverride> overrides = new ArrayList<DefaultPlanPhasePriceOverride>();
        DefaultPlanPhasePriceOverride phase1 = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[0].getName(), Currency.USD, BigDecimal.ONE, null, null);
        overrides.add(phase1);
        DefaultPlanPhasePriceOverride phase3 = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[2].getName(), Currency.USD, null, new BigDecimal("142.41"), null);
        overrides.add(phase3);
        DefaultPlan overriddenPlan = this.priceOverride.getOrCreateOverriddenPlan(catalog, (Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), overrides, (InternalCallContext)this.internalCallContext);
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(overriddenPlan.getName());
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((String)m.group(1), (String)plan.getName());
        Assert.assertEquals((String)overriddenPlan.getProduct().getName(), (String)plan.getProduct().getName());
        Assert.assertEquals((Object)overriddenPlan.getRecurringBillingPeriod(), (Object)plan.getRecurringBillingPeriod());
        if (plan.getEffectiveDateForExistingSubscriptions() != null) {
            Assert.assertEquals((int)overriddenPlan.getEffectiveDateForExistingSubscriptions().compareTo(plan.getEffectiveDateForExistingSubscriptions()), (int)0);
        }
        Assert.assertNotEquals((Object)overriddenPlan.getFinalPhase().getName(), (Object)plan.getFinalPhase().getName());
        Assert.assertEquals((int)overriddenPlan.getPlansAllowedInBundle(), (int)plan.getPlansAllowedInBundle());
        Assert.assertEquals((int)overriddenPlan.getAllPhases().length, (int)overriddenPlan.getAllPhases().length);
        for (int i = 0; i < overriddenPlan.getAllPhases().length; ++i) {
            final DefaultPlanPhase initialPhase = (DefaultPlanPhase)plan.getAllPhases()[i];
            DefaultPlanPhase newPhase = (DefaultPlanPhase)overriddenPlan.getAllPhases()[i];
            PlanPhasePriceOverride override = (PlanPhasePriceOverride)Iterables.tryFind(overrides, (Predicate)new Predicate<PlanPhasePriceOverride>(){

                public boolean apply(PlanPhasePriceOverride input) {
                    return input.getPhaseName().equals(initialPhase.getName());
                }
            }).orNull();
            Assert.assertNotEquals((Object)newPhase.getName(), (Object)initialPhase.getName());
            Assert.assertEquals((Object)newPhase.getDuration(), (Object)initialPhase.getDuration());
            Assert.assertEquals((Object)newPhase.getPhaseType(), (Object)initialPhase.getPhaseType());
            Assert.assertEquals((int)newPhase.getUsages().length, (int)initialPhase.getUsages().length);
            if (initialPhase.getFixed() != null) {
                Assert.assertEquals((Object)newPhase.getFixed().getType(), (Object)initialPhase.getFixed().getType());
                this.assertInternationalPrice(newPhase.getFixed().getPrice(), initialPhase.getFixed().getPrice(), override, true);
            }
            if (initialPhase.getRecurring() == null) continue;
            this.assertInternationalPrice(newPhase.getRecurring().getRecurringPrice(), initialPhase.getRecurring().getRecurringPrice(), override, false);
        }
    }

    @Test(groups={"slow"}, expectedExceptions={CatalogApiException.class})
    public void testWithInvalidPriceOverride() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        catalog.initialize(catalog, null);
        DefaultPlan plan = catalog.findCurrentPlan("discount-standard-monthly");
        ArrayList<DefaultPlanPhasePriceOverride> overrides = new ArrayList<DefaultPlanPhasePriceOverride>();
        DefaultPlanPhasePriceOverride phase1 = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[0].getName(), Currency.USD, null, BigDecimal.ONE, null);
        overrides.add(phase1);
        this.priceOverride.getOrCreateOverriddenPlan(catalog, (Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), overrides, (InternalCallContext)this.internalCallContext);
    }

    @Test(groups={"slow"})
    public void testGetOverriddenPlan() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"SpyCarAdvanced.xml").toExternalForm(), StandaloneCatalog.class);
        catalog.initialize(catalog, null);
        DefaultPlan plan = catalog.findCurrentPlan("discount-standard-monthly");
        ArrayList<DefaultPlanPhasePriceOverride> overrides = new ArrayList<DefaultPlanPhasePriceOverride>();
        DefaultPlanPhasePriceOverride phase1 = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[0].getName(), Currency.USD, BigDecimal.ONE, null, null);
        overrides.add(phase1);
        DefaultPlanPhasePriceOverride phase3 = new DefaultPlanPhasePriceOverride(plan.getAllPhases()[2].getName(), Currency.USD, null, new BigDecimal("142.41"), null);
        overrides.add(phase3);
        DefaultPlan overriddenPlanCreated = this.priceOverride.getOrCreateOverriddenPlan(catalog, (Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), overrides, (InternalCallContext)this.internalCallContext);
        System.out.println("overriddenPlanCreated = " + overriddenPlanCreated.getName());
        DefaultPlan overriddenPlan = this.priceOverride.getOverriddenPlan(overriddenPlanCreated.getName(), (StaticCatalog)catalog, (InternalTenantContext)this.internalCallContext);
        Assert.assertEquals((String)overriddenPlan.getProduct().getName(), (String)plan.getProduct().getName());
        Assert.assertEquals((Object)overriddenPlan.getRecurringBillingPeriod(), (Object)plan.getRecurringBillingPeriod());
        if (plan.getEffectiveDateForExistingSubscriptions() != null) {
            Assert.assertEquals((int)overriddenPlan.getEffectiveDateForExistingSubscriptions().compareTo(plan.getEffectiveDateForExistingSubscriptions()), (int)0);
        }
        Assert.assertNotEquals((Object)overriddenPlan.getFinalPhase().getName(), (Object)plan.getFinalPhase().getName());
        Assert.assertEquals((int)overriddenPlan.getPlansAllowedInBundle(), (int)plan.getPlansAllowedInBundle());
        Assert.assertEquals((int)overriddenPlan.getAllPhases().length, (int)overriddenPlan.getAllPhases().length);
        for (int i = 0; i < overriddenPlan.getAllPhases().length; ++i) {
            final DefaultPlanPhase initialPhase = (DefaultPlanPhase)plan.getAllPhases()[i];
            DefaultPlanPhase newPhase = (DefaultPlanPhase)overriddenPlan.getAllPhases()[i];
            PlanPhasePriceOverride override = (PlanPhasePriceOverride)Iterables.tryFind(overrides, (Predicate)new Predicate<PlanPhasePriceOverride>(){

                public boolean apply(PlanPhasePriceOverride input) {
                    return input.getPhaseName().equals(initialPhase.getName());
                }
            }).orNull();
            Assert.assertNotEquals((Object)newPhase.getName(), (Object)initialPhase.getName());
            Assert.assertEquals((String)newPhase.getName(), (String)(overriddenPlan.getName() + "-" + initialPhase.getName().split("-")[initialPhase.getName().split("-").length - 1]));
            Assert.assertEquals((Object)newPhase.getDuration(), (Object)initialPhase.getDuration());
            Assert.assertEquals((Object)newPhase.getPhaseType(), (Object)initialPhase.getPhaseType());
            Assert.assertEquals((int)newPhase.getUsages().length, (int)initialPhase.getUsages().length);
            if (initialPhase.getFixed() != null) {
                Assert.assertEquals((Object)newPhase.getFixed().getType(), (Object)initialPhase.getFixed().getType());
                this.assertInternationalPrice(newPhase.getFixed().getPrice(), initialPhase.getFixed().getPrice(), override, true);
            }
            if (initialPhase.getRecurring() == null) continue;
            this.assertInternationalPrice(newPhase.getRecurring().getRecurringPrice(), initialPhase.getRecurring().getRecurringPrice(), override, false);
        }
    }

    private void assertInternationalPrice(InternationalPrice newInternationalPrice, InternationalPrice initInternationalPrice, PlanPhasePriceOverride override, boolean isFixed) throws CatalogApiException {
        if (initInternationalPrice.getPrices().length == 0) {
            if (override != null) {
                Assert.assertEquals((int)newInternationalPrice.getPrices().length, (int)1);
                Assert.assertEquals((int)newInternationalPrice.getPrice(override.getCurrency()).compareTo(isFixed ? override.getFixedPrice() : override.getRecurringPrice()), (int)0);
            }
        } else {
            Assert.assertEquals((int)newInternationalPrice.getPrices().length, (int)initInternationalPrice.getPrices().length);
            for (int i = 0; i < newInternationalPrice.getPrices().length; ++i) {
                Price initPrice = initInternationalPrice.getPrices()[i];
                Price newPrice = newInternationalPrice.getPrices()[i];
                if (override != null && override.getCurrency() == initPrice.getCurrency() && (isFixed && override.getFixedPrice() != null || !isFixed && override.getRecurringPrice() != null)) {
                    Assert.assertEquals((int)newPrice.getValue().compareTo(isFixed ? override.getFixedPrice() : override.getRecurringPrice()), (int)0);
                    continue;
                }
                if (initPrice == null || initPrice.getValue() == null) continue;
                Assert.assertEquals((int)newPrice.getValue().compareTo(initPrice.getValue()), (int)0);
            }
        }
    }

    @Test(groups={"slow"})
    public void testOverrideOneOutOfTwoTieredBlockPrices() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"UsageExperimental.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("chocolate-monthly");
        ArrayList<DefaultPlanPhasePriceOverride> overrides = new ArrayList<DefaultPlanPhasePriceOverride>();
        ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides = new ArrayList<DefaultTieredBlockPriceOverride>();
        tieredBlockPriceOverrides.add(new DefaultTieredBlockPriceOverride("chocolate-videos", new Double("1"), new BigDecimal("0.75"), Currency.USD, new Double("10000")));
        ArrayList<DefaultTierPriceOverride> tierPriceOverrides = new ArrayList<DefaultTierPriceOverride>();
        tierPriceOverrides.add(new DefaultTierPriceOverride(tieredBlockPriceOverrides));
        ArrayList<DefaultUsagePriceOverride> usagePriceOverrides = new ArrayList<DefaultUsagePriceOverride>();
        usagePriceOverrides.add(new DefaultUsagePriceOverride("chocolate-monthly-videos", UsageType.CONSUMABLE, tierPriceOverrides));
        DefaultPlanPhasePriceOverride phase = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, null, null, usagePriceOverrides);
        overrides.add(phase);
        DefaultPlan overriddenPlan = this.priceOverride.getOrCreateOverriddenPlan(catalog, (Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), overrides, (InternalCallContext)this.internalCallContext);
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(overriddenPlan.getName());
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((String)m.group(1), (String)plan.getName());
        Assert.assertEquals((String)overriddenPlan.getProduct().getName(), (String)plan.getProduct().getName());
        Assert.assertEquals((Object)overriddenPlan.getRecurringBillingPeriod(), (Object)plan.getRecurringBillingPeriod());
        if (plan.getEffectiveDateForExistingSubscriptions() != null) {
            Assert.assertEquals((int)overriddenPlan.getEffectiveDateForExistingSubscriptions().compareTo(plan.getEffectiveDateForExistingSubscriptions()), (int)0);
        }
        Assert.assertNotEquals((Object)overriddenPlan.getFinalPhase().getName(), (Object)plan.getFinalPhase().getName());
        for (int i = 0; i < overriddenPlan.getFinalPhase().getUsages().length; ++i) {
            DefaultUsage initialUsage = (DefaultUsage)plan.getFinalPhase().getUsages()[i];
            DefaultUsage newUsage = (DefaultUsage)overriddenPlan.getFinalPhase().getUsages()[i];
            Assert.assertEquals((String)newUsage.getName(), (String)initialUsage.getName());
            Assert.assertEquals((Object)newUsage.getUsageType(), (Object)initialUsage.getUsageType());
            Assert.assertEquals((Object)newUsage.getBillingPeriod(), (Object)initialUsage.getBillingPeriod());
            Assert.assertEquals((Object)newUsage.getBillingPeriod(), (Object)initialUsage.getBillingPeriod());
            Assert.assertEquals((int)newUsage.getTiers().length, (int)initialUsage.getTiers().length);
            for (int j = 0; j < newUsage.getTiers().length; ++j) {
                DefaultTier initialTier = (DefaultTier)initialUsage.getTiers()[j];
                DefaultTier newTier = (DefaultTier)newUsage.getTiers()[j];
                Assert.assertEquals((int)newTier.getTieredBlocks().length, (int)initialTier.getTieredBlocks().length);
                for (int k = 0; k < newTier.getTieredBlocks().length; ++k) {
                    final DefaultTieredBlock initialTieredBlock = initialTier.getTieredBlocks()[k];
                    DefaultTieredBlock newTieredBlock = newTier.getTieredBlocks()[k];
                    TieredBlockPriceOverride override = (TieredBlockPriceOverride)Iterables.tryFind(tieredBlockPriceOverrides, (Predicate)new Predicate<TieredBlockPriceOverride>(){

                        public boolean apply(TieredBlockPriceOverride input) {
                            return input.getUnitName().equals(initialTieredBlock.getUnit().getName()) && Double.compare(input.getSize(), initialTieredBlock.getSize()) == 0 && Double.compare(input.getMax(), initialTieredBlock.getMax()) == 0;
                        }
                    }).orNull();
                    Assert.assertEquals((String)newTieredBlock.getUnit().getName(), (String)initialTieredBlock.getUnit().getName());
                    Assert.assertEquals((Object)newTieredBlock.getMax(), (Object)initialTieredBlock.getMax());
                    Assert.assertEquals((Object)newTieredBlock.getSize(), (Object)initialTieredBlock.getSize());
                    this.assertTieredBlockInternationalPrice(newTieredBlock.getPrice(), initialTieredBlock.getPrice(), override);
                }
            }
        }
    }

    @Test(groups={"slow"})
    public void testOverrideTwoOutOfTwoTieredBlockPrices() throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)"UsageExperimental.xml").toExternalForm(), StandaloneCatalog.class);
        DefaultPlan plan = catalog.findCurrentPlan("chocolate-monthly");
        ArrayList<DefaultPlanPhasePriceOverride> overrides = new ArrayList<DefaultPlanPhasePriceOverride>();
        ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides1 = new ArrayList<DefaultTieredBlockPriceOverride>();
        tieredBlockPriceOverrides1.add(new DefaultTieredBlockPriceOverride("chocolate-videos", new Double("1"), new BigDecimal("1.5"), Currency.USD, new Double("5")));
        ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides2 = new ArrayList<DefaultTieredBlockPriceOverride>();
        tieredBlockPriceOverrides2.add(new DefaultTieredBlockPriceOverride("chocolate-videos", new Double("1"), new BigDecimal("0.75"), Currency.USD, new Double("10000")));
        ArrayList<DefaultTierPriceOverride> tierPriceOverrides = new ArrayList<DefaultTierPriceOverride>();
        tierPriceOverrides.add(new DefaultTierPriceOverride(tieredBlockPriceOverrides1));
        tierPriceOverrides.add(new DefaultTierPriceOverride(tieredBlockPriceOverrides2));
        ArrayList<DefaultUsagePriceOverride> usagePriceOverrides = new ArrayList<DefaultUsagePriceOverride>();
        usagePriceOverrides.add(new DefaultUsagePriceOverride("chocolate-monthly-videos", UsageType.CONSUMABLE, tierPriceOverrides));
        DefaultPlanPhasePriceOverride phase = new DefaultPlanPhasePriceOverride(plan.getFinalPhase().getName(), Currency.USD, null, new BigDecimal("35"), usagePriceOverrides);
        overrides.add(phase);
        DefaultPlan overriddenPlan = this.priceOverride.getOrCreateOverriddenPlan(catalog, (Plan)plan, new DateTime((Object)catalog.getEffectiveDate()), overrides, (InternalCallContext)this.internalCallContext);
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(overriddenPlan.getName());
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((String)m.group(1), (String)plan.getName());
        Assert.assertEquals((String)overriddenPlan.getProduct().getName(), (String)plan.getProduct().getName());
        Assert.assertEquals((Object)overriddenPlan.getRecurringBillingPeriod(), (Object)plan.getRecurringBillingPeriod());
        if (plan.getEffectiveDateForExistingSubscriptions() != null) {
            Assert.assertEquals((int)overriddenPlan.getEffectiveDateForExistingSubscriptions().compareTo(plan.getEffectiveDateForExistingSubscriptions()), (int)0);
        }
        Assert.assertNotEquals((Object)overriddenPlan.getFinalPhase().getName(), (Object)plan.getFinalPhase().getName());
        final DefaultPlanPhase initialPhase = (DefaultPlanPhase)plan.getFinalPhase();
        DefaultPlanPhase newPhase = overriddenPlan.getFinalPhase();
        PlanPhasePriceOverride override = (PlanPhasePriceOverride)Iterables.tryFind(overrides, (Predicate)new Predicate<PlanPhasePriceOverride>(){

            public boolean apply(PlanPhasePriceOverride input) {
                return input.getPhaseName().equals(initialPhase.getName());
            }
        }).orNull();
        Assert.assertNotEquals((Object)newPhase.getName(), (Object)initialPhase.getName());
        Assert.assertEquals((String)newPhase.getName(), (String)(overriddenPlan.getName() + "-" + initialPhase.getName().split("-")[initialPhase.getName().split("-").length - 1]));
        Assert.assertEquals((Object)newPhase.getDuration(), (Object)initialPhase.getDuration());
        Assert.assertEquals((Object)newPhase.getPhaseType(), (Object)initialPhase.getPhaseType());
        Assert.assertEquals((int)newPhase.getUsages().length, (int)initialPhase.getUsages().length);
        if (initialPhase.getFixed() != null) {
            Assert.assertEquals((Object)newPhase.getFixed().getType(), (Object)initialPhase.getFixed().getType());
            this.assertInternationalPrice(newPhase.getFixed().getPrice(), initialPhase.getFixed().getPrice(), override, true);
        }
        if (initialPhase.getRecurring() != null) {
            this.assertInternationalPrice(newPhase.getRecurring().getRecurringPrice(), initialPhase.getRecurring().getRecurringPrice(), override, false);
        }
        for (int i = 0; i < overriddenPlan.getFinalPhase().getUsages().length; ++i) {
            DefaultUsage initialUsage = (DefaultUsage)plan.getFinalPhase().getUsages()[i];
            DefaultUsage newUsage = (DefaultUsage)overriddenPlan.getFinalPhase().getUsages()[i];
            Assert.assertEquals((String)newUsage.getName(), (String)initialUsage.getName());
            Assert.assertEquals((Object)newUsage.getUsageType(), (Object)initialUsage.getUsageType());
            Assert.assertEquals((Object)newUsage.getBillingPeriod(), (Object)initialUsage.getBillingPeriod());
            Assert.assertEquals((Object)newUsage.getBillingPeriod(), (Object)initialUsage.getBillingPeriod());
            Assert.assertEquals((int)newUsage.getTiers().length, (int)initialUsage.getTiers().length);
            for (int j = 0; j < newUsage.getTiers().length; ++j) {
                DefaultTier initialTier = (DefaultTier)initialUsage.getTiers()[j];
                DefaultTier newTier = (DefaultTier)newUsage.getTiers()[j];
                Assert.assertEquals((int)newTier.getTieredBlocks().length, (int)initialTier.getTieredBlocks().length);
                for (int k = 0; k < newTier.getTieredBlocks().length; ++k) {
                    final DefaultTieredBlock initialTieredBlock = initialTier.getTieredBlocks()[k];
                    DefaultTieredBlock newTieredBlock = newTier.getTieredBlocks()[k];
                    ArrayList<DefaultTieredBlockPriceOverride> tieredBlockPriceOverrides = new ArrayList<DefaultTieredBlockPriceOverride>();
                    tieredBlockPriceOverrides.addAll(tieredBlockPriceOverrides1);
                    tieredBlockPriceOverrides.addAll(tieredBlockPriceOverrides2);
                    TieredBlockPriceOverride tieredBlockPriceOverride = (TieredBlockPriceOverride)Iterables.tryFind(tieredBlockPriceOverrides, (Predicate)new Predicate<TieredBlockPriceOverride>(){

                        public boolean apply(TieredBlockPriceOverride input) {
                            return input.getUnitName().equals(initialTieredBlock.getUnit().getName()) && Double.compare(input.getSize(), initialTieredBlock.getSize()) == 0 && Double.compare(input.getMax(), initialTieredBlock.getMax()) == 0;
                        }
                    }).orNull();
                    Assert.assertEquals((String)newTieredBlock.getUnit().getName(), (String)initialTieredBlock.getUnit().getName());
                    Assert.assertEquals((Object)newTieredBlock.getMax(), (Object)initialTieredBlock.getMax());
                    Assert.assertEquals((Object)newTieredBlock.getSize(), (Object)initialTieredBlock.getSize());
                    this.assertTieredBlockInternationalPrice(newTieredBlock.getPrice(), initialTieredBlock.getPrice(), tieredBlockPriceOverride);
                }
            }
        }
    }

    private void assertTieredBlockInternationalPrice(InternationalPrice newInternationalPrice, InternationalPrice initInternationalPrice, TieredBlockPriceOverride override) throws CurrencyValueNull {
        Assert.assertEquals((int)newInternationalPrice.getPrices().length, (int)initInternationalPrice.getPrices().length);
        for (int i = 0; i < newInternationalPrice.getPrices().length; ++i) {
            Price initPrice = initInternationalPrice.getPrices()[i];
            Price newPrice = newInternationalPrice.getPrices()[i];
            if (override != null && override.getCurrency() == initPrice.getCurrency() && override.getPrice() != null) {
                Assert.assertEquals((int)newPrice.getValue().compareTo(override.getPrice()), (int)0);
                continue;
            }
            if (initPrice == null || initPrice.getValue() == null) continue;
            Assert.assertEquals((int)newPrice.getValue().compareTo(initPrice.getValue()), (int)0);
        }
    }
}

