/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Matcher;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogDateHelper;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.override.DefaultPriceOverride;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;

public class StandaloneCatalogWithPriceOverride
extends StandaloneCatalog
implements StaticCatalog {
    private final Long tenantRecordId;
    @JsonIgnore
    private final InternalCallContextFactory internalCallContextFactory;
    @JsonIgnore
    private final PriceOverride priceOverride;

    public StandaloneCatalogWithPriceOverride(StandaloneCatalog catalog, PriceOverride priceOverride, Long tenantRecordId, InternalCallContextFactory internalCallContextFactory) {
        this.setCatalogName(catalog.getCatalogName());
        this.setEffectiveDate(catalog.getEffectiveDate());
        this.setProducts(catalog.getCurrentProducts());
        this.setPlans(catalog.getCurrentPlans());
        this.setPriceLists(catalog.getPriceLists());
        this.setPlanRules(catalog.getPlanRules());
        this.setSupportedCurrencies(catalog.getCurrentSupportedCurrencies());
        this.setUnits(catalog.getCurrentUnits());
        this.tenantRecordId = tenantRecordId;
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public Long getTenantRecordId() {
        return this.tenantRecordId;
    }

    public InternalCallContextFactory getInternalCallContextFactory() {
        return this.internalCallContextFactory;
    }

    public Plan createOrFindCurrentPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) throws CatalogApiException {
        Plan defaultPlan = super.createOrFindCurrentPlan(spec, null);
        if (overrides == null || overrides.getOverrides() == null || overrides.getOverrides().isEmpty()) {
            return defaultPlan;
        }
        InternalCallContext internalCallContext = overrides.getCallContext() != null ? this.internalCallContextFactory.createInternalCallContextWithoutAccountRecordId(overrides.getCallContext()) : null;
        return this.priceOverride.getOrCreateOverriddenPlan(this, defaultPlan, CatalogDateHelper.toUTCDateTime(this.getEffectiveDate()), overrides.getOverrides(), internalCallContext);
    }

    public DefaultPlan findCurrentPlan(String planName) throws CatalogApiException {
        DefaultPlan plan;
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(planName);
        if (m.matches() && (plan = this.maybeGetOverriddenPlan(planName)) != null) {
            return plan;
        }
        return super.findCurrentPlan(planName);
    }

    public Product findCurrentProduct(String productName) throws CatalogApiException {
        return super.findCurrentProduct(productName);
    }

    public PlanPhase findCurrentPhase(String phaseName) throws CatalogApiException {
        DefaultPlan plan;
        String planName = DefaultPlanPhase.planName(phaseName);
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(planName);
        if (m.matches() && (plan = this.maybeGetOverriddenPlan(planName)) != null) {
            return plan.findPhase(phaseName);
        }
        return super.findCurrentPhase(phaseName);
    }

    private DefaultPlan maybeGetOverriddenPlan(String planName) throws CatalogApiException {
        InternalTenantContext internalTenantContext = this.createInternalTenantContext();
        try {
            return this.priceOverride.getOverriddenPlan(planName, this, internalTenantContext);
        }
        catch (RuntimeException e) {
            if (e.getCause() == null || e.getCause().getCause() == null || !(e.getCause().getCause() instanceof CatalogApiException) || ((CatalogApiException)e.getCause().getCause()).getCode() != ErrorCode.CAT_NO_SUCH_PLAN.getCode()) {
                throw e;
            }
            return null;
        }
    }

    private InternalTenantContext createInternalTenantContext() {
        return this.internalCallContextFactory.createInternalTenantContext(this.tenantRecordId, null);
    }
}

