/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogDateHelper;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.util.cache.ExternalizableInput;
import org.killbill.billing.util.cache.ExternalizableOutput;
import org.killbill.billing.util.cache.MapperHolder;
import org.killbill.clock.Clock;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="catalogs")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultVersionedCatalog
extends ValidatingConfig<DefaultVersionedCatalog>
implements VersionedCatalog<StandaloneCatalog>,
Externalizable {
    private static final long serialVersionUID = 3181874902672322725L;
    private final Clock clock;
    @XmlElementWrapper(name="versions", required=true)
    @XmlElement(name="version", required=true)
    private final List<StandaloneCatalog> versions;
    @XmlElement(required=true)
    private String catalogName;

    public DefaultVersionedCatalog() {
        this.clock = null;
        this.versions = new ArrayList<StandaloneCatalog>();
    }

    public DefaultVersionedCatalog(Clock clock) {
        this.clock = clock;
        this.versions = new ArrayList<StandaloneCatalog>();
    }

    private StandaloneCatalog versionForDate(DateTime date) throws CatalogApiException {
        return this.versions.get(this.indexOfVersionForDate(date.toDate()));
    }

    private List<StandaloneCatalog> versionsBeforeDate(Date date) throws CatalogApiException {
        ArrayList<StandaloneCatalog> result = new ArrayList<StandaloneCatalog>();
        int index = this.indexOfVersionForDate(date);
        for (int i = 0; i <= index; ++i) {
            result.add(this.versions.get(i));
        }
        return result;
    }

    private int indexOfVersionForDate(Date date) throws CatalogApiException {
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            StandaloneCatalog c = this.versions.get(i);
            if (c.getEffectiveDate().getTime() > date.getTime()) continue;
            return i;
        }
        if (!this.versions.isEmpty()) {
            return 0;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_CATALOG_FOR_GIVEN_DATE, new Object[]{date.toString()});
    }

    private CatalogPlanEntry findCatalogPlanEntry(PlanRequestWrapper wrapper, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        List<StandaloneCatalog> catalogs = this.versionsBeforeDate(requestedDate.toDate());
        if (catalogs.isEmpty()) {
            throw new CatalogApiException(ErrorCode.CAT_NO_CATALOG_FOR_GIVEN_DATE, new Object[]{requestedDate.toDate().toString()});
        }
        CatalogPlanEntry candidateInSubsequentCatalog = null;
        for (int i = catalogs.size() - 1; i >= 0; --i) {
            boolean catalogOlderThanSubscriptionStartDate;
            Plan plan;
            StandaloneCatalog c = catalogs.get(i);
            try {
                plan = wrapper.findPlan(c);
            }
            catch (CatalogApiException e) {
                if (e.getCode() == ErrorCode.CAT_NO_SUCH_PLAN.getCode() || e.getCode() == ErrorCode.CAT_PLAN_NOT_FOUND.getCode()) continue;
                throw e;
            }
            boolean oldestCatalog = i == 0;
            DateTime catalogEffectiveDate = CatalogDateHelper.toUTCDateTime(c.getEffectiveDate());
            boolean bl = catalogOlderThanSubscriptionStartDate = !subscriptionStartDate.isBefore((ReadableInstant)catalogEffectiveDate);
            if (oldestCatalog || catalogOlderThanSubscriptionStartDate) {
                return new CatalogPlanEntry(c, plan);
            }
            if (plan.getEffectiveDateForExistingSubscriptions() != null) {
                DateTime existingSubscriptionDate = CatalogDateHelper.toUTCDateTime(plan.getEffectiveDateForExistingSubscriptions());
                if (!requestedDate.isAfter((ReadableInstant)existingSubscriptionDate)) continue;
                return new CatalogPlanEntry(c, plan);
            }
            if (candidateInSubsequentCatalog != null) continue;
            candidateInSubsequentCatalog = new CatalogPlanEntry(c, plan);
        }
        if (candidateInSubsequentCatalog != null) {
            return candidateInSubsequentCatalog;
        }
        PlanSpecifier spec = wrapper.getSpec();
        throw new CatalogApiException(ErrorCode.CAT_PLAN_NOT_FOUND, new Object[]{spec.getPlanName() != null ? spec.getPlanName() : "undefined", spec.getProductName() != null ? spec.getProductName() : "undefined", spec.getBillingPeriod() != null ? spec.getBillingPeriod() : "undefined", spec.getPriceListName() != null ? spec.getPriceListName() : "undefined"});
    }

    public Clock getClock() {
        return this.clock;
    }

    public List<StandaloneCatalog> getVersions() {
        return this.versions;
    }

    public void add(StandaloneCatalog e) {
        if (this.catalogName == null && e.getCatalogName() != null) {
            this.catalogName = e.getCatalogName();
        }
        this.versions.add(e);
        Collections.sort(this.versions, new Comparator<StandaloneCatalog>(){

            @Override
            public int compare(StandaloneCatalog c1, StandaloneCatalog c2) {
                return c1.getEffectiveDate().compareTo(c2.getEffectiveDate());
            }
        });
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Collection<Product> getProducts(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentProducts();
    }

    public Currency[] getSupportedCurrencies(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentSupportedCurrencies();
    }

    public Unit[] getUnits(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentUnits();
    }

    public Collection<Plan> getPlans(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentPlans();
    }

    public PriceListSet getPriceLists(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getPriceLists();
    }

    public Plan findPlan(String name, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).findCurrentPlan(name);
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).createOrFindCurrentPlan(spec, overrides);
    }

    public Plan findPlan(String name, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(name), requestedDate, subscriptionStartDate);
        return entry.getPlan();
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(spec, overrides), requestedDate, subscriptionStartDate);
        return entry.getPlan();
    }

    public Product findProduct(String name, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).findCurrentProduct(name);
    }

    public PlanPhase findPhase(String phaseName, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        String planName = DefaultPlanPhase.planName(phaseName);
        Plan plan = this.findPlan(planName, requestedDate, subscriptionStartDate);
        return plan.findPhase(phaseName);
    }

    public PriceList findPriceListForPlan(String planName, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(planName), requestedDate, subscriptionStartDate);
        return entry.getStaticCatalog().findCurrentPricelist(entry.getPlan().getPriceListName());
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        StaticCatalog staticCatalog = this.getStaticCatalog((PlanSpecifier)planPhase, requestedDate, subscriptionStartDate);
        return staticCatalog.planCancelPolicy(planPhase);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        StaticCatalog staticCatalog = this.getStaticCatalog(specifier, requestedDate, subscriptionStartDate);
        return staticCatalog.planCreateAlignment(specifier);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        StaticCatalog staticCatalog = this.getStaticCatalog((PlanSpecifier)planPhase, requestedDate, subscriptionStartDate);
        return staticCatalog.billingAlignment(planPhase);
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        StaticCatalog staticCatalog = this.getStaticCatalog(to, requestedDate, subscriptionStartDate);
        return staticCatalog.planChange(from, to);
    }

    private StaticCatalog getStaticCatalog(PlanSpecifier spec, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(spec), requestedDate, subscriptionStartDate);
        return entry.getStaticCatalog();
    }

    public void initialize(DefaultVersionedCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public ValidationErrors validate(DefaultVersionedCatalog catalog, ValidationErrors errors) {
        TreeSet<Date> effectiveDates = new TreeSet<Date>();
        for (StandaloneCatalog c : this.versions) {
            if (effectiveDates.contains(c.getEffectiveDate())) {
                errors.add((Object)new ValidationError(String.format("Catalog effective date '%s' already exists for a previous version", c.getEffectiveDate()), c.getCatalogURI(), VersionedCatalog.class, ""));
            } else {
                effectiveDates.add(c.getEffectiveDate());
            }
            if (!c.getCatalogName().equals(this.catalogName)) {
                errors.add((Object)new ValidationError(String.format("Catalog name '%s' is not consistent across versions ", c.getCatalogName()), c.getCatalogURI(), VersionedCatalog.class, ""));
            }
            errors.addAll((Collection)c.validate(c, errors));
        }
        return errors;
    }

    public Date getEffectiveDate() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getEffectiveDate();
    }

    public Date getStandaloneCatalogEffectiveDate(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getEffectiveDate();
    }

    public Currency[] getCurrentSupportedCurrencies() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentSupportedCurrencies();
    }

    public Collection<Product> getCurrentProducts() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentProducts();
    }

    public Unit[] getCurrentUnits() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentUnits();
    }

    public Collection<Plan> getCurrentPlans() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentPlans();
    }

    public Plan createOrFindCurrentPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).createOrFindCurrentPlan(spec, overrides);
    }

    public Plan findCurrentPlan(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPlan(name);
    }

    public Product findCurrentProduct(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentProduct(name);
    }

    public PlanPhase findCurrentPhase(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPhase(name);
    }

    public PriceList findCurrentPricelist(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPriceList(name);
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planChange(from, to);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planCancelPolicy(planPhase);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planCreateAlignment(specifier);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).billingAlignment(planPhase);
    }

    public List<Listing> getAvailableAddOnListings(String baseProductName, @Nullable String priceListName) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getAvailableAddOnListings(baseProductName, priceListName);
    }

    public List<Listing> getAvailableBasePlanListings() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getAvailableBasePlanListings();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        MapperHolder.mapper().readerForUpdating((Object)this).readValue((InputStream)new ExternalizableInput(in));
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        MapperHolder.mapper().writeValue((OutputStream)new ExternalizableOutput(oo), (Object)this);
    }

    private class PlanRequestWrapper {
        private final PlanSpecifier spec;
        private final PlanPhasePriceOverridesWithCallContext overrides;

        public PlanRequestWrapper(String planName) {
            this(new PlanSpecifier(planName));
        }

        public PlanRequestWrapper(PlanSpecifier spec) {
            this(spec, null);
        }

        public PlanRequestWrapper(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) {
            this.spec = spec;
            this.overrides = overrides;
        }

        public Plan findPlan(StandaloneCatalog catalog) throws CatalogApiException {
            return catalog.createOrFindCurrentPlan(this.spec, this.overrides);
        }

        public PlanSpecifier getSpec() {
            return this.spec;
        }
    }

    private static class CatalogPlanEntry {
        private final StaticCatalog staticCatalog;
        private final Plan plan;

        public CatalogPlanEntry(StaticCatalog staticCatalog, Plan plan) {
            this.staticCatalog = staticCatalog;
            this.plan = plan;
        }

        public StaticCatalog getStaticCatalog() {
            return this.staticCatalog;
        }

        public Plan getPlan() {
            return this.plan;
        }
    }
}

