/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogEntity;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPriceList
extends ValidatingConfig<StandaloneCatalog>
implements PriceList {
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlAttribute(required=false)
    private String prettyName;
    @XmlElementWrapper(name="plans", required=true)
    @XmlIDREF
    @XmlElement(type=DefaultPlan.class, name="plan", required=false)
    private CatalogEntityCollection<Plan> plans;

    public DefaultPriceList() {
        this.plans = new CatalogEntityCollection();
    }

    public DefaultPriceList(DefaultPlan[] plans, String name) {
        this.plans = new CatalogEntityCollection((CatalogEntity[])plans);
        this.name = name;
    }

    public Collection<Plan> getPlans() {
        return this.plans;
    }

    public CatalogEntityCollection<Plan> getCatalogEntityCollectionPlan() {
        return this.plans;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public Collection<Plan> findPlans(Product product, BillingPeriod period) {
        ArrayList<Plan> result = new ArrayList<Plan>(this.plans.size());
        for (Plan cur : this.getPlans()) {
            if (!cur.getProduct().equals(product) || cur.getRecurringBillingPeriod() == null || !cur.getRecurringBillingPeriod().equals((Object)period)) continue;
            result.add(cur);
        }
        return result;
    }

    public Plan findPlan(String planName) {
        return this.plans.findByName(planName);
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue((Object)this);
        if (this.prettyName == null) {
            this.prettyName = this.name;
        }
    }

    public DefaultPriceList setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultPriceList setPlans(Iterable<Plan> plans) {
        this.plans = new CatalogEntityCollection<Plan>(plans);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPriceList)) {
            return false;
        }
        DefaultPriceList that = (DefaultPriceList)((Object)o);
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.plans.equals(that.plans);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultPriceList{name='" + this.name + '}';
    }
}

