/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultLimit
extends ValidatingConfig<StandaloneCatalog>
implements Limit {
    @XmlElement(required=true)
    @XmlIDREF
    private DefaultUnit unit;
    @XmlElement(required=false)
    private Double max;
    @XmlElement(required=false)
    private Double min;

    public DefaultUnit getUnit() {
        return this.unit;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMin() {
        return this.min;
    }

    public ValidationErrors validate(StandaloneCatalog root, ValidationErrors errors) {
        if (!CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.max) && !CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.min) && this.max < this.min) {
            errors.add((Object)new ValidationError("max must be greater than min", root.getCatalogURI(), Limit.class, ""));
        }
        return errors;
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue((Object)this);
    }

    public boolean compliesWith(double value) {
        if (!CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.max) && value > this.max) {
            return false;
        }
        return CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.min) || !(value < this.min);
    }

    public DefaultLimit setUnit(DefaultUnit unit) {
        this.unit = unit;
        return this;
    }

    public DefaultLimit setMax(Double max) {
        this.max = max;
        return this;
    }

    public DefaultLimit setMin(Double min) {
        this.min = min;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultLimit)) {
            return false;
        }
        DefaultLimit that = (DefaultLimit)((Object)o);
        if (!this.max.equals(that.max)) {
            return false;
        }
        if (!this.min.equals(that.min)) {
            return false;
        }
        return !(this.unit != null ? !this.unit.equals((Object)that.unit) : that.unit != null);
    }

    public int hashCode() {
        int result = this.unit != null ? this.unit.hashCode() : 0;
        result = 31 * result + this.max.hashCode();
        result = 31 * result + this.min.hashCode();
        return result;
    }
}

