/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultCasePhase;
import org.killbill.billing.catalog.rules.Result;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCasePhase
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testBasic() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardProduct() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(null, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardProductCategory() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(product, null, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.ADD_ON, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardBillingPeriod() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, null, priceList, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardPriceList() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, null, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardPhaseType() {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, null, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testOrder() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = cat.getPriceLists().getDefaultPricelist();
        DefaultCaseResult cr0 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.FOO);
        DefaultCaseResult cr1 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.BAR);
        DefaultCaseResult cr2 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, PhaseType.EVERGREEN, Result.TINKYWINKY);
        DefaultCaseResult cr3 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.ANNUAL, priceList, PhaseType.EVERGREEN, Result.DIPSY);
        DefaultCaseResult cr4 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.ANNUAL, priceList, PhaseType.EVERGREEN, Result.LALA);
        Result r1 = (Result)((Object)DefaultCasePhase.getResult((DefaultCasePhase[])new DefaultCaseResult[]{cr0, cr1, cr2, cr3, cr4}, (PlanPhaseSpecifier)new PlanPhaseSpecifier(product.getName(), BillingPeriod.MONTHLY, priceList.getName(), PhaseType.EVERGREEN), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)Result.FOO), (Object)((Object)r1));
        Result r2 = (Result)((Object)DefaultCasePhase.getResult((DefaultCasePhase[])new DefaultCaseResult[]{cr0, cr1, cr2, cr3, cr4}, (PlanPhaseSpecifier)new PlanPhaseSpecifier(product.getName(), BillingPeriod.ANNUAL, priceList.getName(), PhaseType.EVERGREEN), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)Result.DIPSY), (Object)((Object)r2));
    }

    protected void assertionNull(DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            Assert.assertNull((Object)cr.getResult(new PlanPhaseSpecifier(productName, bp, priceListName, phaseType), (StaticCatalog)cat));
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    protected void assertionException(DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            Assert.assertNull((Object)cr.getResult(new PlanPhaseSpecifier(productName, bp, priceListName, phaseType), (StaticCatalog)cat));
            Assert.fail((String)"Exception expected");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_PRICE_LIST_NOT_FOUND.getCode());
        }
    }

    protected void assertion(Result result, DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            Assert.assertEquals((Object)((Object)result), (Object)cr.getResult(new PlanPhaseSpecifier(productName, bp, priceListName, phaseType), (StaticCatalog)cat));
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultCaseResult
    extends DefaultCasePhase<Result> {
        @XmlElement(required=true)
        private final Result policy;

        public DefaultCaseResult(DefaultProduct product, ProductCategory productCategory, BillingPeriod billingPeriod, DefaultPriceList priceList, PhaseType phaseType, Result policy) {
            this.setProduct((Product)product);
            this.setProductCategory(productCategory);
            this.setBillingPeriod(billingPeriod);
            this.setPriceList(priceList);
            this.setPhaseType(phaseType);
            this.policy = policy;
        }

        protected Result getResult() {
            return this.policy;
        }
    }
}

