/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.util.ArrayList;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCatalogOverridePlanPhaseSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePlanPhaseModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverridePlanPhaseModelDao obj1 = new CatalogOverridePlanPhaseModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        this.performTestInTransaction(new WithCatalogOverridePlanPhaseSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePlanPhaseSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverridePlanPhaseModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)rehydrated.getPhaseNumber(), (Object)obj1.getPhaseNumber());
                Assert.assertEquals((Object)rehydrated.getPhaseDefRecordId(), (Object)obj1.getPhaseDefRecordId());
                Assert.assertEquals((Object)rehydrated.getTargetPlanDefRecordId(), (Object)obj1.getTargetPlanDefRecordId());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetPlanDefinition() throws Exception {
        final CatalogOverridePlanPhaseModelDao obj1 = new CatalogOverridePlanPhaseModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverridePlanPhaseModelDao obj2 = new CatalogOverridePlanPhaseModelDao(Short.valueOf((short)2), Long.valueOf(5L), Long.valueOf(3L));
        final CatalogOverridePlanPhaseModelDao obj3 = new CatalogOverridePlanPhaseModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(3L));
        final CatalogOverridePlanPhaseModelDao nobj1 = new CatalogOverridePlanPhaseModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverridePlanPhaseSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverridePlanPhaseSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                sqlDao.create(obj3, (InternalCallContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                sqlDao.create(nobj1, (InternalCallContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                keys.add("2,5");
                keys.add("4,7");
                Long targetPlan = sqlDao.getTargetPlanDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverridePlanPhaseSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)targetPlan, (Object)new Long(3L));
                return null;
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverridePlanPhaseSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePlanPhaseSqlDao sqlDao = (CatalogOverridePlanPhaseSqlDao)handle.attach(CatalogOverridePlanPhaseSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface WithCatalogOverridePlanPhaseSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverridePlanPhaseSqlDao var1);
    }
}

