/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.MockRecurring;
import org.killbill.billing.catalog.PriceListDefault;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPriceListSet
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testOverriding() throws CatalogApiException {
        DefaultProduct foo = new DefaultProduct("Foo", ProductCategory.BASE);
        DefaultProduct bar = new DefaultProduct("Bar", ProductCategory.BASE);
        DefaultPlan[] defaultPlans = new DefaultPlan[]{new MockPlan().setName("plan-foo-monthly").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.MONTHLY, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-bar-monthly").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.MONTHLY, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-foo-annual").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-bar-annual").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.EVERGREEN))};
        DefaultPlan[] childPlans = new DefaultPlan[]{new MockPlan().setName("plan-foo").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.DISCOUNT)), new MockPlan().setName("plan-bar").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.DISCOUNT))};
        PriceListDefault defaultPriceList = new PriceListDefault(defaultPlans);
        DefaultPriceList[] childPriceLists = new DefaultPriceList[]{new DefaultPriceList(childPlans, "child")};
        DefaultPriceListSet set = new DefaultPriceListSet((DefaultPriceList)defaultPriceList, childPriceLists);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.ANNUAL, "DEFAULT").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.MONTHLY, "DEFAULT").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.ANNUAL, "child").getFinalPhase().getPhaseType(), (Object)PhaseType.DISCOUNT);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.MONTHLY, "child").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
    }

    @Test(groups={"fast"})
    public void testForNullBillingPeriod() throws CatalogApiException {
        DefaultProduct foo = new DefaultProduct("Foo", ProductCategory.BASE);
        DefaultProduct bar = new DefaultProduct("Bar", ProductCategory.BASE);
        DefaultPlan[] defaultPlans = new DefaultPlan[]{new MockPlan().setName("plan-foo-monthly").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.MONTHLY, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-bar-monthly").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.MONTHLY, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-foo-annual").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.EVERGREEN)), new MockPlan().setName("plan-bar-annual").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.EVERGREEN))};
        DefaultPlan[] childPlans = new DefaultPlan[]{new MockPlan().setName("plan-foo").setProduct((Product)foo).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.DISCOUNT)), new MockPlan().setName("plan-bar").setProduct((Product)bar).setFinalPhase(new MockPlanPhase().setRecurring(new MockRecurring(BillingPeriod.ANNUAL, null)).setPhaseType(PhaseType.DISCOUNT))};
        PriceListDefault defaultPriceList = new PriceListDefault(defaultPlans);
        DefaultPriceList[] childPriceLists = new DefaultPriceList[]{new DefaultPriceList(childPlans, "child")};
        DefaultPriceListSet set = new DefaultPriceListSet((DefaultPriceList)defaultPriceList, childPriceLists);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.ANNUAL, "child").getFinalPhase().getPhaseType(), (Object)PhaseType.DISCOUNT);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.MONTHLY, "child").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.ANNUAL, "DEFAULT").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertEquals((Object)set.getPlanFrom((Product)foo, BillingPeriod.MONTHLY, "DEFAULT").getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
    }
}

