/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.api.FixedType;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCatalogSafetyInitializer {
    @XmlElementWrapper(name="initialPhasesWrapperAllRequired", required=true)
    @XmlElement(name="phase", required=true)
    private DefaultPlanPhase[] initialPhasesWrapperAllRequired;
    @XmlElementWrapper(name="initialPhasesWrapperNotRequired", required=false)
    @XmlElement(name="phase", required=false)
    private DefaultPlanPhase[] initialPhasesWrapperNotRequired;
    @XmlElementWrapper(name="initialPhasesWrapper", required=true)
    @XmlElement(name="phase", required=false)
    private DefaultPlanPhase[] initialPhasesWrapper;
    @XmlElement(name="pricesNotRequired", required=false)
    private DefaultPrice[] pricesNotRequired;
    @XmlElement(name="prices", required=true)
    private DefaultPrice[] prices;
    @XmlElementWrapper(name="available", required=false)
    @XmlIDREF
    @XmlElement(type=DefaultProduct.class, name="addonProduct", required=false)
    private CatalogEntityCollection<Product> available;
    @XmlElement(required=true)
    private TimeUnit unit;
    @XmlElement(required=false)
    private Integer number;
    @XmlElement(required=false)
    private int smallNumber;
    @XmlAttribute(required=false)
    private FixedType type;

    @Test(groups={"fast"})
    public void testNonRequiredArrayFields() {
        TestCatalogSafetyInitializer test = new TestCatalogSafetyInitializer();
        Assert.assertNull((Object)test.getInitialPhasesWrapperAllRequired());
        Assert.assertNull((Object)test.getInitialPhasesWrapperNotRequired());
        Assert.assertNull((Object)test.getInitialPhasesWrapper());
        Assert.assertNull((Object)test.getPricesNotRequired());
        Assert.assertNull((Object)test.getPrices());
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue((Object)test);
        Assert.assertNull((Object)test.getInitialPhasesWrapperAllRequired());
        Assert.assertNotNull((Object)test.getInitialPhasesWrapperNotRequired());
        Assert.assertEquals((int)test.getInitialPhasesWrapperNotRequired().length, (int)0);
        Assert.assertNull((Object)test.getInitialPhasesWrapper());
        Assert.assertNotNull((Object)test.getPricesNotRequired());
        Assert.assertEquals((int)test.getPricesNotRequired().length, (int)0);
        Assert.assertNull((Object)test.getPrices());
        Assert.assertNotNull((Object)test.getNumber());
        Assert.assertEquals((Object)test.getNumber(), (Object)CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_INTEGER_FIELD_VALUE);
        Assert.assertNotNull((Object)test.getSmallNumber());
        Assert.assertNotNull((Object)test.getType());
        Assert.assertEquals((Object)test.getType(), (Object)FixedType.ONE_TIME);
    }

    public DefaultPlanPhase[] getInitialPhasesWrapperAllRequired() {
        return this.initialPhasesWrapperAllRequired;
    }

    public DefaultPlanPhase[] getInitialPhasesWrapperNotRequired() {
        return this.initialPhasesWrapperNotRequired;
    }

    public DefaultPlanPhase[] getInitialPhasesWrapper() {
        return this.initialPhasesWrapper;
    }

    public DefaultPrice[] getPricesNotRequired() {
        return this.pricesNotRequired;
    }

    public DefaultPrice[] getPrices() {
        return this.prices;
    }

    public CatalogEntityCollection<Product> getAvailable() {
        return this.available;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public Integer getNumber() {
        return this.number;
    }

    public int getSmallNumber() {
        return this.smallNumber;
    }

    public FixedType getType() {
        return this.type;
    }
}

