/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockProduct;
import org.killbill.billing.catalog.PriceListDefault;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.rules.DefaultPlanRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockCatalog
extends StandaloneCatalog
implements Catalog {
    private PlanChangeResult planChange;
    private BillingAlignment billingAlignment;
    private PlanAlignmentCreate planCreateAlignment;

    public MockCatalog() {
        this.setEffectiveDate(new Date());
        this.setProducts(MockProduct.createAll());
        this.setPlans(MockPlan.createAll());
        this.populateRules();
        this.populatePriceLists();
    }

    public void populateRules() {
        this.setPlanRules(new DefaultPlanRules());
    }

    public void populatePriceLists() {
        Collection plans = this.getCurrentPlans();
        DefaultPriceList[] priceList = new DefaultPriceList[plans.size() - 1];
        int i = 1;
        Iterator it = plans.iterator();
        Plan initialPlan = (Plan)it.next();
        while (it.hasNext()) {
            Plan plan = (Plan)it.next();
            priceList[i - 1] = new DefaultPriceList(new DefaultPlan[]{(DefaultPlan)plan}, plan.getName() + "-pl");
            ++i;
        }
        DefaultPriceListSet set = new DefaultPriceListSet((DefaultPriceList)new PriceListDefault(new DefaultPlan[]{(DefaultPlan)initialPlan}), priceList);
        this.setPriceLists(set);
    }

    public Date getStandaloneCatalogEffectiveDate(DateTime dateTime) {
        return this.getEffectiveDate();
    }

    public Currency[] getSupportedCurrencies(DateTime requestedDate) {
        return this.getCurrentSupportedCurrencies();
    }

    public Unit[] getUnits(DateTime requestedDate) {
        return this.getCurrentUnits();
    }

    public Collection<Product> getProducts(DateTime requestedDate) {
        return this.getCurrentProducts();
    }

    public Collection<Plan> getPlans(DateTime requestedDate) {
        return this.getCurrentPlans();
    }

    public PriceListSet getPriceLists(DateTime dateTime) {
        return this.getPriceLists();
    }

    public Plan findPlan(String name, DateTime requestedDate) throws CatalogApiException {
        return this.findCurrentPlan(name);
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate) throws CatalogApiException {
        return this.createOrFindCurrentPlan(spec, overrides);
    }

    public Plan findPlan(String name, DateTime effectiveDate, DateTime subscriptionStartDate) throws CatalogApiException {
        return this.findCurrentPlan(name);
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        return this.createOrFindCurrentPlan(spec, overrides);
    }

    public Product findProduct(String name, DateTime requestedDate) throws CatalogApiException {
        return this.findCurrentProduct(name);
    }

    public PlanPhase findPhase(String name, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        return this.findCurrentPhase(name);
    }

    public PriceList findPriceListForPlan(String name, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        return this.findCurrentPricelist(this.findCurrentPlan(name).getPriceListName());
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to, DateTime requestedDate, DateTime subscriptionStartDate) {
        return this.planChange(from, to);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        return this.planCancelPolicy(planPhase);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier, DateTime requestedDate, DateTime subscriptionStartDate) {
        return this.planCreateAlignment(specifier);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase, DateTime requestedDate, DateTime subscriptionStartDate) {
        return this.billingAlignment(planPhase);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return super.planCancelPolicy(planPhase);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier) {
        return this.planCreateAlignment;
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase) {
        return this.billingAlignment;
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to) {
        return this.planChange;
    }

    public DefaultProduct getCurrentProduct(int idx) {
        return (DefaultProduct)this.getCurrentProducts().toArray()[idx];
    }

    public void setPlanChange(PlanChangeResult planChange) {
        this.planChange = planChange;
    }

    public void setBillingAlignment(BillingAlignment billingAlignment) {
        this.billingAlignment = billingAlignment;
    }

    public void setPlanCreateAlignment(PlanAlignmentCreate planCreateAlignment) {
        this.planCreateAlignment = planCreateAlignment;
    }
}

