/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.plugin;

import javax.inject.Inject;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.VersionedCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.catalog.plugin.StandaloneCatalogMapper;
import org.killbill.billing.catalog.plugin.api.StandalonePluginCatalog;
import org.killbill.billing.catalog.plugin.api.VersionedPluginCatalog;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.clock.Clock;

public class VersionedCatalogMapper {
    private final Clock clock;
    private final PriceOverride priceOverride;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public VersionedCatalogMapper(Clock clock, PriceOverride priceOverride, InternalCallContextFactory internalCallContextFactory) {
        this.clock = clock;
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public VersionedCatalog toVersionedCatalog(VersionedPluginCatalog pluginCatalog, InternalTenantContext internalTenantContext) throws CatalogApiException {
        VersionedCatalog result = new VersionedCatalog(this.clock);
        for (StandalonePluginCatalog cur : pluginCatalog.getStandalonePluginCatalogs()) {
            result.add(this.toStandaloneCatalogWithPriceOverride(pluginCatalog, cur, internalTenantContext));
        }
        return result;
    }

    private StandaloneCatalogWithPriceOverride toStandaloneCatalogWithPriceOverride(VersionedPluginCatalog pluginCatalog, StandalonePluginCatalog input, InternalTenantContext internalTenantContext) {
        StandaloneCatalogMapper mapper = new StandaloneCatalogMapper(pluginCatalog.getCatalogName(), pluginCatalog.getRecurringBillingMode());
        StandaloneCatalog catalog = mapper.toStandaloneCatalog(input, null);
        StandaloneCatalogWithPriceOverride result = new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, internalTenantContext.getTenantRecordId(), this.internalCallContextFactory);
        return result;
    }
}

