/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.rules.Case;
import org.killbill.billing.catalog.api.rules.CaseBillingAlignment;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.api.rules.CaseChange;
import org.killbill.billing.catalog.api.rules.CaseChangePlanAlignment;
import org.killbill.billing.catalog.api.rules.CaseChangePlanPolicy;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;
import org.killbill.billing.catalog.api.rules.CasePhase;
import org.killbill.billing.catalog.api.rules.CasePriceList;
import org.killbill.billing.catalog.api.rules.PlanRules;
import org.killbill.billing.catalog.plugin.api.StandalonePluginCatalog;
import org.killbill.billing.catalog.rules.DefaultCaseBillingAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseCancelPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseChange;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseCreateAlignment;
import org.killbill.billing.catalog.rules.DefaultCasePhase;
import org.killbill.billing.catalog.rules.DefaultCasePriceList;
import org.killbill.billing.catalog.rules.DefaultCaseStandardNaming;
import org.killbill.billing.catalog.rules.DefaultPlanRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneCatalogMapper {
    private final String catalogName;
    private final BillingMode recurringBillingMode;
    private Iterable<Product> tmpDefaultProducts;
    private Iterable<Plan> tmpDefaultPlans;
    private DefaultPriceListSet tmpDefaultPriceListSet;
    private Map<String, DefaultPriceList> tmpDefaultPriceListMap;

    public StandaloneCatalogMapper(String catalogName, BillingMode recurringBillingMode) {
        this.catalogName = catalogName;
        this.recurringBillingMode = recurringBillingMode;
        this.tmpDefaultProducts = null;
        this.tmpDefaultPlans = null;
        this.tmpDefaultPriceListMap = new HashMap<String, DefaultPriceList>();
    }

    public StandaloneCatalog toStandaloneCatalog(StandalonePluginCatalog pluginCatalog, @Nullable URI catalogURI) {
        StandaloneCatalog result = new StandaloneCatalog();
        result.setCatalogName(this.catalogName);
        result.setEffectiveDate(pluginCatalog.getEffectiveDate().toDate());
        result.setProducts(this.toDefaultProducts(pluginCatalog.getProducts()));
        result.setPlans(this.toDefaultPlans(pluginCatalog.getPlans()));
        result.setPriceLists(this.toDefaultPriceListSet(pluginCatalog.getDefaultPriceList(), pluginCatalog.getChildrenPriceList()));
        result.setRecurringBillingMode(this.recurringBillingMode);
        result.setSupportedCurrencies((Currency[])this.toArray(pluginCatalog.getCurrencies()));
        result.setUnits(this.toDefaultUnits(pluginCatalog.getUnits()));
        result.setPlanRules(this.toDefaultPlanRules(pluginCatalog.getPlanRules()));
        block0: for (Product cur : pluginCatalog.getProducts()) {
            for (Product target : result.getCurrentProducts()) {
                if (!target.getName().equals(cur.getName())) continue;
                ((DefaultProduct)target).setAvailable(this.toFilteredDefaultProduct(cur.getAvailable()));
                ((DefaultProduct)target).setIncluded(this.toFilteredDefaultProduct(cur.getIncluded()));
                continue block0;
            }
        }
        result.initialize(result, catalogURI);
        return result;
    }

    private DefaultPlanRules toDefaultPlanRules(PlanRules input) {
        DefaultPlanRules result = new DefaultPlanRules();
        result.setBillingAlignmentCase(this.toDefaultCaseBillingAlignments(input.getCaseBillingAlignment()));
        result.setCancelCase(this.toDefaultCaseCancelPolicys(input.getCaseCancelPolicy()));
        result.setChangeAlignmentCase(this.toDefaultCaseChangePlanAlignments(input.getCaseChangePlanAlignment()));
        result.setChangeCase(this.toDefaultCaseChangePlanPolicies(input.getCaseChangePlanPolicy()));
        result.setCreateAlignmentCase(this.toDefaultCaseCreateAlignments(input.getCaseCreateAlignment()));
        result.setPriceListCase(this.toDefaultCasePriceLists(input.getCasePriceList()));
        return result;
    }

    final DefaultCaseChangePlanPolicy[] toDefaultCaseChangePlanPolicies(Iterable<CaseChangePlanPolicy> input) {
        return this.toArrayWithTransform(input, new Function<CaseChangePlanPolicy, DefaultCaseChangePlanPolicy>(){

            public DefaultCaseChangePlanPolicy apply(CaseChangePlanPolicy input) {
                return StandaloneCatalogMapper.this.toDefaultCaseChangePlanPolicy(input);
            }
        }, true);
    }

    final DefaultCaseChangePlanAlignment[] toDefaultCaseChangePlanAlignments(Iterable<CaseChangePlanAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseChangePlanAlignment, DefaultCaseChangePlanAlignment>(){

            public DefaultCaseChangePlanAlignment apply(CaseChangePlanAlignment input) {
                return StandaloneCatalogMapper.this.toDefaultCaseChangePlanAlignment(input);
            }
        }, true);
    }

    final DefaultCaseBillingAlignment[] toDefaultCaseBillingAlignments(Iterable<CaseBillingAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseBillingAlignment, DefaultCaseBillingAlignment>(){

            public DefaultCaseBillingAlignment apply(CaseBillingAlignment input) {
                return StandaloneCatalogMapper.this.toDefaultCaseBillingAlignment(input);
            }
        }, true);
    }

    final DefaultCaseCancelPolicy[] toDefaultCaseCancelPolicys(Iterable<CaseCancelPolicy> input) {
        return this.toArrayWithTransform(input, new Function<CaseCancelPolicy, DefaultCaseCancelPolicy>(){

            public DefaultCaseCancelPolicy apply(CaseCancelPolicy input) {
                return StandaloneCatalogMapper.this.toDefaultCaseCancelPolicy(input);
            }
        }, true);
    }

    final DefaultCaseCreateAlignment[] toDefaultCaseCreateAlignments(Iterable<CaseCreateAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseCreateAlignment, DefaultCaseCreateAlignment>(){

            public DefaultCaseCreateAlignment apply(CaseCreateAlignment input) {
                return StandaloneCatalogMapper.this.toCaseCreateAlignment(input);
            }
        }, true);
    }

    final DefaultCasePriceList[] toDefaultCasePriceLists(Iterable<CasePriceList> input) {
        return this.toArrayWithTransform(input, new Function<CasePriceList, DefaultCasePriceList>(){

            public DefaultCasePriceList apply(CasePriceList input) {
                return StandaloneCatalogMapper.this.toDefaultCasePriceList(input);
            }
        }, true);
    }

    final DefaultCasePriceList toDefaultCasePriceList(CasePriceList input) {
        DefaultCasePriceList result = new DefaultCasePriceList();
        result.setToPriceList(this.toDefaultPriceList(input.getDestinationPriceList()));
        this.populateDefaultCase((Case)input, result);
        return result;
    }

    final DefaultCaseCreateAlignment toCaseCreateAlignment(CaseCreateAlignment input) {
        DefaultCaseCreateAlignment result = new DefaultCaseCreateAlignment();
        result.setAlignment(input.getPlanAlignmentCreate());
        this.populateDefaultCase((Case)input, result);
        return result;
    }

    final DefaultCaseBillingAlignment toDefaultCaseBillingAlignment(CaseBillingAlignment input) {
        DefaultCaseBillingAlignment result = new DefaultCaseBillingAlignment();
        result.setAlignment(input.getBillingAlignment());
        this.populateDefaultCasePhase((CasePhase)input, result);
        return result;
    }

    final DefaultCaseCancelPolicy toDefaultCaseCancelPolicy(CaseCancelPolicy input) {
        DefaultCaseCancelPolicy result = new DefaultCaseCancelPolicy();
        result.setPolicy(input.getBillingActionPolicy());
        this.populateDefaultCasePhase((CasePhase)input, result);
        return result;
    }

    final void populateDefaultCasePhase(CasePhase input, DefaultCasePhase result) {
        result.setPhaseType(input.getPhaseType());
        this.populateDefaultCase((Case)input, result);
    }

    final void populateDefaultCase(Case input, DefaultCaseStandardNaming result) {
        result.setBillingPeriod(input.getBillingPeriod());
        result.setPriceList(this.toDefaultPriceList(input.getPriceList()));
        result.setProduct(this.toDefaultProduct(input.getProduct()));
        result.setProductCategory(input.getProductCategory());
    }

    final DefaultCaseChangePlanPolicy toDefaultCaseChangePlanPolicy(CaseChangePlanPolicy input) {
        DefaultCaseChangePlanPolicy result = new DefaultCaseChangePlanPolicy();
        result.setPolicy(input.getBillingActionPolicy());
        this.populateDefaultCaseChange((CaseChange)input, result);
        return result;
    }

    final DefaultCaseChangePlanAlignment toDefaultCaseChangePlanAlignment(CaseChangePlanAlignment input) {
        DefaultCaseChangePlanAlignment result = new DefaultCaseChangePlanAlignment();
        result.setAlignment(input.getAlignment());
        this.populateDefaultCaseChange((CaseChange)input, result);
        return result;
    }

    final void populateDefaultCaseChange(CaseChange input, DefaultCaseChange result) {
        result.setPhaseType(input.getPhaseType());
        result.setFromBillingPeriod(input.getFromBillingPeriod());
        result.setFromPriceList(this.toDefaultPriceList(input.getFromPriceList()));
        result.setFromProduct(this.toDefaultProduct(input.getFromProduct()));
        result.setFromProductCategory(input.getFromProductCategory());
        result.setToBillingPeriod(input.getToBillingPeriod());
        result.setToPriceList(this.toDefaultPriceList(input.getToPriceList()));
        result.setToProduct(this.toDefaultProduct(input.getToProduct()));
        result.setToProductCategory(input.getToProductCategory());
    }

    private Iterable<Product> toDefaultProducts(Iterable<Product> input) {
        if (this.tmpDefaultProducts == null) {
            Function<Product, Product> productTransformer = new Function<Product, Product>(){

                public Product apply(Product input) {
                    return StandaloneCatalogMapper.this.toDefaultProduct(input);
                }
            };
            this.tmpDefaultProducts = ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)productTransformer));
        }
        return this.tmpDefaultProducts;
    }

    private Collection<Product> toFilteredDefaultProduct(Collection<Product> input) {
        if (!input.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Iterable inputProductNames = Iterables.transform(input, (Function)new Function<Product, String>(){

            public String apply(Product input) {
                return input.getName();
            }
        });
        ArrayList<Product> filteredAndOrdered = new ArrayList<Product>(input.size());
        for (final String cur : inputProductNames) {
            Product found = this.findOrIllegalState(this.tmpDefaultProducts, new Predicate<Product>(){

                public boolean apply(Product inputPredicate) {
                    return inputPredicate.getName().equals(cur);
                }
            }, "Failed to find product " + cur);
            filteredAndOrdered.add(found);
        }
        return filteredAndOrdered;
    }

    private Iterable<Plan> toDefaultPlans(Iterable<Plan> input) {
        if (this.tmpDefaultPlans == null) {
            Function<Plan, Plan> planTransformer = new Function<Plan, Plan>(){

                public Plan apply(Plan input) {
                    return StandaloneCatalogMapper.this.toDefaultPlan(input);
                }
            };
            this.tmpDefaultPlans = ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)planTransformer));
        }
        return this.tmpDefaultPlans;
    }

    private Iterable<Plan> toFilterDefaultPlans(final String priceListName) {
        if (this.tmpDefaultPlans == null) {
            throw new IllegalStateException("Cannot filter on uninitialized plans");
        }
        return Iterables.filter(this.tmpDefaultPlans, (Predicate)new Predicate<Plan>(){

            public boolean apply(Plan input) {
                return input.getPriceListName().equals(priceListName);
            }
        });
    }

    private DefaultPriceListSet toDefaultPriceListSet(PriceList defaultPriceList, Iterable<PriceList> childrenPriceLists) {
        if (this.tmpDefaultPriceListSet == null) {
            this.tmpDefaultPriceListSet = new DefaultPriceListSet(this.toDefaultPriceList(defaultPriceList), this.toDefaultPriceLists(childrenPriceLists));
        }
        return this.tmpDefaultPriceListSet;
    }

    private DefaultPlanPhase[] toDefaultPlanPhases(Iterable<PlanPhase> input) {
        if (!input.iterator().hasNext()) {
            return new DefaultPlanPhase[0];
        }
        return this.toArrayWithTransform(input, new Function<PlanPhase, DefaultPlanPhase>(){

            public DefaultPlanPhase apply(PlanPhase input) {
                return StandaloneCatalogMapper.this.toDefaultPlanPhase(input);
            }
        }, false);
    }

    private DefaultPriceList[] toDefaultPriceLists(Iterable<PriceList> input) {
        return this.toArrayWithTransform(input, new Function<PriceList, DefaultPriceList>(){

            public DefaultPriceList apply(PriceList input) {
                return StandaloneCatalogMapper.this.toDefaultPriceList(input);
            }
        }, true);
    }

    private DefaultPrice[] toDefaultPrices(Iterable<Price> input) {
        return this.toArrayWithTransform(input, new Function<Price, DefaultPrice>(){

            public DefaultPrice apply(Price input) {
                return StandaloneCatalogMapper.this.toDefaultPrice(input);
            }
        }, false);
    }

    private DefaultUnit[] toDefaultUnits(Iterable<Unit> input) {
        return this.toArrayWithTransform(input, new Function<Unit, DefaultUnit>(){

            public DefaultUnit apply(Unit inputTransform) {
                return StandaloneCatalogMapper.this.toDefaultUnit(inputTransform);
            }
        }, true);
    }

    private DefaultUnit toDefaultUnit(Unit input) {
        DefaultUnit result = new DefaultUnit();
        result.setName(input.getName());
        return result;
    }

    private DefaultPriceList toDefaultPriceList(@Nullable PriceList input) {
        if (input == null) {
            return null;
        }
        DefaultPriceList result = this.tmpDefaultPriceListMap.get(input.getName());
        if (result == null) {
            result = new DefaultPriceList();
            result.setName(input.getName());
            result.setPlans(this.toFilterDefaultPlans(input.getName()));
            this.tmpDefaultPriceListMap.put(input.getName(), result);
        }
        return result;
    }

    private Product toDefaultProduct(final @Nullable Product input) {
        if (input == null) {
            return null;
        }
        if (this.tmpDefaultProducts != null) {
            Product existingProduct = this.findOrIllegalState(this.tmpDefaultProducts, new Predicate<Product>(){

                public boolean apply(Product predicateInput) {
                    return predicateInput.getName().equals(input.getName());
                }
            }, "Unknown product " + input.getName());
            return existingProduct;
        }
        DefaultProduct result = new DefaultProduct();
        result.setCatalogName(this.catalogName);
        result.setCatagory(input.getCategory());
        result.setName(input.getName());
        return result;
    }

    private Plan toDefaultPlan(final Plan input) {
        if (this.tmpDefaultPlans != null) {
            Plan existingPlan = this.findOrIllegalState(this.tmpDefaultPlans, new Predicate<Plan>(){

                public boolean apply(Plan predicateInput) {
                    return predicateInput.getName().equals(input.getName());
                }
            }, "Unknown plan " + input.getName());
            return existingPlan;
        }
        DefaultPlan result = new DefaultPlan();
        result.setName(input.getName());
        result.setEffectiveDateForExistingSubscriptions(input.getEffectiveDateForExistingSubscriptions());
        result.setFinalPhase(this.toDefaultPlanPhase(input.getFinalPhase()));
        result.setInitialPhases(this.toDefaultPlanPhases((Iterable<PlanPhase>)ImmutableList.copyOf((Object[])input.getInitialPhases())));
        result.setPlansAllowedInBundle(input.getPlansAllowedInBundle());
        result.setProduct(this.toDefaultProduct(input.getProduct()));
        result.setPriceListName(input.getPriceListName());
        return result;
    }

    private DefaultPlanPhase toDefaultPlanPhase(PlanPhase input) {
        DefaultPlanPhase result = new DefaultPlanPhase();
        result.setDuration(this.toDefaultDuration(input.getDuration()));
        result.setFixed(this.toDefaultFixed(input.getFixed()));
        result.setPhaseType(input.getPhaseType());
        result.setRecurring(this.toDefaultRecurring(input.getRecurring()));
        result.setUsages(new DefaultUsage[0]);
        return result;
    }

    private DefaultRecurring toDefaultRecurring(Recurring input) {
        DefaultRecurring result = null;
        if (input != null) {
            result = new DefaultRecurring();
            result.setBillingPeriod(input.getBillingPeriod());
            result.setRecurringPrice(this.toDefaultInternationalPrice(input.getRecurringPrice()));
        }
        return result;
    }

    private final DefaultDuration toDefaultDuration(Duration input) {
        DefaultDuration result = new DefaultDuration();
        result.setNumber(input.getNumber());
        result.setUnit(input.getUnit());
        return result;
    }

    private final DefaultFixed toDefaultFixed(@Nullable Fixed input) {
        DefaultFixed result = null;
        if (input != null) {
            result = new DefaultFixed();
            result.setFixedPrice(this.toDefaultInternationalPrice(input.getPrice()));
            result.setType(input.getType());
        }
        return result;
    }

    private DefaultInternationalPrice toDefaultInternationalPrice(InternationalPrice input) {
        DefaultInternationalPrice result = new DefaultInternationalPrice();
        result.setPrices(this.toDefaultPrices((Iterable<Price>)ImmutableList.copyOf((Object[])input.getPrices())));
        return result;
    }

    private DefaultPrice toDefaultPrice(Price input) {
        try {
            DefaultPrice result = new DefaultPrice();
            result.setCurrency(input.getCurrency());
            result.setValue(input.getValue());
            return result;
        }
        catch (CurrencyValueNull currencyValueNull) {
            throw new IllegalStateException(currencyValueNull);
        }
    }

    private <I, C extends I> C[] toArrayWithTransform(Iterable<I> input, Function<I, C> transformer, boolean returnNullIfNothing) {
        if (returnNullIfNothing && (input == null || !input.iterator().hasNext())) {
            return null;
        }
        Iterable tmp = Iterables.transform(input, transformer);
        return this.toArray(tmp);
    }

    private <C> C[] toArray(Iterable<C> input) {
        if (!input.iterator().hasNext()) {
            throw new IllegalStateException("Nothing to convert into array");
        }
        Object[] foo = (Object[])Array.newInstance(input.iterator().next().getClass(), 1);
        return ImmutableList.copyOf(input).toArray(foo);
    }

    private <T> T findOrIllegalState(Iterable<T> input, Predicate<T> predicate, String msg) {
        Object result = Iterables.tryFind(input, predicate).orNull();
        if (result == null) {
            throw new IllegalStateException(msg);
        }
        return (T)result;
    }
}

