/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.override;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.caching.OverriddenPlanCache;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionModelDao;
import org.killbill.billing.catalog.override.PriceOverride;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPriceOverride
implements PriceOverride {
    private static final AtomicLong DRY_RUN_PLAN_IDX = new AtomicLong(0L);
    public static final Pattern CUSTOM_PLAN_NAME_PATTERN = Pattern.compile("(.*)-(\\d+)$");
    private final CatalogOverrideDao overrideDao;
    private final OverriddenPlanCache overriddenPlanCache;

    @Inject
    public DefaultPriceOverride(CatalogOverrideDao overrideDao, OverriddenPlanCache overriddenPlanCache) {
        this.overrideDao = overrideDao;
        this.overriddenPlanCache = overriddenPlanCache;
    }

    @Override
    public DefaultPlan getOrCreateOverriddenPlan(Plan parentPlan, DateTime catalogEffectiveDate, List<PlanPhasePriceOverride> overrides, @Nullable InternalCallContext context) throws CatalogApiException {
        String planName;
        PlanPhasePriceOverride[] resolvedOverride = new PlanPhasePriceOverride[parentPlan.getAllPhases().length];
        int index = 0;
        for (final PlanPhase curPhase : parentPlan.getAllPhases()) {
            PlanPhasePriceOverride curOverride = (PlanPhasePriceOverride)Iterables.tryFind(overrides, (Predicate)new Predicate<PlanPhasePriceOverride>(){

                public boolean apply(PlanPhasePriceOverride input) {
                    if (input.getPhaseName() != null) {
                        return input.getPhaseName().equals(curPhase.getName());
                    }
                    PlanPhaseSpecifier curPlanPhaseSpecifier = input.getPlanPhaseSpecifier();
                    return curPlanPhaseSpecifier.getPhaseType().equals((Object)curPhase.getPhaseType());
                }
            }).orNull();
            resolvedOverride[index++] = curOverride != null ? new DefaultPlanPhasePriceOverride(curPhase.getName(), curOverride.getCurrency(), curOverride.getFixedPrice(), curOverride.getRecurringPrice()) : null;
        }
        for (int i = 0; i < resolvedOverride.length; ++i) {
            String error;
            PlanPhasePriceOverride curOverride = resolvedOverride[i];
            if (curOverride == null) continue;
            DefaultPlanPhase curPhase = (DefaultPlanPhase)parentPlan.getAllPhases()[i];
            if (curPhase.getFixed() == null && curOverride.getFixedPrice() != null) {
                error = String.format("There is no existing fixed price for the phase %s", curPhase.getName());
                throw new CatalogApiException(ErrorCode.CAT_INVALID_INVALID_PRICE_OVERRIDE, new Object[]{parentPlan.getName(), error});
            }
            if (curPhase.getRecurring() != null || curOverride.getRecurringPrice() == null) continue;
            error = String.format("There is no existing recurring price for the phase %s", curPhase.getName());
            throw new CatalogApiException(ErrorCode.CAT_INVALID_INVALID_PRICE_OVERRIDE, new Object[]{parentPlan.getName(), error});
        }
        if (context != null) {
            CatalogOverridePlanDefinitionModelDao overriddenPlan = this.overrideDao.getOrCreateOverridePlanDefinition(parentPlan.getName(), catalogEffectiveDate, resolvedOverride, context);
            planName = new StringBuffer(parentPlan.getName()).append("-").append(overriddenPlan.getRecordId()).toString();
        } else {
            planName = new StringBuffer(parentPlan.getName()).append("-dryrun-").append(DRY_RUN_PLAN_IDX.incrementAndGet()).toString();
        }
        DefaultPlan result = new DefaultPlan(planName, (DefaultPlan)parentPlan, resolvedOverride);
        if (context == null) {
            this.overriddenPlanCache.addDryRunPlan(planName, result);
        }
        return result;
    }

    @Override
    public DefaultPlan getOverriddenPlan(String planName, StaticCatalog catalog, InternalTenantContext context) throws CatalogApiException {
        return this.overriddenPlanCache.getOverriddenPlan(planName, catalog, context);
    }
}

