/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.io;

import com.google.common.io.Resources;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.VersionedCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.io.CatalogLoader;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.clock.Clock;
import org.killbill.xmlloader.UriAccessor;
import org.killbill.xmlloader.XMLLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedCatalogLoader
implements CatalogLoader {
    private static final Object PROTOCOL_FOR_FILE = "file";
    private static final String XML_EXTENSION = ".xml";
    private final Clock clock;
    private final PriceOverride priceOverride;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public VersionedCatalogLoader(Clock clock, PriceOverride priceOverride, InternalCallContextFactory internalCallContextFactory) {
        this.clock = clock;
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    @Override
    public VersionedCatalog loadDefaultCatalog(String uriString) throws CatalogApiException {
        try {
            List<Object> xmlURIs;
            if (uriString.endsWith(XML_EXTENSION)) {
                xmlURIs = new ArrayList<URI>();
                xmlURIs.add(new URI(uriString));
            } else {
                URL url = this.getURLFromString(uriString);
                String directoryContents = UriAccessor.accessUriAsString((String)uriString);
                xmlURIs = this.findXmlReferences(directoryContents, url);
            }
            VersionedCatalog result = new VersionedCatalog(this.clock);
            for (URI uRI : xmlURIs) {
                StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromUri((URI)uRI, StandaloneCatalog.class);
                result.add(new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, 0L, this.internalCallContextFactory));
            }
            return result;
        }
        catch (Exception e) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_DEFAULT, new Object[]{"Problem encountered loading catalog: ", e.getMessage()});
        }
    }

    private URL getURLFromString(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return Resources.getResource((String)urlString);
        }
    }

    public VersionedCatalog load(Iterable<String> catalogXMLs, boolean filterTemplateCatalog, Long tenantRecordId) throws CatalogApiException {
        VersionedCatalog result = new VersionedCatalog(this.clock);
        try {
            URI uri = new URI("/tenantCatalog");
            for (String cur : catalogXMLs) {
                ByteArrayInputStream curCatalogStream = new ByteArrayInputStream(cur.getBytes());
                StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((URI)uri, (InputStream)curCatalogStream, StandaloneCatalog.class);
                if (filterTemplateCatalog && catalog.isTemplateCatalog()) continue;
                result.add(new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, tenantRecordId, this.internalCallContextFactory));
            }
            return result;
        }
        catch (CatalogApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantRecordId});
        }
    }

    protected List<URI> findXmlReferences(String directoryContents, URL url) throws URISyntaxException {
        if (url.getProtocol().equals(PROTOCOL_FOR_FILE)) {
            return this.findXmlFileReferences(directoryContents, url);
        }
        return this.findXmlUrlReferences(directoryContents, url);
    }

    protected List<URI> findXmlUrlReferences(String directoryContents, URL url) throws URISyntaxException {
        ArrayList<URI> results = new ArrayList<URI>();
        List<String> urlFragments = this.extractHrefs(directoryContents);
        for (String u : urlFragments) {
            if (!u.endsWith(XML_EXTENSION)) continue;
            if (u.startsWith("/")) {
                results.add(new URI(url.getProtocol() + ":" + u));
                continue;
            }
            if (u.startsWith("http:")) {
                results.add(new URI(u));
                continue;
            }
            results.add(this.appendToURI(url, u));
        }
        return results;
    }

    protected List<String> extractHrefs(String directoryContents) {
        ArrayList<String> results = new ArrayList<String>();
        int start = 0;
        int end = 0;
        String HREF_SEARCH_END = "\"";
        String HREF_LOW_START = "href=\"";
        while (start >= 0) {
            start = directoryContents.indexOf("href=\"", end);
            if (start > 0) {
                start += "href=\"".length();
            }
            end = directoryContents.indexOf("\"", start);
            if (start < 0) continue;
            results.add(directoryContents.substring(start, end));
        }
        start = 0;
        end = 0;
        while (start >= 0) {
            String HREF_CAPS_START = "HREF=\"";
            start = directoryContents.indexOf("HREF=\"", end);
            if (start > 0) {
                start = "href=\"".length();
            }
            end = directoryContents.indexOf("\"", start);
            if (start < 0) continue;
            results.add(directoryContents.substring(start, end));
        }
        return results;
    }

    protected List<URI> findXmlFileReferences(String directoryContents, URL url) throws URISyntaxException {
        String[] filenames;
        ArrayList<URI> results = new ArrayList<URI>();
        for (String filename : filenames = directoryContents.split("\\n")) {
            if (!filename.endsWith(XML_EXTENSION)) continue;
            results.add(this.appendToURI(url, filename));
        }
        return results;
    }

    protected URI appendToURI(URL url, String filename) throws URISyntaxException {
        String f = filename;
        if (!url.toString().endsWith("/")) {
            f = "/" + filename;
        }
        return new URI(url.toString() + f);
    }
}

