/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseSqlDao;
import org.killbill.clock.Clock;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCatalogOverrideDao
implements CatalogOverrideDao {
    private final IDBI dbi;
    private final Clock clock;

    @Inject
    public DefaultCatalogOverrideDao(IDBI dbi, Clock clock) {
        this.dbi = dbi;
        this.clock = clock;
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePlanDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePhaseDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePlanPhaseModelDao.class));
    }

    @Override
    public CatalogOverridePlanDefinitionModelDao getOrCreateOverridePlanDefinition(final String parentPlanName, final DateTime catalogEffectiveDate, final PlanPhasePriceOverride[] resolvedOverride, final InternalCallContext context) {
        return (CatalogOverridePlanDefinitionModelDao)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<CatalogOverridePlanDefinitionModelDao>(){

            public CatalogOverridePlanDefinitionModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseDefinitionModelDao[] overridePhaseDefinitionModelDaos = new CatalogOverridePhaseDefinitionModelDao[resolvedOverride.length];
                for (int i = 0; i < resolvedOverride.length; ++i) {
                    CatalogOverridePhaseDefinitionModelDao createdOverridePhaseDefinitionModelDao;
                    PlanPhasePriceOverride curOverride = resolvedOverride[i];
                    if (curOverride == null) continue;
                    overridePhaseDefinitionModelDaos[i] = createdOverridePhaseDefinitionModelDao = DefaultCatalogOverrideDao.this.getOrCreateOverridePhaseDefinitionFromTransaction(curOverride.getPhaseName(), catalogEffectiveDate, curOverride, handle, context);
                }
                CatalogOverridePlanDefinitionSqlDao sqlDao = (CatalogOverridePlanDefinitionSqlDao)handle.attach(CatalogOverridePlanDefinitionSqlDao.class);
                Long targetPlanDefinitionRecordId = DefaultCatalogOverrideDao.this.getOverridePlanDefinitionFromTransaction(overridePhaseDefinitionModelDaos, handle, context);
                if (targetPlanDefinitionRecordId != null) {
                    return sqlDao.getByRecordId(targetPlanDefinitionRecordId, (InternalTenantContext)context);
                }
                CatalogOverridePlanDefinitionModelDao inputPlanDef = new CatalogOverridePlanDefinitionModelDao(parentPlanName, true, catalogEffectiveDate);
                sqlDao.create(inputPlanDef, context);
                Long recordId = sqlDao.getLastInsertId();
                CatalogOverridePlanDefinitionModelDao resultPlanDef = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
                for (short i = 0; i < overridePhaseDefinitionModelDaos.length; i = (short)((short)(i + 1))) {
                    if (overridePhaseDefinitionModelDaos[i] == null) continue;
                    DefaultCatalogOverrideDao.this.createCatalogOverridePlanPhaseFromTransaction(i, overridePhaseDefinitionModelDaos[i], resultPlanDef, handle, context);
                }
                return resultPlanDef;
            }
        });
    }

    @Override
    public List<CatalogOverridePhaseDefinitionModelDao> getOverriddenPlanPhases(final Long planDefRecordId, final InternalTenantContext context) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<CatalogOverridePhaseDefinitionModelDao>>(){

            public List<CatalogOverridePhaseDefinitionModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)handle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
                return sqlDao.getOverriddenPlanPhases(planDefRecordId, context);
            }
        });
    }

    private Long getOverridePlanDefinitionFromTransaction(CatalogOverridePhaseDefinitionModelDao[] overridePhaseDefinitionModelDaos, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePlanPhaseSqlDao sqlDao = (CatalogOverridePlanPhaseSqlDao)inTransactionHandle.attach(CatalogOverridePlanPhaseSqlDao.class);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < overridePhaseDefinitionModelDaos.length; ++i) {
            CatalogOverridePhaseDefinitionModelDao cur = overridePhaseDefinitionModelDaos[i];
            if (cur == null) continue;
            StringBuffer key = new StringBuffer();
            key.append(i);
            key.append(",");
            key.append(cur.getRecordId());
            keys.add(key.toString());
        }
        return keys.size() > 0 ? sqlDao.getTargetPlanDefinition(keys, keys.size(), (InternalTenantContext)context) : null;
    }

    private void createCatalogOverridePlanPhaseFromTransaction(short phaseNum, CatalogOverridePhaseDefinitionModelDao phaseDef, CatalogOverridePlanDefinitionModelDao planDef, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePlanPhaseSqlDao sqlDao = (CatalogOverridePlanPhaseSqlDao)inTransactionHandle.attach(CatalogOverridePlanPhaseSqlDao.class);
        CatalogOverridePlanPhaseModelDao modelDao = new CatalogOverridePlanPhaseModelDao(phaseNum, phaseDef.getRecordId(), planDef.getRecordId());
        sqlDao.create(modelDao, context);
    }

    private CatalogOverridePhaseDefinitionModelDao getOrCreateOverridePhaseDefinitionFromTransaction(String parentPhaseName, DateTime catalogEffectiveDate, PlanPhasePriceOverride override, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)inTransactionHandle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
        CatalogOverridePhaseDefinitionModelDao result = sqlDao.getByAttributes(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), (InternalTenantContext)context);
        if (result == null) {
            CatalogOverridePhaseDefinitionModelDao phaseDef = new CatalogOverridePhaseDefinitionModelDao(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), catalogEffectiveDate);
            sqlDao.create(phaseDef, context);
            Long recordId = sqlDao.getLastInsertId();
            result = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
        }
        return result;
    }
}

