/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.regex.Matcher;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.caching.OverriddenPlanCache;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.override.DefaultPriceOverride;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.OverriddenPlanCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheOverriddenPlanCache
implements OverriddenPlanCache {
    private final CacheController cacheController;
    private final OverriddenPlanCacheLoader.LoaderCallback loaderCallback;
    private final CatalogOverrideDao overrideDao;

    @Inject
    public EhCacheOverriddenPlanCache(CatalogOverrideDao overrideDao, CacheControllerDispatcher cacheControllerDispatcher) {
        this.overrideDao = overrideDao;
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OVERRIDDEN_PLAN);
        this.loaderCallback = new OverriddenPlanCacheLoader.LoaderCallback(){

            public Object loadPlan(String planName, StaticCatalog catalog, InternalTenantContext context) throws CatalogApiException {
                return EhCacheOverriddenPlanCache.this.loadOverriddenPlan(planName, catalog, context);
            }
        };
    }

    @Override
    public DefaultPlan getOverriddenPlan(String planName, StaticCatalog catalog, InternalTenantContext context) {
        ObjectType irrelevant = null;
        Object[] args = new Object[]{this.loaderCallback, catalog};
        CacheLoaderArgument argument = new CacheLoaderArgument(irrelevant, args, context);
        return (DefaultPlan)((Object)this.cacheController.get((Object)planName, argument));
    }

    @Override
    public void addDryRunPlan(String planName, Plan plan) {
        this.cacheController.putIfAbsent((Object)planName, (Object)plan);
    }

    private DefaultPlan loadOverriddenPlan(String planName, StaticCatalog catalog, InternalTenantContext context) throws CatalogApiException {
        Matcher m = DefaultPriceOverride.CUSTOM_PLAN_NAME_PATTERN.matcher(planName);
        if (!m.matches()) {
            throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PLAN, new Object[]{planName});
        }
        String parentPlanName = m.group(1);
        Long planDefRecordId = Long.parseLong(m.group(2));
        List<CatalogOverridePhaseDefinitionModelDao> phaseDefs = this.overrideDao.getOverriddenPlanPhases(planDefRecordId, context);
        DefaultPlan defaultPlan = (DefaultPlan)catalog.findCurrentPlan(parentPlanName);
        PlanPhasePriceOverride[] overrides = this.createOverrides(defaultPlan, phaseDefs);
        return new DefaultPlan(planName, defaultPlan, overrides);
    }

    private PlanPhasePriceOverride[] createOverrides(Plan defaultPlan, List<CatalogOverridePhaseDefinitionModelDao> phaseDefs) {
        PlanPhasePriceOverride[] result = new PlanPhasePriceOverride[defaultPlan.getAllPhases().length];
        for (int i = 0; i < defaultPlan.getAllPhases().length; ++i) {
            final PlanPhase curPhase = defaultPlan.getAllPhases()[i];
            CatalogOverridePhaseDefinitionModelDao overriddenPhase = (CatalogOverridePhaseDefinitionModelDao)Iterables.tryFind(phaseDefs, (Predicate)new Predicate<CatalogOverridePhaseDefinitionModelDao>(){

                public boolean apply(CatalogOverridePhaseDefinitionModelDao input) {
                    return input.getParentPhaseName().equals(curPhase.getName());
                }
            }).orNull();
            result[i] = overriddenPhase != null ? new DefaultPlanPhasePriceOverride(curPhase.getName(), Currency.valueOf((String)overriddenPhase.getCurrency()), overriddenPhase.getFixedPrice(), overriddenPhase.getRecurringPrice()) : null;
        }
        return result;
    }
}

