/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.VersionedCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.catalog.io.VersionedCatalogLoader;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.catalog.plugin.VersionedCatalogMapper;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.catalog.plugin.api.VersionedPluginCatalog;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.TenantCatalogCacheLoader;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhCacheCatalogCache
implements CatalogCache {
    private final Logger logger = LoggerFactory.getLogger(EhCacheCatalogCache.class);
    private final CacheController cacheController;
    private final VersionedCatalogLoader loader;
    private final CacheLoaderArgument cacheLoaderArgumentWithTemplateFiltering;
    private final CacheLoaderArgument cacheLoaderArgument;
    private final OSGIServiceRegistration<CatalogPluginApi> pluginRegistry;
    private final VersionedCatalogMapper versionedCatalogMapper;
    private final PriceOverride priceOverride;
    private final InternalCallContextFactory internalCallContextFactory;
    private VersionedCatalog defaultCatalog;

    @Inject
    public EhCacheCatalogCache(OSGIServiceRegistration<CatalogPluginApi> pluginRegistry, VersionedCatalogMapper versionedCatalogMapper, CacheControllerDispatcher cacheControllerDispatcher, VersionedCatalogLoader loader, PriceOverride priceOverride, InternalCallContextFactory internalCallContextFactory) {
        this.pluginRegistry = pluginRegistry;
        this.versionedCatalogMapper = versionedCatalogMapper;
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_CATALOG);
        this.loader = loader;
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
        this.cacheLoaderArgumentWithTemplateFiltering = this.initializeCacheLoaderArgument(true);
        this.cacheLoaderArgument = this.initializeCacheLoaderArgument(false);
        this.setDefaultCatalog();
    }

    @Override
    public void loadDefaultCatalog(String url) throws CatalogApiException {
        if (url != null) {
            this.defaultCatalog = this.loader.loadDefaultCatalog(url);
        }
    }

    @Override
    public VersionedCatalog getCatalog(boolean useDefaultCatalog, boolean filterTemplateCatalog, InternalTenantContext tenantContext) throws CatalogApiException {
        VersionedCatalog pluginVersionedCatalog = this.getCatalogFromPlugins(tenantContext);
        if (pluginVersionedCatalog != null) {
            return pluginVersionedCatalog;
        }
        if (tenantContext.getTenantRecordId() == 0L) {
            return useDefaultCatalog ? this.defaultCatalog : null;
        }
        try {
            VersionedCatalog tenantCatalog = (VersionedCatalog)((Object)this.cacheController.get((Object)tenantContext.getTenantRecordId(), filterTemplateCatalog ? this.cacheLoaderArgumentWithTemplateFiltering : this.cacheLoaderArgument));
            if (useDefaultCatalog && tenantCatalog == null) {
                tenantCatalog = new VersionedCatalog(this.defaultCatalog.getClock());
                for (StandaloneCatalog cur : this.defaultCatalog.getVersions()) {
                    StandaloneCatalogWithPriceOverride curWithOverride = new StandaloneCatalogWithPriceOverride(cur, this.priceOverride, tenantContext.getTenantRecordId(), this.internalCallContextFactory);
                    tenantCatalog.add(curWithOverride);
                }
                this.cacheController.add((Object)tenantContext.getTenantRecordId(), (Object)tenantCatalog);
            }
            return tenantCatalog;
        }
        catch (IllegalStateException e) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantContext.getTenantRecordId()});
        }
    }

    @Override
    public void clearCatalog(InternalTenantContext tenantContext) {
        if (tenantContext.getTenantRecordId() != 0L) {
            this.cacheController.remove((Object)tenantContext.getTenantRecordId());
        }
    }

    private VersionedCatalog getCatalogFromPlugins(InternalTenantContext internalTenantContext) throws CatalogApiException {
        TenantContext tenantContext = this.internalCallContextFactory.createTenantContext(internalTenantContext);
        for (String service : this.pluginRegistry.getAllServices()) {
            CatalogPluginApi plugin = (CatalogPluginApi)this.pluginRegistry.getServiceForName(service);
            VersionedPluginCatalog pluginCatalog = plugin.getVersionedPluginCatalog((Iterable)ImmutableList.of(), tenantContext);
            if (pluginCatalog == null) continue;
            this.logger.info("Returning catalog from plugin {} on tenant {} ", (Object)service, (Object)internalTenantContext.getTenantRecordId());
            return this.versionedCatalogMapper.toVersionedCatalog(pluginCatalog, internalTenantContext);
        }
        return null;
    }

    private CacheLoaderArgument initializeCacheLoaderArgument(final boolean filterTemplateCatalog) {
        TenantCatalogCacheLoader.LoaderCallback loaderCallback = new TenantCatalogCacheLoader.LoaderCallback(){

            public Object loadCatalog(List<String> catalogXMLs, Long tenantRecordId) throws CatalogApiException {
                return EhCacheCatalogCache.this.loader.load(catalogXMLs, filterTemplateCatalog, tenantRecordId);
            }
        };
        Object[] args = new Object[]{loaderCallback};
        ObjectType irrelevant = null;
        InternalTenantContext notUsed = null;
        return new CacheLoaderArgument(irrelevant, args, notUsed);
    }

    @VisibleForTesting
    void setDefaultCatalog() {
        try {
            this.defaultCatalog = this.loader.loadDefaultCatalog("EmptyCatalog.xml");
        }
        catch (CatalogApiException e) {
            this.defaultCatalog = new VersionedCatalog();
            this.logger.error("Exception loading EmptyCatalog - should never happen!", (Throwable)e);
        }
    }
}

