/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.user;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogUpdater;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.VersionedCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.SimplePlanDescriptor;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.xmlloader.XMLLoader;

public class DefaultCatalogUserApi
implements CatalogUserApi {
    private final CatalogService catalogService;
    private final InternalCallContextFactory internalCallContextFactory;
    private final TenantUserApi tenantApi;
    private final CatalogCache catalogCache;

    @Inject
    public DefaultCatalogUserApi(CatalogService catalogService, TenantUserApi tenantApi, CatalogCache catalogCache, InternalCallContextFactory internalCallContextFactory) {
        this.catalogService = catalogService;
        this.tenantApi = tenantApi;
        this.catalogCache = catalogCache;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public Catalog getCatalog(String catalogName, TenantContext tenantContext) throws CatalogApiException {
        InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(tenantContext);
        return this.catalogService.getFullCatalog(true, true, internalTenantContext);
    }

    public StaticCatalog getCurrentCatalog(String catalogName, TenantContext tenantContext) throws CatalogApiException {
        InternalTenantContext internalTenantContext = this.createInternalTenantContext(tenantContext);
        return this.catalogService.getCurrentCatalog(true, true, internalTenantContext);
    }

    public void uploadCatalog(String catalogXML, CallContext callContext) throws CatalogApiException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(catalogXML.getBytes());
            XMLLoader.getObjectFromStream((URI)new URI("dummy"), (InputStream)stream, StandaloneCatalog.class);
            InternalTenantContext internalTenantContext = this.createInternalTenantContext((TenantContext)callContext);
            this.catalogCache.clearCatalog(internalTenantContext);
            this.tenantApi.addTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogXML, callContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void createDefaultEmptyCatalog(DateTime effectiveDate, CallContext callContext) throws CatalogApiException {
        try {
            InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId((TenantContext)callContext);
            StandaloneCatalog currentCatalog = this.getCurrentStandaloneCatalogForTenant(internalTenantContext);
            CatalogUpdater catalogUpdater = currentCatalog != null ? new CatalogUpdater(currentCatalog) : new CatalogUpdater("dummy", BillingMode.IN_ADVANCE, effectiveDate, null);
            this.catalogCache.clearCatalog(internalTenantContext);
            this.tenantApi.updateTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogUpdater.getCatalogXML(), callContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
    }

    public void addSimplePlan(SimplePlanDescriptor descriptor, DateTime effectiveDate, CallContext callContext) throws CatalogApiException {
        try {
            InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId((TenantContext)callContext);
            StandaloneCatalog currentCatalog = this.getCurrentStandaloneCatalogForTenant(internalTenantContext);
            CatalogUpdater catalogUpdater = currentCatalog != null ? new CatalogUpdater(currentCatalog) : new CatalogUpdater("dummy", BillingMode.IN_ADVANCE, effectiveDate, descriptor.getCurrency());
            catalogUpdater.addSimplePlanDescriptor(descriptor);
            this.catalogCache.clearCatalog(internalTenantContext);
            this.tenantApi.updateTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogUpdater.getCatalogXML(), callContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
    }

    private StandaloneCatalog getCurrentStandaloneCatalogForTenant(InternalTenantContext internalTenantContext) throws CatalogApiException {
        VersionedCatalog versionedCatalog = (VersionedCatalog)this.catalogService.getCurrentCatalog(false, false, internalTenantContext);
        if (versionedCatalog != null && !versionedCatalog.getVersions().isEmpty()) {
            StandaloneCatalog standaloneCatalogWithPriceOverride = versionedCatalog.getVersions().get(versionedCatalog.getVersions().size() - 1);
            return standaloneCatalogWithPriceOverride;
        }
        return null;
    }

    private InternalTenantContext createInternalTenantContext(TenantContext tenantContext) {
        return this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(tenantContext);
    }
}

