/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogDateHelper;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.Catalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.clock.Clock;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="catalogs")
@XmlAccessorType(value=XmlAccessType.NONE)
public class VersionedCatalog
extends ValidatingConfig<VersionedCatalog>
implements Catalog,
StaticCatalog {
    private final Clock clock;
    @XmlElementWrapper(name="versions", required=true)
    @XmlElement(name="version", required=true)
    private final List<StandaloneCatalog> versions;
    private String catalogName;
    private BillingMode recurringBillingMode;

    public VersionedCatalog() {
        this.clock = null;
        this.versions = new ArrayList<StandaloneCatalog>();
    }

    public VersionedCatalog(Clock clock) {
        this.clock = clock;
        this.versions = new ArrayList<StandaloneCatalog>();
    }

    private StandaloneCatalog versionForDate(DateTime date) throws CatalogApiException {
        return this.versions.get(this.indexOfVersionForDate(date.toDate()));
    }

    private List<StandaloneCatalog> versionsBeforeDate(Date date) throws CatalogApiException {
        ArrayList<StandaloneCatalog> result = new ArrayList<StandaloneCatalog>();
        int index = this.indexOfVersionForDate(date);
        for (int i = 0; i <= index; ++i) {
            result.add(this.versions.get(i));
        }
        return result;
    }

    private int indexOfVersionForDate(Date date) throws CatalogApiException {
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            StandaloneCatalog c = this.versions.get(i);
            if (c.getEffectiveDate().getTime() > date.getTime()) continue;
            return i;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_CATALOG_FOR_GIVEN_DATE, new Object[]{date.toString()});
    }

    private CatalogPlanEntry findCatalogPlanEntry(PlanRequestWrapper wrapper, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        List<StandaloneCatalog> catalogs = this.versionsBeforeDate(requestedDate.toDate());
        if (catalogs.isEmpty()) {
            throw new CatalogApiException(ErrorCode.CAT_NO_CATALOG_FOR_GIVEN_DATE, new Object[]{requestedDate.toDate().toString()});
        }
        for (int i = catalogs.size() - 1; i >= 0; --i) {
            DateTime existingSubscriptionDate;
            Plan plan;
            StandaloneCatalog c = catalogs.get(i);
            try {
                plan = wrapper.findPlan(c);
            }
            catch (CatalogApiException e) {
                if (e.getCode() == ErrorCode.CAT_NO_SUCH_PLAN.getCode()) continue;
                throw e;
            }
            DateTime catalogEffectiveDate = CatalogDateHelper.toUTCDateTime(c.getEffectiveDate());
            if (!subscriptionStartDate.isBefore((ReadableInstant)catalogEffectiveDate)) {
                return new CatalogPlanEntry(c, plan);
            }
            if (plan.getEffectiveDateForExistingSubscriptions() == null || !requestedDate.isAfter((ReadableInstant)(existingSubscriptionDate = CatalogDateHelper.toUTCDateTime(plan.getEffectiveDateForExistingSubscriptions())))) continue;
            return new CatalogPlanEntry(c, plan);
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_CATALOG_FOR_GIVEN_DATE, new Object[]{requestedDate.toDate().toString()});
    }

    public Clock getClock() {
        return this.clock;
    }

    public List<StandaloneCatalog> getVersions() {
        return this.versions;
    }

    public void addAll(List<StandaloneCatalog> inputVersions) throws CatalogApiException {
        for (StandaloneCatalog cur : inputVersions) {
            this.add(cur);
        }
    }

    public void add(StandaloneCatalog e) throws CatalogApiException {
        if (this.catalogName == null) {
            this.catalogName = e.getCatalogName();
        } else if (!this.catalogName.equals(e.getCatalogName())) {
            throw new CatalogApiException(ErrorCode.CAT_CATALOG_NAME_MISMATCH, new Object[]{this.catalogName, e.getCatalogName()});
        }
        if (this.recurringBillingMode == null) {
            this.recurringBillingMode = e.getRecurringBillingMode();
        } else if (!this.recurringBillingMode.equals((Object)e.getRecurringBillingMode())) {
            throw new CatalogApiException(ErrorCode.CAT_CATALOG_RECURRING_MODE_MISMATCH, new Object[]{this.recurringBillingMode, e.getRecurringBillingMode()});
        }
        this.versions.add(e);
        Collections.sort(this.versions, new Comparator<StandaloneCatalog>(){

            @Override
            public int compare(StandaloneCatalog c1, StandaloneCatalog c2) {
                return c1.getEffectiveDate().compareTo(c2.getEffectiveDate());
            }
        });
    }

    public Iterator<StandaloneCatalog> iterator() {
        return this.versions.iterator();
    }

    public int size() {
        return this.versions.size();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Collection<Product> getProducts(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentProducts();
    }

    public Currency[] getSupportedCurrencies(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentSupportedCurrencies();
    }

    public Collection<Plan> getPlans(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getCurrentPlans();
    }

    public PriceListSet getPriceLists(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getPriceLists();
    }

    public Plan findPlan(String name, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).findCurrentPlan(name);
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).createOrFindCurrentPlan(spec, overrides);
    }

    public Plan findPlan(String name, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(name), requestedDate, subscriptionStartDate);
        return entry.getPlan();
    }

    public Plan createOrFindPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(spec, overrides), requestedDate, subscriptionStartDate);
        return entry.getPlan();
    }

    public Product findProduct(String name, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).findCurrentProduct(name);
    }

    public PlanPhase findPhase(String phaseName, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        String planName = DefaultPlanPhase.planName(phaseName);
        Plan plan = this.findPlan(planName, requestedDate, subscriptionStartDate);
        return plan.findPhase(phaseName);
    }

    public PriceList findPriceListForPlan(String planName, DateTime requestedDate, DateTime subscriptionStartDate) throws CatalogApiException {
        CatalogPlanEntry entry = this.findCatalogPlanEntry(new PlanRequestWrapper(planName), requestedDate, subscriptionStartDate);
        return entry.getStaticCatalog().findCurrentPricelist(entry.getPlan().getPriceListName());
    }

    public PriceList findPriceList(String name, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).findCurrentPriceList(name);
    }

    public BillingActionPolicy planChangePolicy(PlanPhaseSpecifier from, PlanSpecifier to, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).planChangePolicy(from, to);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).planCancelPolicy(planPhase);
    }

    public PlanAlignmentChange planChangeAlignment(PlanPhaseSpecifier from, PlanSpecifier to, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).planChangeAlignment(from, to);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).planCreateAlignment(specifier);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).billingAlignment(planPhase);
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).planChange(from, to);
    }

    public boolean canCreatePlan(PlanSpecifier specifier, DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).canCreatePlan(specifier);
    }

    public void initialize(VersionedCatalog catalog, URI sourceURI) {
        for (StandaloneCatalog c : this.versions) {
            c.initialize(c, sourceURI);
        }
    }

    public ValidationErrors validate(VersionedCatalog catalog, ValidationErrors errors) {
        for (StandaloneCatalog c : this.versions) {
            errors.addAll((Collection)c.validate(c, errors));
        }
        return errors;
    }

    public Date getEffectiveDate() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getEffectiveDate();
    }

    public Date getStandaloneCatalogEffectiveDate(DateTime requestedDate) throws CatalogApiException {
        return this.versionForDate(requestedDate).getEffectiveDate();
    }

    public BillingMode getRecurringBillingMode() {
        return this.recurringBillingMode;
    }

    public Currency[] getCurrentSupportedCurrencies() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentSupportedCurrencies();
    }

    public Collection<Product> getCurrentProducts() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentProducts();
    }

    public Unit[] getCurrentUnits() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentUnits();
    }

    public Collection<Plan> getCurrentPlans() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getCurrentPlans();
    }

    public Plan createOrFindCurrentPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).createOrFindCurrentPlan(spec, overrides);
    }

    public Plan findCurrentPlan(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPlan(name);
    }

    public Product findCurrentProduct(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentProduct(name);
    }

    public PlanPhase findCurrentPhase(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPhase(name);
    }

    public PriceList findCurrentPricelist(String name) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).findCurrentPriceList(name);
    }

    public BillingActionPolicy planChangePolicy(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planChangePolicy(from, to);
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planChange(from, to);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planCancelPolicy(planPhase);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planCreateAlignment(specifier);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).billingAlignment(planPhase);
    }

    public PlanAlignmentChange planChangeAlignment(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).planChangeAlignment(from, to);
    }

    public boolean canCreatePlan(PlanSpecifier specifier) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).canCreatePlan(specifier);
    }

    public List<Listing> getAvailableAddOnListings(String baseProductName, @Nullable String priceListName) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getAvailableAddOnListings(baseProductName, priceListName);
    }

    public List<Listing> getAvailableBasePlanListings() throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).getAvailableBasePlanListings();
    }

    public boolean compliesWithLimits(String phaseName, String unit, double value) throws CatalogApiException {
        return this.versionForDate(this.clock.getUTCNow()).compliesWithLimits(phaseName, unit, value);
    }

    private static class CatalogPlanEntry {
        private final StaticCatalog staticCatalog;
        private final Plan plan;

        public CatalogPlanEntry(StaticCatalog staticCatalog, Plan plan) {
            this.staticCatalog = staticCatalog;
            this.plan = plan;
        }

        public StaticCatalog getStaticCatalog() {
            return this.staticCatalog;
        }

        public Plan getPlan() {
            return this.plan;
        }
    }

    private class PlanRequestWrapper {
        private final PlanSpecifier spec;
        private final PlanPhasePriceOverridesWithCallContext overrides;

        public PlanRequestWrapper(String planName) {
            this.spec = new PlanSpecifier(planName);
            this.overrides = null;
        }

        public PlanRequestWrapper(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext overrides) {
            this.spec = spec;
            this.overrides = overrides;
        }

        public Plan findPlan(StandaloneCatalog catalog) throws CatalogApiException {
            return catalog.createOrFindCurrentPlan(this.spec, this.overrides);
        }
    }
}

