/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.DefaultListing;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Listing;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultPlanRules;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="catalog")
@XmlAccessorType(value=XmlAccessType.NONE)
public class StandaloneCatalog
extends ValidatingConfig<StandaloneCatalog>
implements StaticCatalog {
    @XmlElement(required=true)
    private Date effectiveDate;
    @XmlElement(required=true)
    private String catalogName;
    @XmlElement(required=true)
    private BillingMode recurringBillingMode;
    @XmlElementWrapper(name="currencies", required=false)
    @XmlElement(name="currency", required=false)
    private Currency[] supportedCurrencies;
    @XmlElementWrapper(name="units", required=false)
    @XmlElement(name="unit", required=false)
    private DefaultUnit[] units;
    @XmlElementWrapper(name="products", required=false)
    @XmlElement(type=DefaultProduct.class, name="product", required=false)
    private CatalogEntityCollection<Product> products;
    @XmlElement(name="rules", required=true)
    private DefaultPlanRules planRules;
    @XmlElementWrapper(name="plans", required=false)
    @XmlElement(type=DefaultPlan.class, name="plan", required=false)
    private CatalogEntityCollection<Plan> plans;
    @XmlElement(name="priceLists", required=true)
    private DefaultPriceListSet priceLists;
    private URI catalogURI;

    public StandaloneCatalog() {
        this.plans = new CatalogEntityCollection();
        this.products = new CatalogEntityCollection();
    }

    protected StandaloneCatalog(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public BillingMode getRecurringBillingMode() {
        return this.recurringBillingMode;
    }

    public Collection<Product> getCurrentProducts() {
        return this.products.getEntries();
    }

    public CatalogEntityCollection<Product> getCatalogEntityCollectionProduct() {
        return this.products;
    }

    public DefaultUnit[] getCurrentUnits() {
        return this.units;
    }

    public Currency[] getCurrentSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    public Collection<Plan> getCurrentPlans() {
        return this.plans.getEntries();
    }

    public CatalogEntityCollection<Plan> getCatalogEntityCollectionPlan() {
        return this.plans;
    }

    public boolean isTemplateCatalog() {
        return !(this.products != null && this.products.size() != 0 || this.plans != null && this.plans.size() != 0 || this.supportedCurrencies != null && this.supportedCurrencies.length != 0);
    }

    public URI getCatalogURI() {
        return this.catalogURI;
    }

    public DefaultPlanRules getPlanRules() {
        return this.planRules;
    }

    public DefaultPriceList findCurrentPriceList(String priceListName) throws CatalogApiException {
        return this.priceLists.findPriceListFrom(priceListName);
    }

    public DefaultPriceListSet getPriceLists() {
        return this.priceLists;
    }

    public Plan createOrFindCurrentPlan(PlanSpecifier spec, PlanPhasePriceOverridesWithCallContext unused) throws CatalogApiException {
        DefaultPlan result;
        if (spec.getPlanName() != null) {
            result = this.findCurrentPlan(spec.getPlanName());
        } else {
            if (spec.getProductName() == null) {
                throw new CatalogApiException(ErrorCode.CAT_NULL_PRODUCT_NAME, new Object[0]);
            }
            if (spec.getBillingPeriod() == null) {
                throw new CatalogApiException(ErrorCode.CAT_NULL_BILLING_PERIOD, new Object[0]);
            }
            String inputOrDefaultPricelist = spec.getPriceListName() == null ? "DEFAULT" : spec.getPriceListName();
            Product product = this.findCurrentProduct(spec.getProductName());
            result = this.priceLists.getPlanFrom(product, spec.getBillingPeriod(), inputOrDefaultPricelist);
        }
        if (result == null) {
            throw new CatalogApiException(ErrorCode.CAT_PLAN_NOT_FOUND, new Object[]{spec.getPlanName() != null ? spec.getPlanName() : "undefined", spec.getProductName() != null ? spec.getProductName() : "undefined", spec.getBillingPeriod() != null ? spec.getBillingPeriod() : "undefined", spec.getPriceListName() != null ? spec.getPriceListName() : "undefined"});
        }
        return result;
    }

    public DefaultPlan findCurrentPlan(String name) throws CatalogApiException {
        if (name == null || this.plans == null) {
            throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PLAN, new Object[]{name});
        }
        DefaultPlan result = (DefaultPlan)this.plans.findByName(name);
        if (result != null) {
            return result;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PLAN, new Object[]{name});
    }

    public Product findCurrentProduct(String name) throws CatalogApiException {
        if (name == null || this.products == null) {
            throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PRODUCT, new Object[]{name});
        }
        Product result = this.products.findByName(name);
        if (result != null) {
            return result;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PRODUCT, new Object[]{name});
    }

    public PlanPhase findCurrentPhase(String name) throws CatalogApiException {
        if (name == null || this.plans == null) {
            throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PHASE, new Object[]{name});
        }
        String planName = DefaultPlanPhase.planName(name);
        DefaultPlan plan = this.findCurrentPlan(planName);
        return plan.findPhase(name);
    }

    public PriceList findCurrentPricelist(String name) throws CatalogApiException {
        if (name == null || this.priceLists == null) {
            throw new CatalogApiException(ErrorCode.CAT_PRICE_LIST_NOT_FOUND, new Object[]{name});
        }
        return this.priceLists.findPriceListFrom(name);
    }

    public BillingActionPolicy planChangePolicy(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.planRules.getPlanChangePolicy(from, to, this);
    }

    public PlanAlignmentChange planChangeAlignment(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.planRules.getPlanChangeAlignment(from, to, this);
    }

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.planRules.getPlanCancelPolicy(planPhase, this);
    }

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier specifier) throws CatalogApiException {
        return this.planRules.getPlanCreateAlignment(specifier, this);
    }

    public BillingAlignment billingAlignment(PlanPhaseSpecifier planPhase) throws CatalogApiException {
        return this.planRules.getBillingAlignment(planPhase, this);
    }

    public PlanChangeResult planChange(PlanPhaseSpecifier from, PlanSpecifier to) throws CatalogApiException {
        return this.planRules.planChange(from, to, this);
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        this.validateCollection((Object)catalog, errors, (DefaultProduct[])this.products.toArray((Object[])new DefaultProduct[this.products.size()]));
        this.validateCollection((Object)catalog, errors, (DefaultPlan[])this.plans.toArray((Object[])new DefaultPlan[this.plans.size()]));
        this.priceLists.validate(catalog, errors);
        this.planRules.validate(catalog, errors);
        return errors;
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        this.catalogURI = sourceURI;
        super.initialize((Object)catalog, sourceURI);
        this.planRules.initialize((Object)catalog, sourceURI);
        this.priceLists.initialize((Object)catalog, sourceURI);
        for (Product product : this.products.getEntries()) {
            ((DefaultProduct)product).initialize(catalog, sourceURI);
        }
        for (Plan plan : this.plans.getEntries()) {
            ((DefaultPlan)plan).initialize(catalog, sourceURI);
        }
    }

    public boolean compliesWithLimits(String phaseName, String unit, double value) throws CatalogApiException {
        PlanPhase phase = this.findCurrentPhase(phaseName);
        return phase.compliesWithLimits(unit, value);
    }

    public StandaloneCatalog setProducts(Iterable<Product> products) {
        this.products = new CatalogEntityCollection<Product>(products);
        return this;
    }

    public StandaloneCatalog setSupportedCurrencies(Currency[] supportedCurrencies) {
        this.supportedCurrencies = supportedCurrencies;
        return this;
    }

    public StandaloneCatalog setPlans(Iterable<Plan> plans) {
        this.plans = new CatalogEntityCollection<Plan>(plans);
        return this;
    }

    public StandaloneCatalog setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    public StandaloneCatalog setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
        return this;
    }

    public StandaloneCatalog setRecurringBillingMode(BillingMode recurringBillingMode) {
        this.recurringBillingMode = recurringBillingMode;
        return this;
    }

    public StandaloneCatalog setPlanRules(DefaultPlanRules planRules) {
        this.planRules = planRules;
        return this;
    }

    public StandaloneCatalog setPriceLists(DefaultPriceListSet priceLists) {
        this.priceLists = priceLists;
        return this;
    }

    public StandaloneCatalog setUnits(DefaultUnit[] units) {
        this.units = units;
        return this;
    }

    public boolean canCreatePlan(PlanSpecifier specifier) throws CatalogApiException {
        Product product = this.findCurrentProduct(specifier.getProductName());
        Plan plan = this.createOrFindCurrentPlan(specifier, null);
        DefaultPriceList priceList = this.findCurrentPriceList(specifier.getPriceListName());
        return product != null && plan != null && priceList != null;
    }

    public List<Listing> getAvailableAddOnListings(String baseProductName, @Nullable String priceListName) {
        ArrayList<Listing> availAddons = new ArrayList<Listing>();
        try {
            Product product = this.findCurrentProduct(baseProductName);
            if (product != null) {
                for (Product availAddon : product.getAvailable()) {
                    for (BillingPeriod billingPeriod : BillingPeriod.values()) {
                        for (PriceList priceList : this.getPriceLists().getAllPriceLists()) {
                            if (priceListName != null && !priceListName.equals(priceList.getName())) continue;
                            Collection addonInList = priceList.findPlans(availAddon, billingPeriod);
                            for (Plan cur : addonInList) {
                                availAddons.add(new DefaultListing(cur, priceList));
                            }
                        }
                    }
                }
            }
        }
        catch (CatalogApiException e) {
            // empty catch block
        }
        return availAddons;
    }

    public List<Listing> getAvailableBasePlanListings() {
        ArrayList<Listing> availBasePlans = new ArrayList<Listing>();
        for (Plan plan : this.getCurrentPlans()) {
            if (!plan.getProduct().getCategory().equals((Object)ProductCategory.BASE)) continue;
            for (PriceList priceList : this.getPriceLists().getAllPriceLists()) {
                for (Plan priceListPlan : priceList.getPlans()) {
                    if (!priceListPlan.getName().equals(plan.getName()) || !priceListPlan.getProduct().getName().equals(plan.getProduct().getName())) continue;
                    availBasePlans.add(new DefaultListing(priceListPlan, priceList));
                }
            }
        }
        return availBasePlans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandaloneCatalog)) {
            return false;
        }
        StandaloneCatalog that = (StandaloneCatalog)((Object)o);
        if (this.catalogName != null ? !this.catalogName.equals(that.catalogName) : that.catalogName != null) {
            return false;
        }
        if (this.catalogURI != null ? !this.catalogURI.equals(that.catalogURI) : that.catalogURI != null) {
            return false;
        }
        if (this.effectiveDate != null ? !this.effectiveDate.equals(that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (this.planRules != null ? !this.planRules.equals((Object)that.planRules) : that.planRules != null) {
            return false;
        }
        if (!this.plans.equals(that.plans)) {
            return false;
        }
        if (this.priceLists != null ? !this.priceLists.equals((Object)that.priceLists) : that.priceLists != null) {
            return false;
        }
        if (!this.products.equals(that.products)) {
            return false;
        }
        if (this.recurringBillingMode != that.recurringBillingMode) {
            return false;
        }
        if (!Arrays.equals(this.supportedCurrencies, that.supportedCurrencies)) {
            return false;
        }
        return Arrays.equals((Object[])this.units, (Object[])that.units);
    }

    public int hashCode() {
        int result = this.effectiveDate != null ? this.effectiveDate.hashCode() : 0;
        result = 31 * result + (this.catalogName != null ? this.catalogName.hashCode() : 0);
        result = 31 * result + (this.recurringBillingMode != null ? this.recurringBillingMode.hashCode() : 0);
        result = 31 * result + (this.supportedCurrencies != null ? Arrays.hashCode(this.supportedCurrencies) : 0);
        result = 31 * result + (this.units != null ? Arrays.hashCode((Object[])this.units) : 0);
        result = 31 * result + (this.products != null ? this.products.hashCode() : 0);
        result = 31 * result + (this.planRules != null ? this.planRules.hashCode() : 0);
        result = 31 * result + (this.plans != null ? this.plans.hashCode() : 0);
        result = 31 * result + (this.priceLists != null ? this.priceLists.hashCode() : 0);
        result = 31 * result + (this.catalogURI != null ? this.catalogURI.hashCode() : 0);
        return result;
    }
}

