/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultRecurring
extends ValidatingConfig<StandaloneCatalog>
implements Recurring {
    @XmlElement(required=true)
    private BillingPeriod billingPeriod;
    @XmlElement(required=false)
    private DefaultInternationalPrice recurringPrice;
    private Plan plan;
    private PlanPhase phase;

    public DefaultRecurring() {
    }

    public DefaultRecurring(DefaultRecurring in, PlanPhasePriceOverride override) {
        this.billingPeriod = in.getBillingPeriod();
        this.recurringPrice = in.getRecurringPrice() != null ? new DefaultInternationalPrice(in.getRecurringPrice(), override, false) : null;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public DefaultInternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public void initialize(StandaloneCatalog root, URI uri) {
        if (this.recurringPrice != null) {
            this.recurringPrice.initialize(root, uri);
        }
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.billingPeriod == null) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has a recurring price but no billing period", this.phase.getPhaseType().toString(), this.plan.getName()), catalog.getCatalogURI(), DefaultPlanPhase.class, this.phase.getPhaseType().toString()));
        }
        if (this.recurringPrice != null && (this.billingPeriod == null || this.billingPeriod == BillingPeriod.NO_BILLING_PERIOD)) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has a recurring price but no billing period", this.phase.getPhaseType().toString(), this.plan.getName()), catalog.getCatalogURI(), DefaultPlanPhase.class, this.phase.getPhaseType().toString()));
        }
        if (this.recurringPrice == null && this.billingPeriod != BillingPeriod.NO_BILLING_PERIOD) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has no recurring price but does have a billing period. The billing period should be set to '%s'", this.phase.getPhaseType().toString(), this.plan.getName(), BillingPeriod.NO_BILLING_PERIOD), catalog.getCatalogURI(), DefaultPlanPhase.class, this.phase.getPhaseType().toString()));
        }
        return errors;
    }

    public DefaultRecurring setBillingPeriod(BillingPeriod billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    public DefaultRecurring setRecurringPrice(DefaultInternationalPrice recurringPrice) {
        this.recurringPrice = recurringPrice;
        return this;
    }

    public DefaultRecurring setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public DefaultRecurring setPhase(PlanPhase phase) {
        this.phase = phase;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRecurring)) {
            return false;
        }
        DefaultRecurring that = (DefaultRecurring)((Object)o);
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        return !(this.recurringPrice != null ? !this.recurringPrice.equals((Object)that.recurringPrice) : that.recurringPrice != null);
    }

    public int hashCode() {
        int result = this.billingPeriod != null ? this.billingPeriod.hashCode() : 0;
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }
}

