/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultProduct
extends ValidatingConfig<StandaloneCatalog>
implements Product {
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlElement(required=true)
    private ProductCategory category;
    @XmlElementWrapper(name="included", required=false)
    @XmlIDREF
    @XmlElement(type=DefaultProduct.class, name="addonProduct", required=false)
    private CatalogEntityCollection<Product> included = new CatalogEntityCollection();
    @XmlElementWrapper(name="available", required=false)
    @XmlIDREF
    @XmlElement(type=DefaultProduct.class, name="addonProduct", required=false)
    private CatalogEntityCollection<Product> available = new CatalogEntityCollection();
    @XmlElementWrapper(name="limits", required=false)
    @XmlElement(name="limit", required=false)
    private DefaultLimit[] limits;
    private String catalogName;

    public String getCatalogName() {
        return this.catalogName;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public Collection<Product> getIncluded() {
        return this.included.getEntries();
    }

    public Collection<Product> getAvailable() {
        return this.available.getEntries();
    }

    public CatalogEntityCollection<Product> getCatalogEntityCollectionAvailable() {
        return this.available;
    }

    public DefaultProduct() {
        this.limits = new DefaultLimit[0];
    }

    public DefaultProduct(String name, ProductCategory category) {
        this.category = category;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncluded(DefaultProduct addon) {
        for (Product p : this.included.getEntries()) {
            if (addon != p) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(DefaultProduct addon) {
        for (Product p : this.included.getEntries()) {
            if (addon != p) continue;
            return true;
        }
        return false;
    }

    public DefaultLimit[] getLimits() {
        return this.limits;
    }

    protected Limit findLimit(String unit) {
        for (DefaultLimit limit : this.limits) {
            if (!limit.getUnit().getName().equals(unit)) continue;
            return limit;
        }
        return null;
    }

    public boolean compliesWithLimits(String unit, double value) {
        Limit l = this.findLimit(unit);
        if (l == null) {
            return true;
        }
        return l.compliesWith(value);
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        this.catalogName = catalog.getCatalogName();
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    public DefaultProduct setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultProduct setCatagory(ProductCategory category) {
        this.category = category;
        return this;
    }

    public DefaultProduct setCategory(ProductCategory category) {
        this.category = category;
        return this;
    }

    public DefaultProduct setIncluded(Collection<Product> included) {
        this.included = new CatalogEntityCollection<Product>(included);
        return this;
    }

    public DefaultProduct setAvailable(Collection<Product> available) {
        this.available = new CatalogEntityCollection<Product>(available);
        return this;
    }

    public DefaultProduct setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    public String toString() {
        return "DefaultProduct{name='" + this.name + '\'' + ", category=" + this.category + ", included=" + this.included + ", available=" + this.available + ", limits=" + Arrays.toString((Object[])this.limits) + ", catalogName='" + this.catalogName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProduct)) {
            return false;
        }
        DefaultProduct product = (DefaultProduct)((Object)o);
        if (this.name != null ? !this.name.equals(product.name) : product.name != null) {
            return false;
        }
        if (this.category != product.category) {
            return false;
        }
        if (this.included != null ? !this.included.equals(product.included) : product.included != null) {
            return false;
        }
        if (this.available != null ? !this.available.equals(product.available) : product.available != null) {
            return false;
        }
        if (!Arrays.equals((Object[])this.limits, (Object[])product.limits)) {
            return false;
        }
        return this.catalogName != null ? this.catalogName.equals(product.catalogName) : product.catalogName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.included != null ? this.included.hashCode() : 0);
        result = 31 * result + (this.available != null ? this.available.hashCode() : 0);
        result = 31 * result + Arrays.hashCode((Object[])this.limits);
        result = 31 * result + (this.catalogName != null ? this.catalogName.hashCode() : 0);
        return result;
    }
}

