/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPlanPhase
extends ValidatingConfig<StandaloneCatalog>
implements PlanPhase {
    @XmlAttribute(required=true)
    private PhaseType type;
    @XmlElement(required=true)
    private DefaultDuration duration;
    @XmlElement(required=false)
    private DefaultFixed fixed;
    @XmlElement(required=false)
    private DefaultRecurring recurring;
    @XmlElementWrapper(name="usages", required=false)
    @XmlElement(name="usage", required=false)
    private DefaultUsage[] usages;
    private Plan plan;

    public DefaultPlanPhase() {
        this.usages = new DefaultUsage[0];
    }

    public DefaultPlanPhase(DefaultPlan parentPlan, DefaultPlanPhase in, @Nullable PlanPhasePriceOverride override) {
        this.type = in.getPhaseType();
        this.duration = (DefaultDuration)in.getDuration();
        this.fixed = override != null && override.getFixedPrice() != null ? new DefaultFixed((DefaultFixed)in.getFixed(), override) : (DefaultFixed)in.getFixed();
        this.recurring = override != null && override.getRecurringPrice() != null ? new DefaultRecurring((DefaultRecurring)in.getRecurring(), override) : (DefaultRecurring)in.getRecurring();
        this.usages = new DefaultUsage[in.getUsages().length];
        for (int i = 0; i < in.getUsages().length; ++i) {
            this.usages[i] = (DefaultUsage)in.getUsages()[i];
        }
        this.plan = parentPlan;
    }

    public static String phaseName(String planName, PhaseType phasetype) {
        return planName + "-" + phasetype.toString().toLowerCase();
    }

    public static String planName(String phaseName) throws CatalogApiException {
        for (PhaseType type : PhaseType.values()) {
            if (!phaseName.endsWith(type.toString().toLowerCase())) continue;
            return phaseName.substring(0, phaseName.length() - type.toString().length() - 1);
        }
        throw new CatalogApiException(ErrorCode.CAT_BAD_PHASE_NAME, new Object[]{phaseName});
    }

    public PhaseType getPhaseType() {
        return this.type;
    }

    public boolean compliesWithLimits(String unit, double value) {
        for (DefaultUsage usage : this.usages) {
            if (usage.compliesWithLimits(unit, value)) continue;
            return false;
        }
        return this.plan.getProduct().compliesWithLimits(unit, value);
    }

    public Fixed getFixed() {
        return this.fixed;
    }

    public Recurring getRecurring() {
        return this.recurring;
    }

    public Usage[] getUsages() {
        return this.usages;
    }

    public String getName() {
        return DefaultPlanPhase.phaseName(this.plan.getName(), this.getPhaseType());
    }

    public Duration getDuration() {
        return this.duration;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.fixed == null && this.recurring == null && this.usages.length == 0) {
            errors.add((Object)new ValidationError(String.format("Phase %s of plan %s need to define at least either a fixed or recurrring or usage section.", this.type.toString(), this.plan.getName()), catalog.getCatalogURI(), DefaultPlanPhase.class, this.type.toString()));
        }
        if (this.fixed != null) {
            this.fixed.validate(catalog, errors);
        }
        if (this.recurring != null) {
            this.recurring.validate(catalog, errors);
        }
        this.validateCollection((Object)catalog, errors, this.usages);
        return errors;
    }

    public void initialize(StandaloneCatalog root, URI uri) {
        if (this.fixed != null) {
            this.fixed.initialize(root, uri);
        }
        if (this.recurring != null) {
            this.recurring.initialize(root, uri);
            this.recurring.setPlan(this.plan);
            this.recurring.setPhase(this);
        }
        if (this.usages != null) {
            for (DefaultUsage usage : this.usages) {
                usage.initialize(root, uri);
                usage.setPhase(this);
            }
        }
    }

    public DefaultPlanPhase setFixed(DefaultFixed fixed) {
        this.fixed = fixed;
        return this;
    }

    public DefaultPlanPhase setRecurring(DefaultRecurring recurring) {
        this.recurring = recurring;
        return this;
    }

    public DefaultPlanPhase setUsages(DefaultUsage[] usages) {
        this.usages = usages;
        return this;
    }

    public DefaultPlanPhase setPhaseType(PhaseType cohort) {
        this.type = cohort;
        return this;
    }

    public DefaultPlanPhase setDuration(DefaultDuration duration) {
        this.duration = duration;
        return this;
    }

    public DefaultPlanPhase setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlanPhase)) {
            return false;
        }
        DefaultPlanPhase that = (DefaultPlanPhase)((Object)o);
        if (this.duration != null ? !this.duration.equals((Object)that.duration) : that.duration != null) {
            return false;
        }
        if (this.fixed != null ? !this.fixed.equals((Object)that.fixed) : that.fixed != null) {
            return false;
        }
        if (this.recurring != null ? !this.recurring.equals((Object)that.recurring) : that.recurring != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.fixed != null ? this.fixed.hashCode() : 0);
        result = 31 * result + (this.recurring != null ? this.recurring.hashCode() : 0);
        return result;
    }
}

