/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPlan
extends ValidatingConfig<StandaloneCatalog>
implements Plan {
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlElement(required=false)
    private Date effectiveDateForExistingSubscriptions;
    @XmlElement(required=true)
    @XmlIDREF
    private DefaultProduct product;
    @XmlElementWrapper(name="initialPhases", required=false)
    @XmlElement(name="phase", required=false)
    private DefaultPlanPhase[] initialPhases;
    @XmlElement(name="finalPhase", required=true)
    private DefaultPlanPhase finalPhase;
    @XmlElement(required=false)
    private Integer plansAllowedInBundle = -1;
    private String priceListName;

    public DefaultPlan() {
        this.initialPhases = new DefaultPlanPhase[0];
    }

    public DefaultPlan(String planName, DefaultPlan in, PlanPhasePriceOverride[] overrides) {
        this.name = planName;
        this.effectiveDateForExistingSubscriptions = in.getEffectiveDateForExistingSubscriptions();
        this.product = (DefaultProduct)in.getProduct();
        this.initialPhases = new DefaultPlanPhase[in.getInitialPhases().length];
        for (int i = 0; i < overrides.length - 1; ++i) {
            DefaultPlanPhase newPhase;
            this.initialPhases[i] = newPhase = new DefaultPlanPhase(this, in.getInitialPhases()[i], overrides[i]);
        }
        this.finalPhase = new DefaultPlanPhase(this, in.getFinalPhase(), overrides[overrides.length - 1]);
        this.priceListName = in.getPriceListName();
    }

    public Date getEffectiveDateForExistingSubscriptions() {
        return this.effectiveDateForExistingSubscriptions;
    }

    public DefaultPlanPhase[] getInitialPhases() {
        return this.initialPhases;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getPriceListName() {
        return this.priceListName;
    }

    public String getName() {
        return this.name;
    }

    public DefaultPlanPhase getFinalPhase() {
        return this.finalPhase;
    }

    public PlanPhase[] getAllPhases() {
        int length = this.initialPhases == null || this.initialPhases.length == 0 ? 1 : this.initialPhases.length + 1;
        PlanPhase[] allPhases = new DefaultPlanPhase[length];
        int cnt = 0;
        if (length > 1) {
            for (DefaultPlanPhase cur : this.initialPhases) {
                allPhases[cnt++] = cur;
            }
        }
        allPhases[cnt++] = this.finalPhase;
        return allPhases;
    }

    public PlanPhase findPhase(String name) throws CatalogApiException {
        for (PlanPhase pp : this.getAllPhases()) {
            if (!pp.getName().equals(name)) continue;
            return pp;
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PHASE, new Object[]{name});
    }

    public BillingPeriod getRecurringBillingPeriod() {
        return this.finalPhase.getRecurring() != null ? this.finalPhase.getRecurring().getBillingPeriod() : BillingPeriod.NO_BILLING_PERIOD;
    }

    public int getPlansAllowedInBundle() {
        return this.plansAllowedInBundle;
    }

    public Iterator<PlanPhase> getInitialPhaseIterator() {
        ArrayList list = new ArrayList();
        Collections.addAll(list, this.initialPhases);
        return list.iterator();
    }

    public void initialize(StandaloneCatalog catalog, URI sourceURI) {
        super.initialize((Object)catalog, sourceURI);
        if (this.finalPhase != null) {
            this.finalPhase.setPlan(this);
            this.finalPhase.initialize(catalog, sourceURI);
        }
        if (this.initialPhases != null) {
            for (DefaultPlanPhase p : this.initialPhases) {
                p.setPlan(this);
                p.initialize(catalog, sourceURI);
            }
        }
        this.priceListName = this.priceListName != null ? this.priceListName : this.findPriceListForPlan(catalog);
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.effectiveDateForExistingSubscriptions != null && catalog.getEffectiveDate().getTime() > this.effectiveDateForExistingSubscriptions.getTime()) {
            errors.add((Object)new ValidationError(String.format("Price effective date %s is before catalog effective date '%s'", this.effectiveDateForExistingSubscriptions, catalog.getEffectiveDate().getTime()), catalog.getCatalogURI(), DefaultInternationalPrice.class, ""));
        }
        this.validateCollection((Object)catalog, errors, this.initialPhases);
        this.finalPhase.validate(catalog, errors);
        return errors;
    }

    public void setEffectiveDateForExistingSubscriptions(Date effectiveDateForExistingSubscriptions) {
        this.effectiveDateForExistingSubscriptions = effectiveDateForExistingSubscriptions;
    }

    public DefaultPlan setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultPlan setFinalPhase(DefaultPlanPhase finalPhase) {
        this.finalPhase = finalPhase;
        return this;
    }

    public DefaultPlan setProduct(Product product) {
        this.product = (DefaultProduct)product;
        return this;
    }

    public DefaultPlan setPriceListName(String priceListName) {
        this.priceListName = priceListName;
        return this;
    }

    public DefaultPlan setInitialPhases(DefaultPlanPhase[] phases) {
        this.initialPhases = phases;
        return this;
    }

    public DefaultPlan setPlansAllowedInBundle(Integer plansAllowedInBundle) {
        this.plansAllowedInBundle = plansAllowedInBundle;
        return this;
    }

    public DateTime dateOfFirstRecurringNonZeroCharge(DateTime subscriptionStartDate, PhaseType initialPhaseType) {
        DateTime result = subscriptionStartDate;
        boolean skipPhase = initialPhaseType != null;
        for (PlanPhase phase : this.getAllPhases()) {
            Recurring recurring;
            if (skipPhase) {
                if (phase.getPhaseType() != initialPhaseType) continue;
                skipPhase = false;
            }
            if ((recurring = phase.getRecurring()) != null && recurring.getRecurringPrice() != null && !recurring.getRecurringPrice().isZero()) break;
            try {
                result = phase.getDuration().addToDateTime(result);
            }
            catch (CatalogApiException ignored) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlan)) {
            return false;
        }
        DefaultPlan that = (DefaultPlan)((Object)o);
        if (this.effectiveDateForExistingSubscriptions != null ? !this.effectiveDateForExistingSubscriptions.equals(that.effectiveDateForExistingSubscriptions) : that.effectiveDateForExistingSubscriptions != null) {
            return false;
        }
        if (this.finalPhase != null ? !this.finalPhase.equals((Object)that.finalPhase) : that.finalPhase != null) {
            return false;
        }
        if (!Arrays.equals((Object[])this.initialPhases, (Object[])that.initialPhases)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.plansAllowedInBundle != null ? !this.plansAllowedInBundle.equals(that.plansAllowedInBundle) : that.plansAllowedInBundle != null) {
            return false;
        }
        return !(this.product != null ? !this.product.equals((Object)that.product) : that.product != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.effectiveDateForExistingSubscriptions != null ? this.effectiveDateForExistingSubscriptions.hashCode() : 0);
        result = 31 * result + (this.initialPhases != null ? Arrays.hashCode((Object[])this.initialPhases) : 0);
        result = 31 * result + (this.finalPhase != null ? this.finalPhase.hashCode() : 0);
        result = 31 * result + (this.plansAllowedInBundle != null ? this.plansAllowedInBundle.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultPlan [name=" + this.name + ", effectiveDateForExistingSubscriptions=" + this.effectiveDateForExistingSubscriptions + ", product=" + (Object)((Object)this.product) + ", initialPhases=" + Arrays.toString((Object[])this.initialPhases) + ", finalPhase=" + (Object)((Object)this.finalPhase) + ", plansAllowedInBundle=" + this.plansAllowedInBundle + "]";
    }

    private String findPriceListForPlan(StandaloneCatalog catalog) {
        for (PriceList cur : catalog.getPriceLists().getAllPriceLists()) {
            DefaultPriceList curDefaultPriceList = (DefaultPriceList)cur;
            if (curDefaultPriceList.findPlan(this.name) == null) continue;
            return curDefaultPriceList.getName();
        }
        throw new IllegalStateException("Cannot extract pricelist for plan " + this.name);
    }
}

