/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Price;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultInternationalPrice
extends ValidatingConfig<StandaloneCatalog>
implements InternationalPrice {
    @XmlElement(name="price")
    private DefaultPrice[] prices;

    public Price[] getPrices() {
        return this.prices;
    }

    public DefaultInternationalPrice() {
    }

    public DefaultInternationalPrice(DefaultInternationalPrice in, PlanPhasePriceOverride override, boolean fixed) {
        this.prices = in.getPrices() != null ? new DefaultPrice[in.getPrices().length] : null;
        for (int i = 0; i < in.getPrices().length; ++i) {
            DefaultPrice curPrice = (DefaultPrice)in.getPrices()[i];
            this.prices[i] = curPrice.getCurrency().equals((Object)override.getCurrency()) ? new DefaultPrice(fixed ? override.getFixedPrice() : override.getRecurringPrice(), override.getCurrency()) : curPrice;
        }
    }

    public BigDecimal getPrice(Currency currency) throws CatalogApiException {
        for (DefaultPrice p : this.prices) {
            if (p.getCurrency() != currency) continue;
            return p.getValue();
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_PRICE_FOR_CURRENCY, new Object[]{currency});
    }

    public DefaultInternationalPrice setPrices(DefaultPrice[] prices) {
        this.prices = prices;
        return this;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        Currency[] supportedCurrencies = catalog.getCurrentSupportedCurrencies();
        for (DefaultPrice p : this.prices) {
            Currency currency = p.getCurrency();
            if (!this.currencyIsSupported(currency, supportedCurrencies)) {
                errors.add("Unsupported currency: " + currency, catalog.getCatalogURI(), ((Object)((Object)this)).getClass(), "");
            }
            try {
                if (!(p.getValue().doubleValue() < 0.0)) continue;
                errors.add("Negative value for price in currency: " + currency, catalog.getCatalogURI(), ((Object)((Object)this)).getClass(), "");
            }
            catch (CurrencyValueNull e) {
                // empty catch block
            }
        }
        return errors;
    }

    private boolean currencyIsSupported(Currency currency, Currency[] supportedCurrencies) {
        for (Currency c : supportedCurrencies) {
            if (c != currency) continue;
            return true;
        }
        return false;
    }

    public void initialize(StandaloneCatalog root, URI uri) {
        if (this.prices == null) {
            this.prices = this.getZeroPrice(root);
        }
        super.initialize((Object)root, uri);
    }

    private synchronized DefaultPrice[] getZeroPrice(StandaloneCatalog root) {
        Currency[] currencies = root.getCurrentSupportedCurrencies();
        DefaultPrice[] zeroPrice = new DefaultPrice[currencies.length];
        for (int i = 0; i < currencies.length; ++i) {
            zeroPrice[i] = new DefaultPrice();
            zeroPrice[i].setCurrency(currencies[i]);
            zeroPrice[i].setValue(new BigDecimal(0));
        }
        return zeroPrice;
    }

    public boolean isZero() {
        for (DefaultPrice price : this.prices) {
            try {
                if (price.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
                return false;
            }
            catch (CurrencyValueNull e) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInternationalPrice)) {
            return false;
        }
        DefaultInternationalPrice that = (DefaultInternationalPrice)((Object)o);
        return Arrays.equals((Object[])this.prices, (Object[])that.prices);
    }

    public int hashCode() {
        return this.prices != null ? Arrays.hashCode((Object[])this.prices) : 0;
    }
}

