/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultDuration
extends ValidatingConfig<StandaloneCatalog>
implements Duration {
    public static final int DEFAULT_DURATION_NUMBER = -1;
    @XmlElement(required=true)
    private TimeUnit unit;
    @XmlElement(required=false)
    private Integer number = -1;

    public TimeUnit getUnit() {
        return this.unit;
    }

    public int getNumber() {
        return this.number;
    }

    public DateTime addToDateTime(DateTime dateTime) throws CatalogApiException {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return dateTime;
        }
        switch (this.unit) {
            case DAYS: {
                return dateTime.plusDays(this.number.intValue());
            }
            case MONTHS: {
                return dateTime.plusMonths(this.number.intValue());
            }
            case YEARS: {
                return dateTime.plusYears(this.number.intValue());
            }
        }
        throw new CatalogApiException(ErrorCode.CAT_UNDEFINED_DURATION, new Object[]{this.unit});
    }

    public LocalDate addToLocalDate(LocalDate localDate) throws CatalogApiException {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return localDate;
        }
        switch (this.unit) {
            case DAYS: {
                return localDate.plusDays(this.number.intValue());
            }
            case MONTHS: {
                return localDate.plusMonths(this.number.intValue());
            }
            case YEARS: {
                return localDate.plusYears(this.number.intValue());
            }
        }
        throw new CatalogApiException(ErrorCode.CAT_UNDEFINED_DURATION, new Object[]{this.unit});
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.unit == TimeUnit.UNLIMITED && this.number != -1) {
            errors.add((Object)new ValidationError("Duration can only have 'UNLIMITED' unit if the number is omitted.", catalog.getCatalogURI(), DefaultPlanPhase.class, ""));
        }
        return errors;
    }

    public DefaultDuration setUnit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    public DefaultDuration setNumber(Integer number) {
        this.number = number;
        return this;
    }

    public Period toJodaPeriod() {
        if (this.number == null && this.unit != TimeUnit.UNLIMITED) {
            return new Period();
        }
        switch (this.unit) {
            case DAYS: {
                return new Period().withDays(this.number.intValue());
            }
            case MONTHS: {
                return new Period().withMonths(this.number.intValue());
            }
            case YEARS: {
                return new Period().withYears(this.number.intValue());
            }
            case UNLIMITED: {
                return new Period().withYears(100);
            }
        }
        return new Period();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultDuration)) {
            return false;
        }
        DefaultDuration that = (DefaultDuration)((Object)o);
        if (this.number != null ? !this.number.equals(that.number) : that.number != null) {
            return false;
        }
        return this.unit == that.unit;
    }

    public int hashCode() {
        int result = this.unit != null ? this.unit.hashCode() : 0;
        result = 31 * result + (this.number != null ? this.number.hashCode() : 0);
        return result;
    }
}

