/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Block;
import org.killbill.billing.catalog.api.BlockType;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultBlock
extends ValidatingConfig<StandaloneCatalog>
implements Block {
    @XmlAttribute(required=false)
    private BlockType type = BlockType.VANILLA;
    @XmlElement(required=true)
    @XmlIDREF
    private DefaultUnit unit;
    @XmlElement(required=true)
    private Double size;
    @XmlElement(required=true)
    private DefaultInternationalPrice prices;
    @XmlElement(required=false)
    private Double minTopUpCredit;
    private PlanPhase phase;

    public BlockType getType() {
        return this.type;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Double getSize() {
        return this.size;
    }

    public InternationalPrice getPrice() {
        return this.prices;
    }

    public Double getMinTopUpCredit() throws CatalogApiException {
        if (this.minTopUpCredit != null && this.type != BlockType.TOP_UP) {
            throw new CatalogApiException(ErrorCode.CAT_NOT_TOP_UP_BLOCK, new Object[]{this.phase.getName()});
        }
        return this.minTopUpCredit;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.type == BlockType.TOP_UP && this.minTopUpCredit == null) {
            errors.add((Object)new ValidationError(String.format("TOP_UP block needs to define minTopUpCredit for phase %s", this.phase.getName()), catalog.getCatalogURI(), DefaultUsage.class, ""));
        }
        return errors;
    }

    public DefaultBlock setType(BlockType type) {
        this.type = type;
        return this;
    }

    public DefaultBlock setPrices(DefaultInternationalPrice prices) {
        this.prices = prices;
        return this;
    }

    public DefaultBlock setUnit(DefaultUnit unit) {
        this.unit = unit;
        return this;
    }

    public DefaultBlock setSize(Double size) {
        this.size = size;
        return this;
    }

    public DefaultBlock setPrice(DefaultInternationalPrice prices) {
        this.prices = prices;
        return this;
    }

    public DefaultBlock setPhase(PlanPhase phase) {
        this.phase = phase;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultBlock)) {
            return false;
        }
        DefaultBlock that = (DefaultBlock)((Object)o);
        if (this.minTopUpCredit != null ? !this.minTopUpCredit.equals(that.minTopUpCredit) : that.minTopUpCredit != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.prices != null ? !this.prices.equals((Object)that.prices) : that.prices != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.unit != null ? !this.unit.equals((Object)that.unit) : that.unit != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.prices != null ? this.prices.hashCode() : 0);
        result = 31 * result + (this.minTopUpCredit != null ? this.minTopUpCredit.hashCode() : 0);
        return result;
    }
}

