/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultMutableStaticCatalog;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.SimplePlanDescriptor;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.catalog.rules.DefaultCaseBillingAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseCancelPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseCreateAlignment;
import org.killbill.billing.catalog.rules.DefaultCasePriceList;
import org.killbill.billing.catalog.rules.DefaultPlanRules;
import org.killbill.xmlloader.XMLWriter;

public class CatalogUpdater {
    private static URI DUMMY_URI;
    private final DefaultMutableStaticCatalog catalog;

    public CatalogUpdater(StandaloneCatalog standaloneCatalog) {
        this.catalog = new DefaultMutableStaticCatalog(standaloneCatalog);
    }

    public CatalogUpdater(String catalogName, BillingMode billingMode, DateTime effectiveDate, Currency ... currencies) {
        DefaultPriceList defaultPriceList = new DefaultPriceList().setName("DEFAULT");
        StandaloneCatalog tmp = new StandaloneCatalog().setCatalogName(catalogName).setEffectiveDate(effectiveDate.toDate()).setRecurringBillingMode(billingMode).setProducts((Iterable<Product>)ImmutableList.of()).setPlans((Iterable<Plan>)ImmutableList.of()).setPriceLists(new DefaultPriceListSet(defaultPriceList, new DefaultPriceList[0])).setPlanRules(this.getSaneDefaultPlanRules(defaultPriceList));
        if (currencies != null && currencies.length > 0) {
            tmp.setSupportedCurrencies(currencies);
        }
        tmp.initialize(tmp, DUMMY_URI);
        this.catalog = new DefaultMutableStaticCatalog(tmp);
    }

    public StandaloneCatalog getCatalog() {
        return this.catalog;
    }

    public String getCatalogXML() {
        try {
            return XMLWriter.writeXML((Object)((Object)this.catalog), StandaloneCatalog.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSimplePlanDescriptor(SimplePlanDescriptor desc) throws CatalogApiException {
        DefaultRecurring recurring;
        DefaultPlanPhase evergreenPhase;
        DefaultProduct product;
        if (desc == null || desc.getPlanId() == null) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_SIMPLE_PLAN_DESCRIPTOR, new Object[]{desc});
        }
        DefaultPlan plan = (DefaultPlan)this.getExistingPlan(desc.getPlanId());
        if (plan == null && desc.getProductName() == null) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_SIMPLE_PLAN_DESCRIPTOR, new Object[]{desc});
        }
        DefaultProduct defaultProduct = product = plan != null ? (DefaultProduct)plan.getProduct() : (DefaultProduct)this.getExistingProduct(desc.getProductName());
        if (product == null) {
            product = new DefaultProduct();
            product.setName(desc.getProductName());
            product.setCatagory(desc.getProductCategory());
            product.initialize(this.catalog, DUMMY_URI);
            this.catalog.addProduct(product);
        }
        if (plan == null) {
            this.validateNewPlanDescriptor(desc);
            plan = new DefaultPlan();
            plan.setName(desc.getPlanId());
            plan.setPriceListName("DEFAULT");
            plan.setProduct(product);
            if (desc.getTrialLength() > 0 && desc.getTrialTimeUnit() != TimeUnit.UNLIMITED) {
                DefaultPlanPhase trialPhase = new DefaultPlanPhase();
                trialPhase.setPhaseType(PhaseType.TRIAL);
                trialPhase.setDuration(new DefaultDuration().setUnit(desc.getTrialTimeUnit()).setNumber(desc.getTrialLength()));
                trialPhase.setFixed(new DefaultFixed().setFixedPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(desc.getCurrency()).setValue(BigDecimal.ZERO)})));
                plan.setInitialPhases(new DefaultPlanPhase[]{trialPhase});
            }
            this.catalog.addPlan(plan);
        } else {
            this.validateExistingPlan(plan, desc);
        }
        if (!this.isCurrencySupported(desc.getCurrency())) {
            this.catalog.addCurrency(desc.getCurrency());
            if (plan.getInitialPhases().length == 1) {
                ((DefaultInternationalPrice)plan.getInitialPhases()[0].getFixed().getPrice()).setPrices(null);
            }
        }
        if ((evergreenPhase = plan.getFinalPhase()) == null) {
            evergreenPhase = new DefaultPlanPhase();
            evergreenPhase.setPhaseType(PhaseType.EVERGREEN);
            evergreenPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.UNLIMITED));
            plan.setFinalPhase(evergreenPhase);
        }
        if ((recurring = (DefaultRecurring)evergreenPhase.getRecurring()) == null) {
            recurring = new DefaultRecurring();
            recurring.setBillingPeriod(desc.getBillingPeriod());
            recurring.setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[0]));
            evergreenPhase.setRecurring(recurring);
        }
        try {
            recurring.getRecurringPrice().getPrice(desc.getCurrency());
        }
        catch (CatalogApiException ignore) {
            this.catalog.addRecurringPriceToPlan(recurring.getRecurringPrice(), new DefaultPrice().setCurrency(desc.getCurrency()).setValue(desc.getAmount()));
        }
        if (desc.getProductCategory() == ProductCategory.ADD_ON) {
            for (String bp : desc.getAvailableBaseProducts()) {
                Product targetBasePlan = this.getExistingProduct(bp);
                boolean found = false;
                for (Product cur : targetBasePlan.getAvailable()) {
                    if (!cur.getName().equals(product.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.catalog.addProductAvailableAO(this.getExistingProduct(bp), product);
            }
        }
        this.catalog.initialize(this.catalog, DUMMY_URI);
    }

    private void validateExistingPlan(DefaultPlan plan, SimplePlanDescriptor desc) throws CatalogApiException {
        boolean failedValidation = false;
        if (plan.getInitialPhases().length > 1 || plan.getInitialPhases().length == 1 && (plan.getInitialPhases()[0].getPhaseType() != PhaseType.TRIAL || !plan.getInitialPhases()[0].getFixed().getPrice().isZero())) {
            failedValidation = true;
        } else if (desc.getTrialLength() != null && desc.getTrialTimeUnit() != null) {
            boolean isPlanConfiguredWithTrial;
            boolean isDescConfiguredWithTrial = desc.getTrialLength() > 0 && desc.getTrialTimeUnit() != TimeUnit.UNLIMITED;
            boolean bl = isPlanConfiguredWithTrial = plan.getInitialPhases().length == 1;
            if (isDescConfiguredWithTrial && !isPlanConfiguredWithTrial || !isDescConfiguredWithTrial && isPlanConfiguredWithTrial) {
                failedValidation = true;
            } else if (isDescConfiguredWithTrial && isPlanConfiguredWithTrial && (plan.getInitialPhases()[0].getDuration().getUnit() != desc.getTrialTimeUnit() || plan.getInitialPhases()[0].getDuration().getNumber() != desc.getTrialLength().intValue())) {
                failedValidation = true;
            }
        }
        if (!failedValidation) {
            if (plan.getFinalPhase().getPhaseType() != PhaseType.EVERGREEN) {
                failedValidation = true;
            } else if (desc.getBillingPeriod() != null && plan.getFinalPhase().getRecurring().getBillingPeriod() != desc.getBillingPeriod()) {
                failedValidation = true;
            } else if (desc.getCurrency() != null && desc.getAmount() != null) {
                try {
                    BigDecimal currentAmount = plan.getFinalPhase().getRecurring().getRecurringPrice().getPrice(desc.getCurrency());
                    if (currentAmount.compareTo(desc.getAmount()) != 0) {
                        failedValidation = true;
                    }
                }
                catch (CatalogApiException ignoreIfCurrencyIsCurrentlyUndefined) {
                    // empty catch block
                }
            }
        }
        if (failedValidation) {
            throw new CatalogApiException(ErrorCode.CAT_FAILED_SIMPLE_PLAN_VALIDATION, new Object[]{plan.toString(), desc.toString()});
        }
    }

    private boolean isCurrencySupported(Currency targetCurrency) {
        if (this.catalog.getCurrentSupportedCurrencies() != null) {
            for (Currency input : this.catalog.getCurrentSupportedCurrencies()) {
                if (!input.equals((Object)targetCurrency)) continue;
                return true;
            }
        }
        return false;
    }

    private void validateNewPlanDescriptor(SimplePlanDescriptor desc) throws CatalogApiException {
        if (desc.getProductCategory() == null || desc.getBillingPeriod() == null || desc.getAmount() == null || desc.getAmount().compareTo(BigDecimal.ZERO) <= 0 || desc.getCurrency() == null) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_SIMPLE_PLAN_DESCRIPTOR, new Object[]{desc});
        }
        if (desc.getProductCategory() == ProductCategory.ADD_ON) {
            if (desc.getAvailableBaseProducts() == null || desc.getAvailableBaseProducts().isEmpty()) {
                throw new CatalogApiException(ErrorCode.CAT_INVALID_SIMPLE_PLAN_DESCRIPTOR, new Object[]{desc});
            }
            for (String cur : desc.getAvailableBaseProducts()) {
                if (this.getExistingProduct(cur) != null) continue;
                throw new CatalogApiException(ErrorCode.CAT_INVALID_SIMPLE_PLAN_DESCRIPTOR, new Object[]{desc});
            }
        }
    }

    private Product getExistingProduct(String productName) {
        try {
            return this.catalog.findCurrentProduct(productName);
        }
        catch (CatalogApiException e) {
            return null;
        }
    }

    private Plan getExistingPlan(String planName) {
        try {
            return this.catalog.findCurrentPlan(planName);
        }
        catch (CatalogApiException e) {
            return null;
        }
    }

    private DefaultPlanRules getSaneDefaultPlanRules(DefaultPriceList defaultPriceList) {
        DefaultCaseChangePlanPolicy[] changePolicy = new DefaultCaseChangePlanPolicy[]{new DefaultCaseChangePlanPolicy()};
        changePolicy[0].setPolicy(BillingActionPolicy.IMMEDIATE);
        DefaultCaseChangePlanAlignment[] changeAlignment = new DefaultCaseChangePlanAlignment[]{new DefaultCaseChangePlanAlignment()};
        changeAlignment[0].setAlignment(PlanAlignmentChange.START_OF_BUNDLE);
        DefaultCaseCancelPolicy[] cancelPolicy = new DefaultCaseCancelPolicy[]{new DefaultCaseCancelPolicy()};
        cancelPolicy[0].setPolicy(BillingActionPolicy.IMMEDIATE);
        DefaultCaseCreateAlignment[] createAlignment = new DefaultCaseCreateAlignment[]{new DefaultCaseCreateAlignment()};
        createAlignment[0].setAlignment(PlanAlignmentCreate.START_OF_BUNDLE);
        DefaultCaseBillingAlignment[] billingAlignmentCase = new DefaultCaseBillingAlignment[]{new DefaultCaseBillingAlignment()};
        billingAlignmentCase[0].setAlignment(BillingAlignment.ACCOUNT);
        DefaultCasePriceList[] priceList = new DefaultCasePriceList[]{new DefaultCasePriceList()};
        priceList[0].setToPriceList(defaultPriceList);
        return new DefaultPlanRules().setChangeCase(changePolicy).setChangeAlignmentCase(changeAlignment).setCancelCase(cancelPolicy).setCreateAlignmentCase(createAlignment).setBillingAlignmentCase(billingAlignmentCase).setPriceListCase(priceList);
    }

    static {
        try {
            DUMMY_URI = new URI("dummy");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

