/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.api;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.payment.api.Refund;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PaymentApi {
    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createPayment(Account var1, UUID var2, BigDecimal var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_CREATE_EXTERNAL_PAYMENT})
    public Payment createExternalPayment(Account var1, UUID var2, BigDecimal var3, CallContext var4) throws PaymentApiException;

    public void notifyPendingPaymentOfStateChanged(Account var1, UUID var2, boolean var3, CallContext var4) throws PaymentApiException;

    public Payment retryPayment(Account var1, UUID var2, Iterable<PluginProperty> var3, CallContext var4) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND})
    public Refund createRefund(Account var1, UUID var2, BigDecimal var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    public void notifyPendingRefundOfStateChanged(Account var1, UUID var2, boolean var3, CallContext var4) throws PaymentApiException;

    public Refund getRefund(UUID var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND, Permission.INVOICE_CAN_ADJUST})
    public Refund createRefundWithAdjustment(Account var1, UUID var2, BigDecimal var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND, Permission.INVOICE_CAN_ITEM_ADJUST})
    public Refund createRefundWithItemsAdjustments(Account var1, UUID var2, Set<UUID> var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND, Permission.INVOICE_CAN_ITEM_ADJUST})
    public Refund createRefundWithItemsAdjustments(Account var1, UUID var2, Map<UUID, BigDecimal> var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    public List<Refund> getAccountRefunds(Account var1, TenantContext var2) throws PaymentApiException;

    public List<Refund> getPaymentRefunds(UUID var1, TenantContext var2) throws PaymentApiException;

    public List<Payment> getInvoicePayments(UUID var1, TenantContext var2) throws PaymentApiException;

    public List<Payment> getAccountPayments(UUID var1, TenantContext var2) throws PaymentApiException;

    public Payment getPayment(UUID var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public Pagination<Payment> getPayments(Long var1, Long var2, Iterable<PluginProperty> var3, TenantContext var4);

    public Pagination<Payment> getPayments(Long var1, Long var2, String var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public Pagination<Payment> searchPayments(String var1, Long var2, Long var3, Iterable<PluginProperty> var4, TenantContext var5);

    public Pagination<Payment> searchPayments(String var1, Long var2, Long var3, String var4, Iterable<PluginProperty> var5, TenantContext var6) throws PaymentApiException;

    public Pagination<Refund> getRefunds(Long var1, Long var2, Iterable<PluginProperty> var3, TenantContext var4);

    public Pagination<Refund> getRefunds(Long var1, Long var2, String var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public Pagination<Refund> searchRefunds(String var1, Long var2, Long var3, Iterable<PluginProperty> var4, TenantContext var5);

    public Pagination<Refund> searchRefunds(String var1, Long var2, Long var3, String var4, Iterable<PluginProperty> var5, TenantContext var6) throws PaymentApiException;

    public Set<String> getAvailablePlugins();

    public UUID addPaymentMethod(String var1, Account var2, boolean var3, PaymentMethodPlugin var4, Iterable<PluginProperty> var5, CallContext var6) throws PaymentApiException;

    public List<PaymentMethod> getPaymentMethods(Account var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public PaymentMethod getPaymentMethodById(UUID var1, boolean var2, boolean var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public Pagination<PaymentMethod> getPaymentMethods(Long var1, Long var2, Iterable<PluginProperty> var3, TenantContext var4);

    public Pagination<PaymentMethod> getPaymentMethods(Long var1, Long var2, String var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public Pagination<PaymentMethod> searchPaymentMethods(String var1, Long var2, Long var3, Iterable<PluginProperty> var4, TenantContext var5);

    public Pagination<PaymentMethod> searchPaymentMethods(String var1, Long var2, Long var3, String var4, Iterable<PluginProperty> var5, TenantContext var6) throws PaymentApiException;

    public void deletedPaymentMethod(Account var1, UUID var2, boolean var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    public void setDefaultPaymentMethod(Account var1, UUID var2, Iterable<PluginProperty> var3, CallContext var4) throws PaymentApiException;

    public List<PaymentMethod> refreshPaymentMethods(String var1, Account var2, Iterable<PluginProperty> var3, CallContext var4) throws PaymentApiException;

    public List<PaymentMethod> refreshPaymentMethods(Account var1, Iterable<PluginProperty> var2, CallContext var3) throws PaymentApiException;
}

