/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api;

import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.entity.Entity;

public interface Entitlement
extends Entity {
    public UUID getBaseEntitlementId();

    public UUID getBundleId();

    public UUID getAccountId();

    public String getExternalKey();

    public EntitlementState getState();

    public EntitlementSourceType getSourceType();

    public LocalDate getEffectiveStartDate();

    public LocalDate getEffectiveEndDate();

    public Product getLastActiveProduct();

    public Plan getLastActivePlan();

    public PlanPhase getLastActivePhase();

    public PriceList getLastActivePriceList();

    public ProductCategory getLastActiveProductCategory();

    public Entitlement cancelEntitlementWithDate(LocalDate var1, boolean var2, CallContext var3) throws EntitlementApiException;

    public Entitlement cancelEntitlementWithPolicy(EntitlementActionPolicy var1, CallContext var2) throws EntitlementApiException;

    public Entitlement cancelEntitlementWithDateOverrideBillingPolicy(LocalDate var1, BillingActionPolicy var2, CallContext var3) throws EntitlementApiException;

    public Entitlement cancelEntitlementWithPolicyOverrideBillingPolicy(EntitlementActionPolicy var1, BillingActionPolicy var2, CallContext var3) throws EntitlementApiException;

    public void uncancelEntitlement(CallContext var1) throws EntitlementApiException;

    public Entitlement changePlan(String var1, BillingPeriod var2, String var3, CallContext var4) throws EntitlementApiException;

    public Entitlement changePlanWithDate(String var1, BillingPeriod var2, String var3, LocalDate var4, CallContext var5) throws EntitlementApiException;

    public Entitlement changePlanOverrideBillingPolicy(String var1, BillingPeriod var2, String var3, LocalDate var4, BillingActionPolicy var5, CallContext var6) throws EntitlementApiException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementSourceType {
        NATIVE,
        MIGRATED,
        TRANSFERRED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementState {
        ACTIVE,
        BLOCKED,
        CANCELLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementActionPolicy {
        IMMEDIATE,
        END_OF_TERM;

    }
}

