/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api;

import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.OrderingType;
import org.killbill.billing.entitlement.api.BlockingState;
import org.killbill.billing.entitlement.api.BlockingStateType;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.Subscription;
import org.killbill.billing.entitlement.api.SubscriptionApiException;
import org.killbill.billing.entitlement.api.SubscriptionBundle;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.api.AuditLevel;
import org.killbill.billing.util.audit.AuditLogWithHistory;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SubscriptionApi
extends KillbillApi {
    public static final int PAST_EVENTS = 1;
    public static final int PRESENT_EVENTS = 2;
    public static final int FUTURE_EVENTS = 4;
    public static final int PAST_OR_PRESENT_EVENTS = 3;
    public static final int FUTURE_OR_PRESENT_EVENTS = 6;
    public static final int ALL_EVENTS = 7;

    public Subscription getSubscriptionForEntitlementId(UUID var1, TenantContext var2) throws SubscriptionApiException;

    public SubscriptionBundle getSubscriptionBundle(UUID var1, TenantContext var2) throws SubscriptionApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public void updateExternalKey(UUID var1, String var2, CallContext var3) throws EntitlementApiException;

    public List<SubscriptionBundle> getSubscriptionBundlesForAccountIdAndExternalKey(UUID var1, String var2, TenantContext var3) throws SubscriptionApiException;

    public SubscriptionBundle getActiveSubscriptionBundleForExternalKey(String var1, TenantContext var2) throws SubscriptionApiException;

    public List<SubscriptionBundle> getSubscriptionBundlesForExternalKey(String var1, TenantContext var2) throws SubscriptionApiException;

    public List<SubscriptionBundle> getSubscriptionBundlesForAccountId(UUID var1, TenantContext var2) throws SubscriptionApiException;

    public Pagination<SubscriptionBundle> getSubscriptionBundles(Long var1, Long var2, TenantContext var3);

    public Pagination<SubscriptionBundle> searchSubscriptionBundles(String var1, Long var2, Long var3, TenantContext var4);

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_PAUSE_RESUME})
    public void addBlockingState(BlockingState var1, LocalDate var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    public Iterable<BlockingState> getBlockingStates(UUID var1, List<BlockingStateType> var2, List<String> var3, OrderingType var4, int var5, TenantContext var6) throws EntitlementApiException;

    public List<AuditLogWithHistory> getSubscriptionBundleAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);

    public List<AuditLogWithHistory> getSubscriptionAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);

    public List<AuditLogWithHistory> getSubscriptionEventAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);

    public List<AuditLogWithHistory> getBlockingStateAuditLogsWithHistoryForId(UUID var1, AuditLevel var2, TenantContext var3);
}

