/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api;

import java.util.Collection;
import java.util.Date;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverridesWithCallContext;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Catalog {
    public String getCatalogName();

    public Date getStandaloneCatalogEffectiveDate(DateTime var1) throws CatalogApiException;

    public Currency[] getSupportedCurrencies(DateTime var1) throws CatalogApiException;

    public Collection<Product> getProducts(DateTime var1) throws CatalogApiException;

    public Collection<Plan> getPlans(DateTime var1) throws CatalogApiException;

    public PriceListSet getPriceLists(DateTime var1) throws CatalogApiException;

    public Plan findPlan(String var1, DateTime var2) throws CatalogApiException;

    public Plan createOrFindPlan(PlanSpecifier var1, PlanPhasePriceOverridesWithCallContext var2, DateTime var3) throws CatalogApiException;

    public Plan findPlan(String var1, DateTime var2, DateTime var3) throws CatalogApiException;

    public Plan createOrFindPlan(PlanSpecifier var1, PlanPhasePriceOverridesWithCallContext var2, DateTime var3, DateTime var4) throws CatalogApiException;

    public Product findProduct(String var1, DateTime var2) throws CatalogApiException;

    public PriceList findPriceList(String var1, DateTime var2) throws CatalogApiException;

    public PriceList findPriceListForPlan(String var1, DateTime var2, DateTime var3) throws CatalogApiException;

    public PlanPhase findPhase(String var1, DateTime var2, DateTime var3) throws CatalogApiException;

    public BillingActionPolicy planChangePolicy(PlanPhaseSpecifier var1, PlanSpecifier var2, DateTime var3) throws CatalogApiException;

    public PlanChangeResult planChange(PlanPhaseSpecifier var1, PlanSpecifier var2, DateTime var3) throws CatalogApiException;

    public BillingActionPolicy planCancelPolicy(PlanPhaseSpecifier var1, DateTime var2) throws CatalogApiException;

    public PlanAlignmentCreate planCreateAlignment(PlanSpecifier var1, DateTime var2) throws CatalogApiException;

    public BillingAlignment billingAlignment(PlanPhaseSpecifier var1, DateTime var2) throws CatalogApiException;

    public PlanAlignmentChange planChangeAlignment(PlanPhaseSpecifier var1, PlanSpecifier var2, DateTime var3) throws CatalogApiException;

    public boolean canCreatePlan(PlanSpecifier var1, DateTime var2) throws CatalogApiException;
}

