/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api;

import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.entitlement.api.Entitlement;
import org.killbill.billing.entitlement.api.EntitlementAOStatusDryRun;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.entitlement.api.EntitlementSpecifier;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface EntitlementApi
extends KillbillApi {
    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public Entitlement createBaseEntitlement(UUID var1, PlanPhaseSpecifier var2, String var3, List<PlanPhasePriceOverride> var4, LocalDate var5, LocalDate var6, boolean var7, Iterable<PluginProperty> var8, CallContext var9) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public Entitlement createBaseEntitlementWithAddOns(UUID var1, String var2, Iterable<EntitlementSpecifier> var3, LocalDate var4, LocalDate var5, boolean var6, Iterable<PluginProperty> var7, CallContext var8) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public Entitlement addEntitlement(UUID var1, PlanPhaseSpecifier var2, List<PlanPhasePriceOverride> var3, LocalDate var4, LocalDate var5, boolean var6, Iterable<PluginProperty> var7, CallContext var8) throws EntitlementApiException;

    public List<EntitlementAOStatusDryRun> getDryRunStatusForChange(UUID var1, String var2, LocalDate var3, TenantContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_PAUSE_RESUME})
    public void pause(UUID var1, LocalDate var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_PAUSE_RESUME})
    public void resume(UUID var1, LocalDate var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    public Entitlement getEntitlementForId(UUID var1, TenantContext var2) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForBundle(UUID var1, TenantContext var2) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForAccountIdAndExternalKey(UUID var1, String var2, TenantContext var3) throws EntitlementApiException;

    public List<Entitlement> getAllEntitlementsForAccountId(UUID var1, TenantContext var2) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_TRANSFER})
    public UUID transferEntitlements(UUID var1, UUID var2, String var3, LocalDate var4, Iterable<PluginProperty> var5, CallContext var6) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_TRANSFER})
    public UUID transferEntitlementsOverrideBillingPolicy(UUID var1, UUID var2, String var3, LocalDate var4, BillingActionPolicy var5, Iterable<PluginProperty> var6, CallContext var7) throws EntitlementApiException;
}

