/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.entitlement.api;

import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.entitlement.api.EntitlementApiException;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.entity.Entity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Entitlement
extends Entity {
    public UUID getBaseEntitlementId();

    public UUID getBundleId();

    public UUID getAccountId();

    public String getExternalKey();

    public EntitlementState getState();

    public EntitlementSourceType getSourceType();

    public LocalDate getEffectiveStartDate();

    public LocalDate getEffectiveEndDate();

    public Product getLastActiveProduct();

    public Plan getLastActivePlan();

    public PlanPhase getLastActivePhase();

    public PriceList getLastActivePriceList();

    public ProductCategory getLastActiveProductCategory();

    public Integer getBillCycleDayLocal();

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CANCEL})
    public Entitlement cancelEntitlementWithDate(LocalDate var1, boolean var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CANCEL})
    public Entitlement cancelEntitlementWithPolicy(EntitlementActionPolicy var1, Iterable<PluginProperty> var2, CallContext var3) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CANCEL})
    public Entitlement cancelEntitlementWithDateOverrideBillingPolicy(LocalDate var1, BillingActionPolicy var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CANCEL})
    public Entitlement cancelEntitlementWithPolicyOverrideBillingPolicy(EntitlementActionPolicy var1, BillingActionPolicy var2, Iterable<PluginProperty> var3, CallContext var4) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CANCEL})
    public void uncancelEntitlement(Iterable<PluginProperty> var1, CallContext var2) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CHANGE_PLAN})
    public Entitlement changePlan(String var1, BillingPeriod var2, String var3, List<PlanPhasePriceOverride> var4, Iterable<PluginProperty> var5, CallContext var6) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CHANGE_PLAN})
    public Entitlement changePlanWithDate(String var1, BillingPeriod var2, String var3, List<PlanPhasePriceOverride> var4, LocalDate var5, Iterable<PluginProperty> var6, CallContext var7) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CHANGE_PLAN})
    public Entitlement changePlanOverrideBillingPolicy(String var1, BillingPeriod var2, String var3, List<PlanPhasePriceOverride> var4, LocalDate var5, BillingActionPolicy var6, Iterable<PluginProperty> var7, CallContext var8) throws EntitlementApiException;

    @RequiresPermissions(value={Permission.ENTITLEMENT_CAN_CREATE})
    public void updateBCD(int var1, LocalDate var2, CallContext var3) throws EntitlementApiException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementSourceType {
        NATIVE,
        MIGRATED,
        TRANSFERRED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementState {
        PENDING,
        ACTIVE,
        BLOCKED,
        CANCELLED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EntitlementActionPolicy {
        IMMEDIATE,
        END_OF_TERM;

    }
}

