/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.payment.api;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.account.api.Account;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.payment.api.Payment;
import org.killbill.billing.payment.api.PaymentApiException;
import org.killbill.billing.payment.api.PaymentMethod;
import org.killbill.billing.payment.api.PaymentMethodPlugin;
import org.killbill.billing.payment.api.PaymentOptions;
import org.killbill.billing.payment.api.PluginProperty;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface PaymentApi
extends KillbillApi {
    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createAuthorization(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, CallContext var9) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createAuthorizationWithPaymentControl(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, PaymentOptions var9, CallContext var10) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createCapture(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, Iterable<PluginProperty> var6, CallContext var7) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createCaptureWithPaymentControl(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, Iterable<PluginProperty> var6, PaymentOptions var7, CallContext var8) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createPurchase(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, CallContext var9) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createPurchaseWithPaymentControl(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, PaymentOptions var9, CallContext var10) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createVoid(Account var1, UUID var2, String var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createVoidWithPaymentControl(Account var1, UUID var2, String var3, Iterable<PluginProperty> var4, PaymentOptions var5, CallContext var6) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND})
    public Payment createRefund(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, Iterable<PluginProperty> var6, CallContext var7) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_REFUND})
    public Payment createRefundWithPaymentControl(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, Iterable<PluginProperty> var6, PaymentOptions var7, CallContext var8) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createCredit(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, CallContext var9) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_TRIGGER_PAYMENT})
    public Payment createCreditWithPaymentControl(Account var1, UUID var2, UUID var3, BigDecimal var4, Currency var5, String var6, String var7, Iterable<PluginProperty> var8, PaymentOptions var9, CallContext var10) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_CHARGEBACK})
    public Payment createChargeback(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, CallContext var6) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_CHARGEBACK})
    public Payment createChargebackWithPaymentControl(Account var1, UUID var2, BigDecimal var3, Currency var4, String var5, PaymentOptions var6, CallContext var7) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_CHARGEBACK})
    public Payment createChargebackReversal(Account var1, UUID var2, String var3, CallContext var4) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_CAN_CHARGEBACK})
    public Payment createChargebackReversalWithPaymentControl(Account var1, UUID var2, String var3, PaymentOptions var4, CallContext var5) throws PaymentApiException;

    public Payment notifyPendingTransactionOfStateChanged(Account var1, UUID var2, boolean var3, CallContext var4) throws PaymentApiException;

    public Payment notifyPendingTransactionOfStateChangedWithPaymentControl(Account var1, UUID var2, boolean var3, PaymentOptions var4, CallContext var5) throws PaymentApiException;

    public List<Payment> getAccountPayments(UUID var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public Payment getPayment(UUID var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public Payment getPaymentByExternalKey(String var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public Pagination<Payment> getPayments(Long var1, Long var2, boolean var3, Iterable<PluginProperty> var4, TenantContext var5);

    public Pagination<Payment> getPayments(Long var1, Long var2, String var3, boolean var4, Iterable<PluginProperty> var5, TenantContext var6) throws PaymentApiException;

    public Pagination<Payment> searchPayments(String var1, Long var2, Long var3, boolean var4, Iterable<PluginProperty> var5, TenantContext var6);

    public Pagination<Payment> searchPayments(String var1, Long var2, Long var3, String var4, boolean var5, Iterable<PluginProperty> var6, TenantContext var7) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_METHOD_CAN_CREATE})
    public UUID addPaymentMethod(Account var1, String var2, String var3, boolean var4, PaymentMethodPlugin var5, Iterable<PluginProperty> var6, CallContext var7) throws PaymentApiException;

    public List<PaymentMethod> getAccountPaymentMethods(UUID var1, boolean var2, Iterable<PluginProperty> var3, TenantContext var4) throws PaymentApiException;

    public PaymentMethod getPaymentMethodById(UUID var1, boolean var2, boolean var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public PaymentMethod getPaymentMethodByExternalKey(String var1, boolean var2, boolean var3, Iterable<PluginProperty> var4, TenantContext var5) throws PaymentApiException;

    public Pagination<PaymentMethod> getPaymentMethods(Long var1, Long var2, boolean var3, Iterable<PluginProperty> var4, TenantContext var5);

    public Pagination<PaymentMethod> getPaymentMethods(Long var1, Long var2, String var3, boolean var4, Iterable<PluginProperty> var5, TenantContext var6) throws PaymentApiException;

    public Pagination<PaymentMethod> searchPaymentMethods(String var1, Long var2, Long var3, boolean var4, Iterable<PluginProperty> var5, TenantContext var6);

    public Pagination<PaymentMethod> searchPaymentMethods(String var1, Long var2, Long var3, String var4, boolean var5, Iterable<PluginProperty> var6, TenantContext var7) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_METHOD_CAN_DELETE})
    public void deletePaymentMethod(Account var1, UUID var2, boolean var3, Iterable<PluginProperty> var4, CallContext var5) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_METHOD_CAN_CREATE})
    public void setDefaultPaymentMethod(Account var1, UUID var2, Iterable<PluginProperty> var3, CallContext var4) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_METHOD_CAN_UPDATE})
    public List<PaymentMethod> refreshPaymentMethods(Account var1, String var2, Iterable<PluginProperty> var3, CallContext var4) throws PaymentApiException;

    @RequiresPermissions(value={Permission.PAYMENT_METHOD_CAN_UPDATE})
    public List<PaymentMethod> refreshPaymentMethods(Account var1, Iterable<PluginProperty> var2, CallContext var3) throws PaymentApiException;
}

