/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.invoice.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.joda.time.LocalDate;
import org.killbill.billing.KillbillApi;
import org.killbill.billing.account.api.AccountApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.invoice.api.DryRunArguments;
import org.killbill.billing.invoice.api.Invoice;
import org.killbill.billing.invoice.api.InvoiceApiException;
import org.killbill.billing.invoice.api.InvoiceItem;
import org.killbill.billing.security.Permission;
import org.killbill.billing.security.RequiresPermissions;
import org.killbill.billing.util.api.TagApiException;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.billing.util.entity.Pagination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface InvoiceUserApi
extends KillbillApi {
    public List<Invoice> getInvoicesByAccount(UUID var1, TenantContext var2);

    public List<Invoice> getInvoicesByAccount(UUID var1, LocalDate var2, TenantContext var3);

    public Pagination<Invoice> getInvoices(Long var1, Long var2, TenantContext var3);

    public Pagination<Invoice> searchInvoices(String var1, Long var2, Long var3, TenantContext var4);

    public BigDecimal getAccountBalance(UUID var1, TenantContext var2);

    public BigDecimal getAccountCBA(UUID var1, TenantContext var2);

    public Invoice getInvoice(UUID var1, TenantContext var2) throws InvoiceApiException;

    public Invoice getInvoiceByPayment(UUID var1, TenantContext var2) throws InvoiceApiException;

    public Invoice getInvoiceByNumber(Integer var1, TenantContext var2) throws InvoiceApiException;

    public Collection<Invoice> getUnpaidInvoicesByAccountId(UUID var1, LocalDate var2, TenantContext var3);

    @RequiresPermissions(value={Permission.INVOICE_CAN_TRIGGER_INVOICE})
    public Invoice triggerInvoiceGeneration(UUID var1, LocalDate var2, DryRunArguments var3, CallContext var4) throws InvoiceApiException;

    public void tagInvoiceAsWrittenOff(UUID var1, CallContext var2) throws TagApiException, InvoiceApiException;

    public void tagInvoiceAsNotWrittenOff(UUID var1, CallContext var2) throws TagApiException, InvoiceApiException;

    public InvoiceItem getExternalChargeById(UUID var1, TenantContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.ACCOUNT_CAN_CHARGE})
    public List<InvoiceItem> insertExternalCharges(UUID var1, LocalDate var2, Iterable<InvoiceItem> var3, CallContext var4) throws InvoiceApiException;

    public InvoiceItem getCreditById(UUID var1, TenantContext var2) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.ACCOUNT_CAN_CREDIT})
    public InvoiceItem insertCredit(UUID var1, BigDecimal var2, LocalDate var3, Currency var4, CallContext var5) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_CREDIT})
    public InvoiceItem insertCreditForInvoice(UUID var1, UUID var2, BigDecimal var3, LocalDate var4, Currency var5, CallContext var6) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_ITEM_ADJUST})
    public InvoiceItem insertInvoiceItemAdjustment(UUID var1, UUID var2, UUID var3, LocalDate var4, CallContext var5) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_ITEM_ADJUST})
    public InvoiceItem insertInvoiceItemAdjustment(UUID var1, UUID var2, UUID var3, LocalDate var4, BigDecimal var5, Currency var6, CallContext var7) throws InvoiceApiException;

    @RequiresPermissions(value={Permission.INVOICE_CAN_DELETE_CBA})
    public void deleteCBA(UUID var1, UUID var2, UUID var3, CallContext var4) throws InvoiceApiException;

    public String getInvoiceAsHTML(UUID var1, TenantContext var2) throws AccountApiException, IOException, InvoiceApiException;

    public void consumeExstingCBAOnAccountWithUnpaidInvoices(UUID var1, CallContext var2);
}

